/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory.strings;

import io.nanovc.Area;
import io.nanovc.AreaFactory;
import io.nanovc.Clock;
import io.nanovc.Comparison;
import io.nanovc.ComparisonEngine;
import io.nanovc.ComparisonHandler;
import io.nanovc.Content;
import io.nanovc.ContentFactory;
import io.nanovc.Difference;
import io.nanovc.DifferenceEngine;
import io.nanovc.DifferenceHandler;
import io.nanovc.MergeEngine;
import io.nanovc.MergeHandler;
import io.nanovc.SearchParameters;
import io.nanovc.SearchQueryDefinition;
import io.nanovc.Timestamp;
import io.nanovc.areas.StringHashMapArea;
import io.nanovc.clocks.ClockWithVMNanos;
import io.nanovc.comparisons.HashMapComparisonHandler;
import io.nanovc.content.StringContent;
import io.nanovc.differences.HashMapDifferenceHandler;
import io.nanovc.indexes.ByteArrayIndex;
import io.nanovc.indexes.HashWrapperByteArrayIndex;
import io.nanovc.memory.MemoryCommit;
import io.nanovc.memory.MemorySearchQuery;
import io.nanovc.memory.MemorySearchResults;
import io.nanovc.memory.strings.StringMemoryRepo;
import io.nanovc.memory.strings.StringMemoryRepoEngine;
import io.nanovc.memory.strings.StringMemoryRepoEngineAPI;
import io.nanovc.memory.strings.StringMemoryRepoHandlerAPI;
import io.nanovc.merges.LastWinsMergeHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class StringNanoRepo
extends StringMemoryRepo
implements StringMemoryRepoHandlerAPI<StringContent, StringHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, StringMemoryRepo, StringMemoryRepoEngineAPI<StringContent, StringHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, StringMemoryRepo>> {
    private ByteArrayIndex byteArrayIndex;
    private StringMemoryRepoEngineAPI<StringContent, StringHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, StringMemoryRepo> engine = COMMON_ENGINE;
    public static final StringMemoryRepoEngineAPI<StringContent, StringHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, StringMemoryRepo> COMMON_ENGINE = new StringMemoryRepoEngine();
    private Clock<? extends Timestamp> clock = COMMON_CLOCK;
    public static final ClockWithVMNanos COMMON_CLOCK = new ClockWithVMNanos();
    private Charset encoding = StandardCharsets.UTF_8;
    private DifferenceHandler<? extends DifferenceEngine> differenceHandler = COMMON_DIFFERENCE_HANDLER;
    public static final HashMapDifferenceHandler COMMON_DIFFERENCE_HANDLER = new HashMapDifferenceHandler();
    private ComparisonHandler<? extends ComparisonEngine> comparisonHandler = COMMON_COMPARISON_HANDLER;
    public static final HashMapComparisonHandler COMMON_COMPARISON_HANDLER = new HashMapComparisonHandler();
    private MergeHandler<? extends MergeEngine> mergeHandler = COMMON_MERGE_HANDLER;
    public static final LastWinsMergeHandler COMMON_MERGE_HANDLER = new LastWinsMergeHandler();

    public StringNanoRepo(ByteArrayIndex byteArrayIndex) {
        this.byteArrayIndex = byteArrayIndex;
    }

    public StringNanoRepo() {
        this.byteArrayIndex = new HashWrapperByteArrayIndex();
    }

    public StringNanoRepo(ByteArrayIndex byteArrayIndex, StringMemoryRepoEngineAPI<StringContent, StringHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, StringMemoryRepo> engine, Clock<? extends Timestamp> clock, Charset encoding, DifferenceHandler<? extends DifferenceEngine> differenceHandler, ComparisonHandler<? extends ComparisonEngine> comparisonHandler, MergeHandler<? extends MergeEngine> mergeHandler) {
        this.byteArrayIndex = byteArrayIndex;
        this.engine = engine;
        this.clock = clock;
        this.encoding = encoding;
        this.differenceHandler = differenceHandler;
        this.comparisonHandler = comparisonHandler;
        this.mergeHandler = mergeHandler;
    }

    public StringHashMapArea createArea() {
        return new StringHashMapArea(this.getEncoding());
    }

    public MemoryCommit commit(StringHashMapArea contentAreaToCommit, String message) {
        return (MemoryCommit)((Object)this.getEngine().commit(contentAreaToCommit, message, this, this.getByteArrayIndex(), this.getClock()));
    }

    public MemoryCommit commit(StringHashMapArea contentAreaToCommit, String message, MemoryCommit parentCommit) {
        return this.getEngine().commit(contentAreaToCommit, message, this, this.getByteArrayIndex(), this.getClock(), parentCommit);
    }

    public MemoryCommit commit(StringHashMapArea contentAreaToCommit, String message, MemoryCommit firstParentCommit, MemoryCommit ... otherParentCommits) {
        return this.getEngine().commit(contentAreaToCommit, message, this, this.getByteArrayIndex(), this.getClock(), firstParentCommit, Arrays.asList(otherParentCommits));
    }

    public MemoryCommit commit(StringHashMapArea contentAreaToCommit, String message, MemoryCommit firstParentCommit, List<MemoryCommit> otherParentCommits) {
        return this.getEngine().commit(contentAreaToCommit, message, this, this.getByteArrayIndex(), this.getClock(), firstParentCommit, otherParentCommits);
    }

    public MemoryCommit commitToBranch(StringHashMapArea contentAreaToCommit, String branch, String message) {
        return (MemoryCommit)((Object)this.getEngine().commitToBranch(contentAreaToCommit, branch, message, this, this.getByteArrayIndex(), this.getClock()));
    }

    public void createBranchAtCommit(MemoryCommit commit, String branchName) {
        this.getEngine().createBranchAtCommit(commit, branchName, this);
    }

    public MemoryCommit getLatestCommitForBranch(String branchName) {
        return (MemoryCommit)((Object)this.getEngine().getLatestCommitForBranch(branchName, this));
    }

    public void checkoutIntoArea(MemoryCommit commit, StringHashMapArea areaToUpdate) {
        this.getEngine().checkoutIntoArea(commit, this, areaToUpdate, this::createContent);
    }

    public StringHashMapArea checkout(MemoryCommit commit) {
        return (StringHashMapArea)this.getEngine().checkout(commit, this, this::createArea, this::createContent);
    }

    public void tagCommit(MemoryCommit commit, String tagName) {
        this.getEngine().tagCommit(this, commit, tagName);
    }

    public MemoryCommit getCommitForTag(String tagName) {
        return (MemoryCommit)((Object)this.getEngine().getCommitForTag(this, tagName));
    }

    public void removeTag(String tagName) {
        this.getEngine().removeTag(this, tagName);
    }

    public Difference computeDifferenceBetweenAreas(Area<? extends StringContent> fromArea, Area<? extends StringContent> toArea) {
        return this.getEngine().computeDifferenceBetweenAreas(fromArea, toArea, this.getDifferenceHandler());
    }

    public Difference computeDifferenceBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.getEngine().computeDifferenceBetweenCommits(fromCommit, toCommit, this.getDifferenceHandler(), this, this::createArea, this::createContent);
    }

    public Difference computeDifferenceBetweenBranches(String fromBranchName, String toBranchName) {
        return this.getEngine().computeDifferenceBetweenBranches(fromBranchName, toBranchName, this.getDifferenceHandler(), this, this::createArea, this::createContent);
    }

    public Comparison computeComparisonBetweenAreas(Area<? extends StringContent> fromArea, Area<? extends StringContent> toArea) {
        return this.getEngine().computeComparisonBetweenAreas(fromArea, toArea, this.getComparisonHandler());
    }

    public Comparison computeComparisonBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.getEngine().computeComparisonBetweenCommits(fromCommit, toCommit, this.getComparisonHandler(), this, this::createArea, this::createContent);
    }

    public Comparison computeComparisonBetweenBranches(String fromBranchName, String toBranchName) {
        return this.getEngine().computeComparisonBetweenBranches(fromBranchName, toBranchName, this.getComparisonHandler(), this, this::createArea, this::createContent);
    }

    protected StringContent createContent(byte[] contentBytes) {
        return new StringContent(contentBytes, this.getEncoding());
    }

    public Set<String> getBranchNames() {
        return this.getEngine().getBranchNames(this);
    }

    public Set<String> getTagNames() {
        return this.getEngine().getTagNames(this);
    }

    public StringHashMapArea castOrCloneArea(Area<? extends Content> areaToCastOrClone) {
        return this.engine.castOrCloneArea(areaToCastOrClone, (AreaFactory<StringContent, StringHashMapArea>)((AreaFactory)this::createArea), (ContentFactory<StringContent>)((ContentFactory)this::createContent), this.byteArrayIndex);
    }

    public StringNanoRepo getRepo() {
        return this;
    }

    public void setRepo(StringMemoryRepo repo) {
        throw new IllegalArgumentException("Cannot set a string nano repo to another string nano repo. That doesn't make sense for Object Oriented nano repos.");
    }

    public StringMemoryRepoEngineAPI<StringContent, StringHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, StringMemoryRepo> getEngine() {
        return this.engine;
    }

    public void setEngine(StringMemoryRepoEngineAPI<StringContent, StringHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, StringMemoryRepo> engine) {
        this.engine = engine;
    }

    public DifferenceHandler<? extends DifferenceEngine> getDifferenceHandler() {
        return this.differenceHandler;
    }

    public void setDifferenceHandler(DifferenceHandler<? extends DifferenceEngine> differenceHandler) {
        this.differenceHandler = differenceHandler;
    }

    public ComparisonHandler<? extends ComparisonEngine> getComparisonHandler() {
        return this.comparisonHandler;
    }

    public void setComparisonHandler(ComparisonHandler<? extends ComparisonEngine> comparisonHandler) {
        this.comparisonHandler = comparisonHandler;
    }

    public MergeHandler<? extends MergeEngine> getMergeHandler() {
        return this.mergeHandler;
    }

    public void setMergeHandler(MergeHandler<? extends MergeEngine> mergeHandler) {
        this.mergeHandler = mergeHandler;
    }

    public MemorySearchQuery prepareSearchQuery(SearchQueryDefinition searchQueryDefinition) {
        return (MemorySearchQuery)((Object)this.getEngine().prepareSearchQuery(searchQueryDefinition));
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery) {
        return (MemorySearchResults)((Object)this.getEngine().searchWithQuery(searchQuery, null, this, this::createArea, this::createContent));
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery, SearchParameters overrideParameters) {
        return (MemorySearchResults)((Object)this.getEngine().searchWithQuery(searchQuery, overrideParameters, this, this::createArea, this::createContent));
    }

    public MemorySearchResults search(SearchQueryDefinition searchQueryDefinition) {
        MemorySearchQuery searchQuery = (MemorySearchQuery)((Object)this.engine.prepareSearchQuery(searchQueryDefinition));
        return (MemorySearchResults)((Object)this.engine.searchWithQuery(searchQuery, null, this, (AreaFactory<StringContent, StringHashMapArea>)((AreaFactory)this::createArea), (ContentFactory<StringContent>)((ContentFactory)this::createContent)));
    }

    public MemorySearchResults search(SearchQueryDefinition searchQueryDefinition, SearchParameters overrideParameters) {
        MemorySearchQuery searchQuery = (MemorySearchQuery)((Object)this.engine.prepareSearchQuery(searchQueryDefinition));
        return (MemorySearchResults)((Object)this.engine.searchWithQuery(searchQuery, overrideParameters, this, (AreaFactory<StringContent, StringHashMapArea>)((AreaFactory)this::createArea), (ContentFactory<StringContent>)((ContentFactory)this::createContent)));
    }

    public MemoryCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message) {
        return (MemoryCommit)((Object)this.getEngine().mergeIntoBranchFromAnotherBranch(destinationBranchName, sourceBranchName, message, this.mergeHandler, this.getComparisonHandler(), this.getDifferenceHandler(), this, this::createArea, this::createContent, this.getByteArrayIndex(), this.getClock()));
    }

    public ByteArrayIndex getByteArrayIndex() {
        return this.byteArrayIndex;
    }

    public void setByteArrayIndex(ByteArrayIndex byteArrayIndex) {
        this.byteArrayIndex = byteArrayIndex;
    }

    public Clock<? extends Timestamp> getClock() {
        return this.clock;
    }

    public void setClock(Clock<? extends Timestamp> clock) {
        this.clock = clock;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }
}

