/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory.reflective;

import io.nanovc.Area;
import io.nanovc.AreaEntry;
import io.nanovc.AreaFactory;
import io.nanovc.Clock;
import io.nanovc.Content;
import io.nanovc.ContentFactory;
import io.nanovc.RepoPath;
import io.nanovc.Timestamp;
import io.nanovc.indexes.ByteArrayIndex;
import io.nanovc.memory.MemoryCommitBase;
import io.nanovc.memory.MemoryRepoEngineBase;
import io.nanovc.memory.MemorySearchQueryBase;
import io.nanovc.memory.MemorySearchResultsBase;
import io.nanovc.memory.reflective.ReflectiveObjectMemoryRepoBase;
import io.nanovc.memory.reflective.ReflectiveObjectMemoryRepoEngineAPI;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public abstract class ReflectiveObjectMemoryRepoEngineBase<TContent extends Content, TArea extends Area<TContent>, TCommit extends MemoryCommitBase<TCommit>, TSearchQuery extends MemorySearchQueryBase<TCommit>, TSearchResults extends MemorySearchResultsBase<TCommit, TSearchQuery>, TRepo extends ReflectiveObjectMemoryRepoBase<TContent, TArea, TCommit>>
extends MemoryRepoEngineBase<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo>
implements ReflectiveObjectMemoryRepoEngineAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo> {
    public static final String NULL_OBJECT_TYPE = "NULL";
    public static final String NULL_VALUE = "\u0000";

    public void serializeObjectToContentArea(Object object, TArea area, ContentFactory<TContent> contentFactory, TRepo repo) {
        RepoPath objectTypeRepoPath = ((ReflectiveObjectMemoryRepoBase)repo).getObjectTypeRepoPath();
        if (object == null) {
            area.putContent(objectTypeRepoPath, contentFactory.createContent(NULL_OBJECT_TYPE.getBytes(StandardCharsets.UTF_8)));
        } else {
            Field[] fields;
            Class<?> objectClass = object.getClass();
            area.putContent(objectTypeRepoPath, contentFactory.createContent(objectClass.getName().getBytes()));
            RepoPath objectContentRepoPath = ((ReflectiveObjectMemoryRepoBase)repo).getObjectContentRepoPath();
            for (Field field : fields = objectClass.getFields()) {
                if (field.getType() != String.class) continue;
                try {
                    Object fieldValue = field.get(object);
                    String fieldStringValue = Objects.toString(fieldValue, NULL_VALUE);
                    RepoPath fieldPath = (RepoPath)objectContentRepoPath.resolve(field.getName());
                    area.putContent(fieldPath, contentFactory.createContent(fieldStringValue.getBytes(StandardCharsets.UTF_8)));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public Object deserializeObjectFromContentArea(TArea area, TRepo repo) {
        RepoPath objectTypeRepoPath = ((ReflectiveObjectMemoryRepoBase)repo).getObjectTypeRepoPath();
        Content objectTypeContent = area.getContent(objectTypeRepoPath);
        if (objectTypeContent == null) {
            return null;
        }
        String objectType = new String(objectTypeContent.asByteArray(), StandardCharsets.UTF_8);
        try {
            Class<?> objectClass = Class.forName(objectType);
            Object object = objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            RepoPath objectContentRepoPath = ((ReflectiveObjectMemoryRepoBase)repo).getObjectContentRepoPath();
            String fieldRootAbsolutePath = ((RepoPath)objectContentRepoPath.toAbsolutePath()).path;
            if (objectContentRepoPath != null) {
                for (AreaEntry entry : area) {
                    if (!((RepoPath)entry.path.toAbsolutePath()).path.startsWith(fieldRootAbsolutePath)) continue;
                    RepoPath fieldPath = entry.path;
                    String fieldName = ((RepoPath)fieldPath.toAbsolutePath()).path.substring(fieldRootAbsolutePath.length() + 1);
                    try {
                        Field field = objectClass.getField(fieldName);
                        String fieldValueString = new String(entry.content.asByteArray(), StandardCharsets.UTF_8);
                        if (NULL_VALUE.equals(fieldValueString)) {
                            fieldValueString = null;
                        }
                        field.set(object, fieldValueString);
                    }
                    catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
                }
            }
            return object;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public TCommit commitObject(Object object, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea area = this.createArea(areaFactory);
        this.serializeObjectToContentArea(object, area, contentFactory, repo);
        return this.commit(area, message, repo, byteArrayIndex, clock);
    }

    @Override
    public TCommit commitObject(Object object, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory, TCommit parentCommit) {
        TArea area = this.createArea(areaFactory);
        this.serializeObjectToContentArea(object, area, contentFactory, repo);
        return this.commit(area, message, repo, byteArrayIndex, clock, parentCommit);
    }

    @Override
    public TCommit commitObject(Object object, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory, TCommit firstParentCommit, List<TCommit> otherParentCommits) {
        TArea area = this.createArea(areaFactory);
        this.serializeObjectToContentArea(object, area, contentFactory, repo);
        return this.commit(area, message, repo, byteArrayIndex, clock, firstParentCommit, otherParentCommits);
    }

    @Override
    public TCommit commitObjectToBranch(Object object, String branchName, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea area = this.createArea(areaFactory);
        this.serializeObjectToContentArea(object, area, contentFactory, repo);
        return this.commitToBranch(area, branchName, message, repo, byteArrayIndex, clock);
    }

    @Override
    public Object checkoutObject(TCommit commit, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea area = this.checkout(commit, repo, areaFactory, contentFactory);
        return this.deserializeObjectFromContentArea(area, repo);
    }
}

