/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.Area;
import io.nanovc.AreaEntry;
import io.nanovc.AreaFactory;
import io.nanovc.Clock;
import io.nanovc.Commit;
import io.nanovc.Comparison;
import io.nanovc.ComparisonEngine;
import io.nanovc.ComparisonHandler;
import io.nanovc.Content;
import io.nanovc.ContentFactory;
import io.nanovc.Difference;
import io.nanovc.DifferenceEngine;
import io.nanovc.DifferenceHandler;
import io.nanovc.MergeEngine;
import io.nanovc.MergeHandler;
import io.nanovc.RepoEngineBase;
import io.nanovc.SearchParameters;
import io.nanovc.SearchQuery;
import io.nanovc.SearchQueryDefinition;
import io.nanovc.SearchResults;
import io.nanovc.Timestamp;
import io.nanovc.areas.ByteArrayArea;
import io.nanovc.areas.ByteArrayHashMapArea;
import io.nanovc.clocks.ClockWithVMNanos;
import io.nanovc.content.ByteArrayContent;
import io.nanovc.epochs.EpochWithVMNanos;
import io.nanovc.indexes.ByteArrayIndex;
import io.nanovc.indexes.HashWrapperByteArrayIndex;
import io.nanovc.memory.MemoryCommitBase;
import io.nanovc.memory.MemoryRepoAPI;
import io.nanovc.memory.MemoryRepoEngineAPI;
import io.nanovc.searches.commits.HashMapSearchParameters;
import io.nanovc.searches.commits.expressions.AllRepoCommitsExpression;
import io.nanovc.searches.commits.expressions.CommitsExpression;
import io.nanovc.searches.commits.expressions.Expression;
import io.nanovc.searches.commits.expressions.TipOfExpression;
import io.nanovc.timestamps.TimestampWithVMNanos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class MemoryRepoEngineBase<TContent extends Content, TArea extends Area<TContent>, TCommit extends MemoryCommitBase<TCommit>, TSearchQuery extends SearchQuery<TCommit>, TSearchResults extends SearchResults<TCommit, TSearchQuery>, TRepo extends MemoryRepoAPI<TContent, TArea, TCommit>>
extends RepoEngineBase<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo>
implements MemoryRepoEngineAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo> {
    @Override
    public TArea createArea(AreaFactory<TContent, TArea> areaSupplier) {
        return (TArea)areaSupplier.createArea();
    }

    @Override
    public TContent createContent(byte[] bytes, ContentFactory<TContent> contentFactory) {
        return (TContent)contentFactory.createContent(bytes);
    }

    @Override
    public ByteArrayArea createSnapshotArea() {
        return new ByteArrayHashMapArea();
    }

    @Override
    public TCommit commit(TArea contentAreaToCommit, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, byteArrayIndex, clock);
        repo.getDanglingCommits().add(commit);
        return commit;
    }

    @Override
    public TCommit commit(TArea contentAreaToCommit, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock, TCommit parentCommit) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, byteArrayIndex, clock);
        ((MemoryCommitBase)((Object)commit)).firstParent = parentCommit;
        LinkedHashSet danglingCommits = repo.getDanglingCommits();
        danglingCommits.add(commit);
        danglingCommits.remove(parentCommit);
        return commit;
    }

    @Override
    public TCommit commit(TArea contentAreaToCommit, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock, TCommit firstParentCommit, List<TCommit> otherParentCommits) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, byteArrayIndex, clock);
        ((MemoryCommitBase)((Object)commit)).firstParent = firstParentCommit;
        ((MemoryCommitBase)((Object)commit)).otherParents = otherParentCommits;
        LinkedHashSet danglingCommits = repo.getDanglingCommits();
        danglingCommits.add(commit);
        danglingCommits.remove(firstParentCommit);
        danglingCommits.removeAll(otherParentCommits);
        return commit;
    }

    @Override
    public TCommit commitToBranch(TArea contentAreaToCommit, String branchName, String message, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, byteArrayIndex, clock);
        MemoryCommitBase previousCommit = (MemoryCommitBase)((Object)repo.getBranchTips().get(branchName));
        if (previousCommit != null) {
            ((MemoryCommitBase)((Object)commit)).firstParent = previousCommit;
        }
        this.createBranchAtCommit(commit, branchName, repo);
        return commit;
    }

    @Override
    public void createBranchAtCommit(TCommit commit, String branchName, TRepo repo) {
        repo.getBranchTips().put(branchName, commit);
    }

    @Override
    public TCommit constructCommit(TArea contentAreaToCommit, String message, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock) {
        Timestamp timestamp = clock.now();
        MemoryCommitBase commit = this.createCommit();
        commit.timestamp = timestamp;
        commit.message = message;
        ByteArrayArea snapshotArea = this.createSnapshotArea();
        for (AreaEntry areaEntry : contentAreaToCommit) {
            byte[] bytes = areaEntry.content.asByteArray();
            byte[] indexedBytes = byteArrayIndex.addOrLookup(bytes);
            snapshotArea.putBytes(areaEntry.path, indexedBytes);
        }
        commit.snapshot = snapshotArea;
        return (TCommit)((Object)commit);
    }

    @Override
    public void checkoutIntoArea(TCommit commit, TRepo repo, TArea areaToUpdate, ContentFactory<TContent> contentFactory) {
        for (AreaEntry snapshotEntry : ((MemoryCommitBase)((Object)commit)).snapshot) {
            TContent destinationContent = this.createContent(((ByteArrayContent)snapshotEntry.content).getEfficientByteArray(), contentFactory);
            areaToUpdate.putContent(snapshotEntry.path, destinationContent);
        }
    }

    @Override
    public TArea checkout(TCommit commit, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea area = this.createArea(areaFactory);
        this.checkoutIntoArea(commit, repo, area, contentFactory);
        return area;
    }

    @Override
    public ByteArrayIndex createByteArrayIndex() {
        return new HashWrapperByteArrayIndex();
    }

    @Override
    public Clock<? extends Timestamp> createClock() {
        return new ClockWithVMNanos();
    }

    @Override
    public TCommit getLatestCommitForBranch(String branchName, TRepo repo) {
        return (TCommit)((Object)((MemoryCommitBase)((Object)repo.getBranchTips().get(branchName))));
    }

    @Override
    public Set<String> getBranchNames(TRepo repo) {
        return new HashSet<String>(repo.getBranchTips().keySet());
    }

    @Override
    public Set<String> getTagNames(TRepo repo) {
        return new HashSet<String>(repo.getTags().keySet());
    }

    @Override
    public void tagCommit(TRepo repo, TCommit commit, String tagName) {
        repo.getTags().put(tagName, commit);
    }

    @Override
    public TCommit getCommitForTag(TRepo repo, String tagName) {
        return (TCommit)((Object)((MemoryCommitBase)((Object)repo.getTags().get(tagName))));
    }

    @Override
    public void removeTag(TRepo repo, String tagName) {
        repo.getTags().remove(tagName);
    }

    @Override
    public void optimizeTimestamps(TRepo repo) {
        TimestampWithVMNanos timestampWithVMNanos;
        HashSet commits = new HashSet(repo.getDanglingCommits());
        IdentityHashMap identities = new IdentityHashMap();
        for (MemoryCommitBase commit : repo.getBranchTips().values()) {
            this.extractCommitsRecursively(commit, identities, commits);
        }
        EpochWithVMNanos bestEpochWithVMNanos = null;
        HashSet<MemoryCommitBase> commitsToProcess = new HashSet<MemoryCommitBase>();
        for (MemoryCommitBase commit : commits) {
            if (!(commit.timestamp instanceof TimestampWithVMNanos)) continue;
            timestampWithVMNanos = (TimestampWithVMNanos)commit.timestamp;
            commitsToProcess.add(commit);
            if (bestEpochWithVMNanos == null) {
                bestEpochWithVMNanos = timestampWithVMNanos.epoch;
                continue;
            }
            if (timestampWithVMNanos.epoch == bestEpochWithVMNanos || timestampWithVMNanos.epoch.getNanoTimeDurationLong() >= bestEpochWithVMNanos.getNanoTimeDurationLong()) continue;
            bestEpochWithVMNanos = timestampWithVMNanos.epoch;
        }
        for (MemoryCommitBase commit : commitsToProcess) {
            if (!(commit.timestamp instanceof TimestampWithVMNanos)) continue;
            timestampWithVMNanos = (TimestampWithVMNanos)commit.timestamp;
            if (timestampWithVMNanos.epoch == bestEpochWithVMNanos) continue;
            TimestampWithVMNanos rebasedTimestamp = new TimestampWithVMNanos(bestEpochWithVMNanos, timestampWithVMNanos.nanoTime);
            commit.timestamp = rebasedTimestamp;
        }
    }

    @Override
    public Difference computeDifferenceBetweenAreas(Area<? extends TContent> fromArea, Area<? extends TContent> toArea, DifferenceHandler<? extends DifferenceEngine> differenceHandler) {
        return differenceHandler.computeDifference(fromArea, toArea);
    }

    @Override
    public Difference computeDifferenceBetweenCommits(TCommit fromCommit, TCommit toCommit, DifferenceHandler<? extends DifferenceEngine> differenceHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea fromArea = this.checkout(fromCommit, repo, areaFactory, contentFactory);
        TArea toArea = this.checkout(toCommit, repo, areaFactory, contentFactory);
        return this.computeDifferenceBetweenAreas((Area<? extends TContent>)fromArea, (Area<? extends TContent>)toArea, differenceHandler);
    }

    @Override
    public Difference computeDifferenceBetweenBranches(String fromBranchName, String toBranchName, DifferenceHandler<? extends DifferenceEngine> differenceHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TCommit fromCommit = this.getLatestCommitForBranch(fromBranchName, repo);
        TCommit toCommit = this.getLatestCommitForBranch(toBranchName, repo);
        return this.computeDifferenceBetweenCommits(fromCommit, toCommit, differenceHandler, repo, areaFactory, contentFactory);
    }

    @Override
    public Comparison computeComparisonBetweenAreas(Area<? extends TContent> fromArea, Area<? extends TContent> toArea, ComparisonHandler<? extends ComparisonEngine> comparisonHandler) {
        return comparisonHandler.compare(fromArea, toArea);
    }

    @Override
    public Comparison computeComparisonBetweenCommits(TCommit fromCommit, TCommit toCommit, ComparisonHandler<? extends ComparisonEngine> comparisonHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea fromArea = this.checkout(fromCommit, repo, areaFactory, contentFactory);
        TArea toArea = this.checkout(toCommit, repo, areaFactory, contentFactory);
        return this.computeComparisonBetweenAreas((Area<? extends TContent>)fromArea, (Area<? extends TContent>)toArea, comparisonHandler);
    }

    @Override
    public Comparison computeComparisonBetweenBranches(String fromBranchName, String toBranchName, ComparisonHandler<? extends ComparisonEngine> comparisonHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TCommit fromCommit = this.getLatestCommitForBranch(fromBranchName, repo);
        TCommit toCommit = this.getLatestCommitForBranch(toBranchName, repo);
        return this.computeComparisonBetweenCommits(fromCommit, toCommit, comparisonHandler, repo, areaFactory, contentFactory);
    }

    @Override
    public TSearchQuery prepareSearchQuery(SearchQueryDefinition searchQueryDefinition) {
        SearchQuery searchQuery = this.createSearchQuery(searchQueryDefinition);
        return (TSearchQuery)searchQuery;
    }

    @Override
    public TSearchResults searchWithQuery(TSearchQuery searchQuery, SearchParameters overrideParameters, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        SearchResults searchResults = this.createSearchResults((SearchQuery)searchQuery);
        SearchParameters parameters = searchQuery.getDefinition().getParameters();
        if (overrideParameters != null) {
            HashMapSearchParameters updatedSearchParameters = new HashMapSearchParameters();
            updatedSearchParameters.putAll((Map)parameters);
            updatedSearchParameters.putAll((Map)overrideParameters);
            parameters = updatedSearchParameters;
        }
        List commitsToAddTo = searchResults.getCommits();
        Expression singleCommitExpression = searchQuery.getDefinition().getSingleCommitExpression();
        if (singleCommitExpression != null) {
            this.walkSingleCommitSearchExpression((Expression<Commit>)singleCommitExpression, parameters, repo, commitsToAddTo);
        } else {
            Expression listOfCommitsExpression = searchQuery.getDefinition().getListOfCommitsExpression();
            this.walkListOfCommitsSearchExpression((Expression<List<Commit>>)listOfCommitsExpression, parameters, repo, commitsToAddTo);
        }
        return (TSearchResults)searchResults;
    }

    public void walkListOfCommitsSearchExpression(Expression<List<Commit>> expression, SearchParameters parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        switch (expression.getClass().getSimpleName()) {
            case "AllRepoCommitsExpression": {
                this.walkAllRepoCommitsExpression((AllRepoCommitsExpression)expression, parameters, repo, commitsToAddTo);
            }
        }
    }

    public void walkSingleCommitSearchExpression(Expression<Commit> expression, SearchParameters parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        switch (expression.getClass().getSimpleName()) {
            case "TipOfExpression": {
                this.walkTipOfExpression((TipOfExpression)expression, parameters, repo, commitsToAddTo);
            }
        }
    }

    public void walkTipOfExpression(TipOfExpression expression, SearchParameters parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        CommitsExpression operand = expression.getOperand();
        this.walkListOfCommitsSearchExpression((Expression<List<Commit>>)operand, parameters, repo, commitsToAddTo);
        MemoryCommitBase lastCommit = (MemoryCommitBase)((Object)commitsToAddTo.get(commitsToAddTo.size() - 1));
        commitsToAddTo.clear();
        commitsToAddTo.add((TCommit)((Object)lastCommit));
    }

    public void walkAllRepoCommitsExpression(AllRepoCommitsExpression expression, SearchParameters parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        TreeSet<MemoryCommitBase> commitSet = new TreeSet<MemoryCommitBase>(Comparator.comparing(tCommit -> tCommit.timestamp.getInstant()));
        IdentityHashMap identities = new IdentityHashMap();
        LinkedHashSet initialCommitSet = new LinkedHashSet();
        initialCommitSet.addAll(repo.getBranchTips().values());
        initialCommitSet.addAll(repo.getTags().values());
        initialCommitSet.addAll(repo.getDanglingCommits());
        for (MemoryCommitBase tipCommit : initialCommitSet) {
            this.extractCommitsRecursively(tipCommit, identities, commitSet);
        }
        commitsToAddTo.addAll(commitSet);
    }

    public void extractCommitsRecursively(TCommit currentCommit, IdentityHashMap<TCommit, TCommit> previouslySeenIdentities, Set<TCommit> commitSetToAddTo) {
        if (previouslySeenIdentities.containsKey(currentCommit)) {
            return;
        }
        previouslySeenIdentities.put(currentCommit, currentCommit);
        commitSetToAddTo.add(currentCommit);
        if (((MemoryCommitBase)((Object)currentCommit)).firstParent != null) {
            this.extractCommitsRecursively(((MemoryCommitBase)((Object)currentCommit)).firstParent, previouslySeenIdentities, commitSetToAddTo);
        }
        if (((MemoryCommitBase)((Object)currentCommit)).otherParents != null && ((MemoryCommitBase)((Object)currentCommit)).otherParents.size() > 0) {
            for (MemoryCommitBase otherParent : ((MemoryCommitBase)((Object)currentCommit)).otherParents) {
                this.extractCommitsRecursively(otherParent, previouslySeenIdentities, commitSetToAddTo);
            }
        }
    }

    @Override
    public TCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message, MergeHandler<? extends MergeEngine> mergeHandler, ComparisonHandler<? extends ComparisonEngine> comparisonHandler, DifferenceHandler<? extends DifferenceEngine> differenceHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock) {
        Object mergedArea;
        TCommit sourceCommit = this.getLatestCommitForBranch(sourceBranchName, repo);
        TCommit destinationCommit = this.getLatestCommitForBranch(destinationBranchName, repo);
        Difference differenceBetweenCommits = this.computeDifferenceBetweenCommits(destinationCommit, sourceCommit, differenceHandler, repo, areaFactory, contentFactory);
        if (differenceBetweenCommits.hasDifferences()) {
            mergedArea = areaFactory.createArea();
            TArea sourceArea = this.checkout(sourceCommit, repo, areaFactory, contentFactory);
            TArea destinationArea = this.checkout(destinationCommit, repo, areaFactory, contentFactory);
            Comparison comparisonBetweenSourceAndDestination = this.computeComparisonBetweenAreas((Area<? extends TContent>)destinationArea, (Area<? extends TContent>)sourceArea, comparisonHandler);
            TCommit commonAncestorCommit = this.findCommonAncestorOfCommits(sourceCommit, destinationCommit);
            if (commonAncestorCommit == null) {
                mergeHandler.mergeIntoAreaWithTwoWayDiff(mergedArea, sourceCommit, destinationCommit, sourceArea, destinationArea, comparisonBetweenSourceAndDestination, contentFactory, byteArrayIndex);
            } else {
                TArea commonAncestorArea = this.checkout(commonAncestorCommit, repo, areaFactory, contentFactory);
                Difference differenceBetweenAncestorAndSource = this.computeDifferenceBetweenAreas((Area<? extends TContent>)commonAncestorArea, (Area<? extends TContent>)sourceArea, differenceHandler);
                Difference differenceBetweenAncestorAndDestination = this.computeDifferenceBetweenAreas((Area<? extends TContent>)commonAncestorArea, (Area<? extends TContent>)destinationArea, differenceHandler);
                mergeHandler.mergeIntoAreaWithThreeWayDiff(mergedArea, commonAncestorCommit, sourceCommit, destinationCommit, commonAncestorArea, sourceArea, destinationArea, comparisonBetweenSourceAndDestination, differenceBetweenAncestorAndSource, differenceBetweenAncestorAndDestination, contentFactory, byteArrayIndex);
            }
        } else {
            mergedArea = this.checkout(destinationCommit, repo, areaFactory, contentFactory);
        }
        TCommit mergeCommit = this.commitToBranch(mergedArea, destinationBranchName, message, repo, byteArrayIndex, clock);
        ((MemoryCommitBase)((Object)mergeCommit)).otherParents = new ArrayList();
        ((MemoryCommitBase)((Object)mergeCommit)).otherParents.add(sourceCommit);
        return mergeCommit;
    }

    public TCommit findCommonAncestorOfCommits(TCommit commit1, TCommit commit2) {
        IdentityHashMap identities1 = new IdentityHashMap();
        HashSet parentCommits1 = new HashSet();
        this.extractCommitsRecursively(commit1, identities1, parentCommits1);
        IdentityHashMap identities2 = new IdentityHashMap();
        return this.findCommonAncestorOfCommitsRecursive(commit2, identities2, identities1);
    }

    private TCommit findCommonAncestorOfCommitsRecursive(TCommit currentCommit, IdentityHashMap<TCommit, TCommit> previouslySeenIdentities, IdentityHashMap<TCommit, TCommit> otherCommitsToSearchAgainst) {
        Object commonAncestor;
        if (previouslySeenIdentities.containsKey(currentCommit)) {
            return null;
        }
        previouslySeenIdentities.put(currentCommit, currentCommit);
        if (otherCommitsToSearchAgainst.containsKey(currentCommit)) {
            return currentCommit;
        }
        if (((MemoryCommitBase)((Object)currentCommit)).firstParent != null && (commonAncestor = this.findCommonAncestorOfCommitsRecursive(((MemoryCommitBase)((Object)currentCommit)).firstParent, previouslySeenIdentities, otherCommitsToSearchAgainst)) != null) {
            return (TCommit)commonAncestor;
        }
        if (((MemoryCommitBase)((Object)currentCommit)).otherParents != null && ((MemoryCommitBase)((Object)currentCommit)).otherParents.size() > 0) {
            for (MemoryCommitBase otherParent : ((MemoryCommitBase)((Object)currentCommit)).otherParents) {
                MemoryCommitBase commonAncestor2 = this.findCommonAncestorOfCommitsRecursive(otherParent, previouslySeenIdentities, otherCommitsToSearchAgainst);
                if (commonAncestor2 == null) continue;
                return (TCommit)((Object)commonAncestor2);
            }
        }
        return null;
    }

    @Override
    public TArea castOrCloneArea(Area<? extends Content> areaToCastOrClone, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex) {
        Area clonedArea = areaFactory.createArea();
        for (AreaEntry areaEntry : areaToCastOrClone) {
            byte[] bytes = byteArrayIndex.addOrLookup(areaEntry.content.asByteArray());
            Content clonedContent = contentFactory.createContent(bytes);
            clonedArea.putContent(areaEntry.path, clonedContent);
        }
        return (TArea)clonedArea;
    }
}

