/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.Area;
import io.nanovc.AreaFactory;
import io.nanovc.Clock;
import io.nanovc.Comparison;
import io.nanovc.ComparisonEngine;
import io.nanovc.ComparisonHandler;
import io.nanovc.Content;
import io.nanovc.ContentFactory;
import io.nanovc.Difference;
import io.nanovc.DifferenceEngine;
import io.nanovc.DifferenceHandler;
import io.nanovc.MergeEngine;
import io.nanovc.MergeHandler;
import io.nanovc.RepoEngine;
import io.nanovc.SearchParameters;
import io.nanovc.SearchQuery;
import io.nanovc.SearchQueryDefinition;
import io.nanovc.SearchResults;
import io.nanovc.Timestamp;
import io.nanovc.areas.ByteArrayArea;
import io.nanovc.indexes.ByteArrayIndex;
import io.nanovc.memory.MemoryCommitBase;
import io.nanovc.memory.MemoryRepoAPI;
import java.util.List;
import java.util.Set;

public interface MemoryRepoEngineAPI<TContent extends Content, TArea extends Area<TContent>, TCommit extends MemoryCommitBase<TCommit>, TSearchQuery extends SearchQuery<TCommit>, TSearchResults extends SearchResults<TCommit, TSearchQuery>, TRepo extends MemoryRepoAPI<TContent, TArea, TCommit>>
extends RepoEngine<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo> {
    public TRepo createRepo();

    public TCommit createCommit();

    default public TArea createArea(AreaFactory<TContent, TArea> areaSupplier) {
        return (TArea)areaSupplier.createArea();
    }

    public ByteArrayArea createSnapshotArea();

    public TContent createContent(byte[] var1, ContentFactory<TContent> var2);

    public TCommit commit(TArea var1, String var2, TRepo var3, ByteArrayIndex var4, Clock<? extends Timestamp> var5);

    public TCommit commit(TArea var1, String var2, TRepo var3, ByteArrayIndex var4, Clock<? extends Timestamp> var5, TCommit var6);

    public TCommit commit(TArea var1, String var2, TRepo var3, ByteArrayIndex var4, Clock<? extends Timestamp> var5, TCommit var6, List<TCommit> var7);

    public TCommit commitToBranch(TArea var1, String var2, String var3, TRepo var4, ByteArrayIndex var5, Clock<? extends Timestamp> var6);

    public TCommit constructCommit(TArea var1, String var2, ByteArrayIndex var3, Clock<? extends Timestamp> var4);

    public void checkoutIntoArea(TCommit var1, TRepo var2, TArea var3, ContentFactory<TContent> var4);

    public TArea checkout(TCommit var1, TRepo var2, AreaFactory<TContent, TArea> var3, ContentFactory<TContent> var4);

    public ByteArrayIndex createByteArrayIndex();

    public Clock<? extends Timestamp> createClock();

    public TCommit getLatestCommitForBranch(String var1, TRepo var2);

    public Set<String> getBranchNames(TRepo var1);

    public Set<String> getTagNames(TRepo var1);

    public void tagCommit(TRepo var1, TCommit var2, String var3);

    public TCommit getCommitForTag(TRepo var1, String var2);

    public void removeTag(TRepo var1, String var2);

    public void optimizeTimestamps(TRepo var1);

    public Difference computeDifferenceBetweenAreas(Area<? extends TContent> var1, Area<? extends TContent> var2, DifferenceHandler<? extends DifferenceEngine> var3);

    public Difference computeDifferenceBetweenCommits(TCommit var1, TCommit var2, DifferenceHandler<? extends DifferenceEngine> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public Difference computeDifferenceBetweenBranches(String var1, String var2, DifferenceHandler<? extends DifferenceEngine> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public Comparison computeComparisonBetweenAreas(Area<? extends TContent> var1, Area<? extends TContent> var2, ComparisonHandler<? extends ComparisonEngine> var3);

    public Comparison computeComparisonBetweenCommits(TCommit var1, TCommit var2, ComparisonHandler<? extends ComparisonEngine> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public Comparison computeComparisonBetweenBranches(String var1, String var2, ComparisonHandler<? extends ComparisonEngine> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public TSearchQuery createSearchQuery(SearchQueryDefinition var1);

    public TSearchQuery prepareSearchQuery(SearchQueryDefinition var1);

    public TSearchResults createSearchResults(TSearchQuery var1);

    public TSearchResults searchWithQuery(TSearchQuery var1, SearchParameters var2, TRepo var3, AreaFactory<TContent, TArea> var4, ContentFactory<TContent> var5);

    public TCommit mergeIntoBranchFromAnotherBranch(String var1, String var2, String var3, MergeHandler<? extends MergeEngine> var4, ComparisonHandler<? extends ComparisonEngine> var5, DifferenceHandler<? extends DifferenceEngine> var6, TRepo var7, AreaFactory<TContent, TArea> var8, ContentFactory<TContent> var9, ByteArrayIndex var10, Clock<? extends Timestamp> var11);

    public void createBranchAtCommit(TCommit var1, String var2, TRepo var3);

    public TArea castOrCloneArea(Area<? extends Content> var1, AreaFactory<TContent, TArea> var2, ContentFactory<TContent> var3, ByteArrayIndex var4);
}

