/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.Area;
import io.nanovc.Clock;
import io.nanovc.Comparison;
import io.nanovc.ComparisonEngine;
import io.nanovc.ComparisonHandler;
import io.nanovc.Content;
import io.nanovc.Difference;
import io.nanovc.DifferenceEngine;
import io.nanovc.DifferenceHandler;
import io.nanovc.MergeEngine;
import io.nanovc.MergeHandler;
import io.nanovc.SearchParameters;
import io.nanovc.SearchQueryDefinition;
import io.nanovc.Timestamp;
import io.nanovc.areas.ByteArrayHashMapArea;
import io.nanovc.clocks.ClockWithVMNanos;
import io.nanovc.comparisons.HashMapComparisonHandler;
import io.nanovc.content.ByteArrayContent;
import io.nanovc.differences.HashMapDifferenceHandler;
import io.nanovc.indexes.ByteArrayIndex;
import io.nanovc.memory.MemoryCommit;
import io.nanovc.memory.MemoryRepo;
import io.nanovc.memory.MemoryRepoEngine;
import io.nanovc.memory.MemoryRepoHandlerAPI;
import io.nanovc.memory.MemorySearchQuery;
import io.nanovc.memory.MemorySearchResults;
import io.nanovc.merges.LastWinsMergeHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class MemoryNanoRepo
extends MemoryRepo<ByteArrayContent, ByteArrayHashMapArea>
implements MemoryRepoHandlerAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, MemoryRepo<ByteArrayContent, ByteArrayHashMapArea>, MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea>> {
    public static final MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> COMMON_ENGINE = new MemoryRepoEngine();
    protected MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> engine = COMMON_ENGINE;
    public static final HashMapDifferenceHandler COMMON_DIFFERENCE_HANDLER = new HashMapDifferenceHandler();
    protected DifferenceHandler<? extends DifferenceEngine> differenceHandler = COMMON_DIFFERENCE_HANDLER;
    public static final HashMapComparisonHandler COMMON_COMPARISON_HANDLER = new HashMapComparisonHandler();
    protected ComparisonHandler<? extends ComparisonEngine> comparisonHandler = COMMON_COMPARISON_HANDLER;
    public static final LastWinsMergeHandler COMMON_MERGE_HANDLER = new LastWinsMergeHandler();
    protected MergeHandler<? extends MergeEngine> mergeHandler = COMMON_MERGE_HANDLER;
    protected ByteArrayIndex byteArrayIndex;
    public static final Clock<? extends Timestamp> COMMON_CLOCK = new ClockWithVMNanos();
    protected Clock<? extends Timestamp> clock = COMMON_CLOCK;

    public MemoryNanoRepo() {
        this.ensureDependenciesExist();
    }

    public MemoryNanoRepo(ByteArrayIndex byteArrayIndex) {
        this.byteArrayIndex = byteArrayIndex;
        this.ensureDependenciesExist();
    }

    public MemoryNanoRepo(ByteArrayIndex byteArrayIndex, MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> engine, Clock<? extends Timestamp> clock, DifferenceHandler<? extends DifferenceEngine> differenceHandler, ComparisonHandler<? extends ComparisonEngine> comparisonHandler, MergeHandler<? extends MergeEngine> mergeHandler) {
        this.byteArrayIndex = byteArrayIndex;
        this.engine = engine;
        this.clock = clock;
        this.differenceHandler = differenceHandler;
        this.comparisonHandler = comparisonHandler;
        this.mergeHandler = mergeHandler;
        this.ensureDependenciesExist();
    }

    private void ensureDependenciesExist() {
        if (this.engine == null) {
            this.engine = COMMON_ENGINE;
        }
        if (this.byteArrayIndex == null) {
            this.byteArrayIndex = this.engine.createByteArrayIndex();
        }
        if (this.clock == null) {
            this.clock = this.engine.createClock();
        }
        if (this.differenceHandler == null) {
            this.differenceHandler = new HashMapDifferenceHandler();
        }
        if (this.comparisonHandler == null) {
            this.comparisonHandler = new HashMapComparisonHandler();
        }
        if (this.mergeHandler == null) {
            this.mergeHandler = new LastWinsMergeHandler();
        }
    }

    public ByteArrayHashMapArea createArea() {
        return (ByteArrayHashMapArea)this.engine.createArea(ByteArrayHashMapArea::new);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message) {
        return (MemoryCommit)((Object)this.engine.commit(contentAreaToCommit, message, this, this.byteArrayIndex, this.clock));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, MemoryCommit parentCommit) {
        return this.engine.commit(contentAreaToCommit, message, this, this.byteArrayIndex, this.clock, parentCommit);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, MemoryCommit firstParentCommit, MemoryCommit ... otherParentCommits) {
        return this.engine.commit(contentAreaToCommit, message, this, this.byteArrayIndex, this.clock, firstParentCommit, Arrays.asList(otherParentCommits));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, MemoryCommit firstParentCommit, List<MemoryCommit> otherParentCommits) {
        return this.engine.commit(contentAreaToCommit, message, this, this.byteArrayIndex, this.clock, firstParentCommit, otherParentCommits);
    }

    public MemoryCommit commitToBranch(ByteArrayHashMapArea contentAreaToCommit, String branch, String message) {
        return (MemoryCommit)((Object)this.engine.commitToBranch(contentAreaToCommit, branch, message, this, this.byteArrayIndex, this.clock));
    }

    public void createBranchAtCommit(MemoryCommit commit, String branchName) {
        this.engine.createBranchAtCommit(commit, branchName, this);
    }

    public MemoryCommit getLatestCommitForBranch(String branchName) {
        return (MemoryCommit)((Object)this.engine.getLatestCommitForBranch(branchName, this));
    }

    public void checkoutIntoArea(MemoryCommit commit, ByteArrayHashMapArea areaToUpdate) {
        this.engine.checkoutIntoArea(commit, this, areaToUpdate, ByteArrayContent::new);
    }

    public ByteArrayHashMapArea checkout(MemoryCommit commit) {
        return (ByteArrayHashMapArea)this.engine.checkout(commit, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public void tagCommit(MemoryCommit commit, String tagName) {
        this.engine.tagCommit(this, commit, tagName);
    }

    public MemoryCommit getCommitForTag(String tagName) {
        return (MemoryCommit)((Object)this.engine.getCommitForTag(this, tagName));
    }

    public void removeTag(String tagName) {
        this.engine.removeTag(this, tagName);
    }

    public Difference computeDifferenceBetweenAreas(Area<? extends ByteArrayContent> fromArea, Area<? extends ByteArrayContent> toArea) {
        return this.engine.computeDifferenceBetweenAreas(fromArea, toArea, this.differenceHandler);
    }

    public Difference computeDifferenceBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.engine.computeDifferenceBetweenCommits(fromCommit, toCommit, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public Difference computeDifferenceBetweenBranches(String fromBranchName, String toBranchName) {
        return this.engine.computeDifferenceBetweenBranches(fromBranchName, toBranchName, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public Comparison computeComparisonBetweenAreas(Area<? extends ByteArrayContent> fromArea, Area<? extends ByteArrayContent> toArea) {
        return this.engine.computeComparisonBetweenAreas(fromArea, toArea, this.comparisonHandler);
    }

    public Comparison computeComparisonBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.engine.computeComparisonBetweenCommits(fromCommit, toCommit, this.comparisonHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public Comparison computeComparisonBetweenBranches(String fromBranchName, String toBranchName) {
        return this.engine.computeComparisonBetweenBranches(fromBranchName, toBranchName, this.comparisonHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public Set<String> getBranchNames() {
        return this.engine.getBranchNames(this);
    }

    public Set<String> getTagNames() {
        return this.engine.getTagNames(this);
    }

    public MemoryRepo<ByteArrayContent, ByteArrayHashMapArea> getRepo() {
        return this;
    }

    public void setRepo(MemoryRepo<ByteArrayContent, ByteArrayHashMapArea> repo) {
        throw new IllegalArgumentException("Cannot set a memory nano repo to another memory nano repo. That doesn't make sense for Object Oriented nano repos.");
    }

    public MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> getEngine() {
        return this.engine;
    }

    public void setEngine(MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> engine) {
        this.engine = engine;
    }

    public DifferenceHandler<? extends DifferenceEngine> getDifferenceHandler() {
        return this.differenceHandler;
    }

    public void setDifferenceHandler(DifferenceHandler<? extends DifferenceEngine> differenceHandler) {
        this.differenceHandler = differenceHandler;
    }

    public ComparisonHandler<? extends ComparisonEngine> getComparisonHandler() {
        return this.comparisonHandler;
    }

    public void setComparisonHandler(ComparisonHandler<? extends ComparisonEngine> comparisonHandler) {
        this.comparisonHandler = comparisonHandler;
    }

    public MergeHandler<? extends MergeEngine> getMergeHandler() {
        return this.mergeHandler;
    }

    public void setMergeHandler(MergeHandler<? extends MergeEngine> mergeHandler) {
        this.mergeHandler = mergeHandler;
    }

    public MemorySearchQuery prepareSearchQuery(SearchQueryDefinition searchQueryDefinition) {
        return (MemorySearchQuery)((Object)this.engine.prepareSearchQuery(searchQueryDefinition));
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery) {
        return (MemorySearchResults)((Object)this.engine.searchWithQuery(searchQuery, null, this, ByteArrayHashMapArea::new, ByteArrayContent::new));
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery, SearchParameters overrideParameters) {
        return (MemorySearchResults)((Object)this.engine.searchWithQuery(searchQuery, overrideParameters, this, ByteArrayHashMapArea::new, ByteArrayContent::new));
    }

    public MemorySearchResults search(SearchQueryDefinition searchQueryDefinition) {
        MemorySearchQuery searchQuery = this.prepareSearchQuery(searchQueryDefinition);
        return this.searchWithQuery(searchQuery);
    }

    public MemorySearchResults search(SearchQueryDefinition searchQueryDefinition, SearchParameters overrideParameters) {
        MemorySearchQuery searchQuery = this.prepareSearchQuery(searchQueryDefinition);
        return this.searchWithQuery(searchQuery, overrideParameters);
    }

    public MemoryCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message) {
        return (MemoryCommit)((Object)this.engine.mergeIntoBranchFromAnotherBranch(destinationBranchName, sourceBranchName, message, this.mergeHandler, this.comparisonHandler, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new, this.byteArrayIndex, this.clock));
    }

    public ByteArrayHashMapArea castOrCloneArea(Area<? extends Content> areaToCastOrClone) {
        return (ByteArrayHashMapArea)this.engine.castOrCloneArea(areaToCastOrClone, this::createArea, ByteArrayContent::new, this.byteArrayIndex);
    }
}

