/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.Area;
import io.nanovc.AreaFactory;
import io.nanovc.Clock;
import io.nanovc.Comparison;
import io.nanovc.ComparisonEngine;
import io.nanovc.ComparisonHandler;
import io.nanovc.Content;
import io.nanovc.ContentFactory;
import io.nanovc.Difference;
import io.nanovc.DifferenceEngine;
import io.nanovc.DifferenceHandler;
import io.nanovc.MergeEngine;
import io.nanovc.MergeHandler;
import io.nanovc.RepoHandlerBase;
import io.nanovc.SearchParameters;
import io.nanovc.SearchQuery;
import io.nanovc.SearchQueryDefinition;
import io.nanovc.SearchResults;
import io.nanovc.Timestamp;
import io.nanovc.comparisons.HashMapComparisonHandler;
import io.nanovc.differences.HashMapDifferenceHandler;
import io.nanovc.indexes.ByteArrayIndex;
import io.nanovc.memory.MemoryCommitBase;
import io.nanovc.memory.MemoryRepoAPI;
import io.nanovc.memory.MemoryRepoEngineAPI;
import io.nanovc.memory.MemoryRepoHandlerAPI;
import io.nanovc.merges.LastWinsMergeHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class MemoryRepoHandlerBase<TContent extends Content, TArea extends Area<TContent>, TCommit extends MemoryCommitBase<TCommit>, TSearchQuery extends SearchQuery<TCommit>, TSearchResults extends SearchResults<TCommit, TSearchQuery>, TRepo extends MemoryRepoAPI<TContent, TArea, TCommit>, TEngine extends MemoryRepoEngineAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo>>
extends RepoHandlerBase<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo, TEngine>
implements MemoryRepoHandlerAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo, TEngine> {
    public ContentFactory<TContent> contentFactory;
    public AreaFactory<TContent, TArea> areaFactory;
    public ByteArrayIndex byteArrayIndex;
    public Clock<? extends Timestamp> clock;

    public MemoryRepoHandlerBase(ContentFactory<TContent> contentFactory, AreaFactory<TContent, TArea> areaFactory, TRepo repo, ByteArrayIndex byteArrayIndex, Clock<? extends Timestamp> clock, TEngine repoEngine, DifferenceHandler<? extends DifferenceEngine> differenceHandler, ComparisonHandler<? extends ComparisonEngine> comparisonHandler, MergeHandler<? extends MergeEngine> mergeHandler) {
        super(repo, repoEngine, differenceHandler, comparisonHandler, mergeHandler);
        this.contentFactory = contentFactory;
        this.areaFactory = areaFactory;
        this.byteArrayIndex = byteArrayIndex;
        this.clock = clock;
        this.ensureDependenciesExist();
    }

    private void ensureDependenciesExist() {
        if (this.engine == null) {
            this.engine = this.createDefaultEngine();
        }
        if (this.repo == null) {
            this.repo = ((MemoryRepoEngineAPI)this.engine).createRepo();
        }
        if (this.byteArrayIndex == null) {
            this.byteArrayIndex = ((MemoryRepoEngineAPI)this.engine).createByteArrayIndex();
        }
        if (this.clock == null) {
            this.clock = ((MemoryRepoEngineAPI)this.engine).createClock();
        }
        if (this.differenceHandler == null) {
            this.differenceHandler = new HashMapDifferenceHandler();
        }
        if (this.comparisonHandler == null) {
            this.comparisonHandler = new HashMapComparisonHandler();
        }
        if (this.mergeHandler == null) {
            this.mergeHandler = new LastWinsMergeHandler();
        }
        this.initRepo((MemoryRepoAPI)this.repo);
    }

    public TCommit getCommitForTag(String tagName) {
        return ((MemoryRepoEngineAPI)this.engine).getCommitForTag((MemoryRepoAPI)this.repo, tagName);
    }

    public void removeTag(String tagName) {
        ((MemoryRepoEngineAPI)this.engine).removeTag((MemoryRepoAPI)this.repo, tagName);
    }

    public void tagCommit(TCommit commit, String tagName) {
        ((MemoryRepoEngineAPI)this.engine).tagCommit((MemoryRepoAPI)this.repo, commit, tagName);
    }

    protected void initRepo(TRepo repo) {
    }

    protected abstract TEngine createDefaultEngine();

    public TArea createArea() {
        return ((MemoryRepoEngineAPI)this.engine).createArea(this.areaFactory);
    }

    public TCommit commit(TArea contentAreaToCommit, String message) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock);
    }

    public TCommit commit(TArea contentAreaToCommit, String message, TCommit parentCommit) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, parentCommit);
    }

    public TCommit commit(TArea contentAreaToCommit, String message, TCommit firstParentCommit, TCommit ... otherParentCommits) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, firstParentCommit, Arrays.asList(otherParentCommits));
    }

    public TCommit commit(TArea contentAreaToCommit, String message, TCommit firstParentCommit, List<TCommit> otherParentCommits) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, firstParentCommit, otherParentCommits);
    }

    public TCommit commitToBranch(TArea contentAreaToCommit, String branch, String message) {
        return ((MemoryRepoEngineAPI)this.engine).commitToBranch(contentAreaToCommit, branch, message, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock);
    }

    public void checkoutIntoArea(TCommit commit, TArea areaToUpdate) {
        ((MemoryRepoEngineAPI)this.engine).checkoutIntoArea(commit, (MemoryRepoAPI)this.repo, areaToUpdate, this.contentFactory);
    }

    public TArea checkout(TCommit commit) {
        return ((MemoryRepoEngineAPI)this.engine).checkout(commit, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TCommit getLatestCommitForBranch(String branchName) {
        return ((MemoryRepoEngineAPI)this.engine).getLatestCommitForBranch(branchName, (MemoryRepoAPI)this.repo);
    }

    public Difference computeDifferenceBetweenAreas(Area<? extends TContent> fromArea, Area<? extends TContent> toArea) {
        return ((MemoryRepoEngineAPI)this.engine).computeDifferenceBetweenAreas(fromArea, toArea, (DifferenceHandler<DifferenceEngine>)this.differenceHandler);
    }

    public Difference computeDifferenceBetweenCommits(TCommit fromCommit, TCommit toCommit) {
        return ((MemoryRepoEngineAPI)this.engine).computeDifferenceBetweenCommits(fromCommit, toCommit, (DifferenceHandler<DifferenceEngine>)this.differenceHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public Difference computeDifferenceBetweenBranches(String fromBranchName, String toBranchName) {
        return ((MemoryRepoEngineAPI)this.engine).computeDifferenceBetweenBranches(fromBranchName, toBranchName, (DifferenceHandler<DifferenceEngine>)this.differenceHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public Comparison computeComparisonBetweenAreas(Area<? extends TContent> fromArea, Area<? extends TContent> toArea) {
        return ((MemoryRepoEngineAPI)this.engine).computeComparisonBetweenAreas(fromArea, toArea, (ComparisonHandler<ComparisonEngine>)this.comparisonHandler);
    }

    public Comparison computeComparisonBetweenCommits(TCommit fromCommit, TCommit toCommit) {
        return ((MemoryRepoEngineAPI)this.engine).computeComparisonBetweenCommits(fromCommit, toCommit, (ComparisonHandler<ComparisonEngine>)this.comparisonHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public Comparison computeComparisonBetweenBranches(String fromBranchName, String toBranchName) {
        return ((MemoryRepoEngineAPI)this.engine).computeComparisonBetweenBranches(fromBranchName, toBranchName, (ComparisonHandler<ComparisonEngine>)this.comparisonHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public Set<String> getBranchNames() {
        return ((MemoryRepoEngineAPI)this.engine).getBranchNames((MemoryRepoAPI)this.repo);
    }

    public Set<String> getTagNames() {
        return ((MemoryRepoEngineAPI)this.engine).getTagNames((MemoryRepoAPI)this.repo);
    }

    public TSearchQuery prepareSearchQuery(SearchQueryDefinition searchQueryDefinition) {
        return ((MemoryRepoEngineAPI)this.engine).prepareSearchQuery(searchQueryDefinition);
    }

    public TSearchResults searchWithQuery(TSearchQuery searchQuery) {
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, null, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TSearchResults searchWithQuery(TSearchQuery searchQuery, SearchParameters overrideParameters) {
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, overrideParameters, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TSearchResults search(SearchQueryDefinition searchQueryDefinition) {
        Object searchQuery = ((MemoryRepoEngineAPI)this.engine).prepareSearchQuery(searchQueryDefinition);
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, null, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TSearchResults search(SearchQueryDefinition searchQueryDefinition, SearchParameters overrideParameters) {
        Object searchQuery = ((MemoryRepoEngineAPI)this.engine).prepareSearchQuery(searchQueryDefinition);
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, overrideParameters, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message) {
        return ((MemoryRepoEngineAPI)this.engine).mergeIntoBranchFromAnotherBranch(destinationBranchName, sourceBranchName, message, (MergeHandler<MergeEngine>)this.mergeHandler, (ComparisonHandler<ComparisonEngine>)this.comparisonHandler, (DifferenceHandler<DifferenceEngine>)this.differenceHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory, this.byteArrayIndex, this.clock);
    }

    public void createBranchAtCommit(TCommit commit, String branchName) {
        ((MemoryRepoEngineAPI)this.engine).createBranchAtCommit(commit, branchName, (MemoryRepoAPI)this.repo);
    }

    public TArea castOrCloneArea(Area<? extends Content> areaToCastOrClone) {
        return ((MemoryRepoEngineAPI)this.engine).castOrCloneArea(areaToCastOrClone, this.areaFactory, this.contentFactory, this.byteArrayIndex);
    }
}

