/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework.revision;

import java.io.File;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class FileEntriesEnumeration
implements Enumeration {
    private final File m_dir;
    private final File[] m_children;
    private int m_counter = 0;

    public FileEntriesEnumeration(File dir) {
        this.m_dir = dir;
        this.m_children = this.listFilesRecursive(this.m_dir);
    }

    @Override
    public synchronized boolean hasMoreElements() {
        return this.m_children != null && this.m_counter < this.m_children.length;
    }

    public synchronized Object nextElement() {
        if (this.m_children == null || this.m_counter >= this.m_children.length) {
            throw new NoSuchElementException("No more entry paths.");
        }
        String abs = this.m_children[this.m_counter].getAbsolutePath().replace(File.separatorChar, '/');
        StringBuffer sb = new StringBuffer(abs);
        sb.delete(0, this.m_dir.getAbsolutePath().length() + 1);
        if (this.m_children[this.m_counter].isDirectory()) {
            sb.append('/');
        }
        ++this.m_counter;
        return sb.toString();
    }

    private File[] listFilesRecursive(File dir) {
        File[] children;
        File[] combined = children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File[] grandchildren;
            if (!children[i].isDirectory() || (grandchildren = this.listFilesRecursive(children[i])).length <= 0) continue;
            File[] tmp = new File[combined.length + grandchildren.length];
            System.arraycopy(combined, 0, tmp, 0, combined.length);
            System.arraycopy(grandchildren, 0, tmp, combined.length, grandchildren.length);
            combined = tmp;
        }
        return combined;
    }
}

