/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework;

import io.mypojo.felix.framework.ServiceRegistry;
import io.mypojo.felix.framework.capabilityset.SimpleFilter;
import io.mypojo.felix.framework.util.EventDispatcher;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PojoSRBundleContext
implements BundleContext {
    private static final Logger logger = LoggerFactory.getLogger(PojoSRBundleContext.class);
    private final Bundle m_bundle;
    private final ServiceRegistry m_reg;
    private final EventDispatcher m_dispatcher;
    private final Map<Long, Bundle> m_bundles;
    private final Map m_config;

    public PojoSRBundleContext(Bundle bundle, ServiceRegistry reg, EventDispatcher dispatcher, Map<Long, Bundle> bundles, Map config) {
        this.m_bundle = bundle;
        this.m_reg = reg;
        this.m_dispatcher = dispatcher;
        this.m_bundles = bundles;
        this.m_config = config;
    }

    public boolean ungetService(ServiceReference reference) {
        return this.m_reg.ungetService(this.m_bundle, reference);
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.m_dispatcher.removeListener(this, ServiceListener.class, listener);
    }

    @Override
    public void removeFrameworkListener(FrameworkListener listener) {
        this.m_dispatcher.removeListener(this, FrameworkListener.class, listener);
    }

    @Override
    public void removeBundleListener(BundleListener listener) {
        this.m_dispatcher.removeListener(this, BundleListener.class, listener);
    }

    @Override
    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        return this.m_reg.registerService(this.m_bundle, new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        return this.m_reg.registerService(this.m_bundle, clazzes, service, properties);
    }

    @Override
    public Bundle installBundle(String location) throws BundleException {
        throw new BundleException("pojosr can't do that");
    }

    @Override
    public Bundle installBundle(String location, InputStream input) throws BundleException {
        throw new BundleException("pojosr can't do that");
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getAllServiceReferences(clazz, filter);
    }

    @Override
    public ServiceReference<?> getServiceReference(String clazz) {
        try {
            return this.getBestServiceReference(this.getAllServiceReferences(clazz, null));
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private ServiceReference getBestServiceReference(ServiceReference[] refs) {
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        ServiceReference bestRef = refs[0];
        for (int i = 1; i < refs.length; ++i) {
            if (bestRef.compareTo(refs[i]) >= 0) continue;
            bestRef = refs[i];
        }
        return bestRef;
    }

    @Override
    public <S> S getService(ServiceReference<S> reference) {
        return this.m_reg.getService(this.m_bundle, reference);
    }

    @Override
    public String getProperty(String key) {
        Object result = this.m_config.get(key);
        return result == null ? System.getProperty(key) : result.toString();
    }

    @Override
    public File getDataFile(String filename) {
        File root = new File("bundle" + this.m_bundle.getBundleId());
        if (System.getProperty("org.osgi.framework.storage") != null) {
            root = new File(new File(System.getProperty("org.osgi.framework.storage")), root.getName());
        }
        root.mkdirs();
        return filename.trim().length() > 0 ? new File(root, filename) : root;
    }

    @Override
    public Bundle[] getBundles() {
        Bundle[] result = this.m_bundles.values().toArray(new Bundle[this.m_bundles.size()]);
        Arrays.sort(result, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                return (int)(o1.getBundleId() - o2.getBundleId());
            }
        });
        return result;
    }

    @Override
    public Bundle getBundle(long id) {
        return this.m_bundles.get(id);
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        List result;
        SimpleFilter simple = null;
        if (filter != null) {
            try {
                simple = SimpleFilter.parse(filter);
            }
            catch (Exception ex) {
                throw new InvalidSyntaxException(ex.getMessage(), filter);
            }
        }
        return (result = this.m_reg.getServiceReferences(clazz, simple)).isEmpty() ? null : result.toArray(new ServiceReference[result.size()]);
    }

    @Override
    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter(filter);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        try {
            this.addServiceListener(listener, null);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Invalid call to addServiceListener", (Throwable)e);
        }
    }

    @Override
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.m_dispatcher.addListener(this, ServiceListener.class, listener, filter == null ? null : FrameworkUtil.createFilter(filter));
    }

    @Override
    public void addFrameworkListener(FrameworkListener listener) {
        this.m_dispatcher.addListener(this, FrameworkListener.class, listener, null);
    }

    @Override
    public void addBundleListener(BundleListener listener) {
        this.m_dispatcher.addListener(this, BundleListener.class, listener, null);
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.registerService(clazz.getName(), service, properties);
    }

    @Override
    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.getServiceReference(clazz.getName());
    }

    @Override
    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference[] refs = this.getServiceReferences(clazz.getName(), filter);
        if (refs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(refs);
    }

    @Override
    public Bundle getBundle(String location) {
        for (Bundle bundle : this.m_bundles.values()) {
            if (!location.equals(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }
}

