/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mvnpm.esbuild.install.InstallException;
import io.mvnpm.esbuild.model.WebDependency;
import io.mvnpm.esbuild.util.PackageJsonCreator;
import io.mvnpm.importmap.ImportsDataBinding;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarInspector {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = Logger.getLogger(JarInspector.class.getName());
    public static final String PACKAGE_JSON = "package.json";
    public static final String IMPORTMAP_JSON = "importmap.json";
    public static final String POM_PROPERTIES = "pom.properties";
    private static final String MAVEN_ROOT = "META-INF/maven";
    private static final String MVNPM_PACKAGING_VERSION_KEY = "mvnpm.packagingVersion";
    private static final Set<String> COMPATIBLE_MVNPM_PACKAGING_VERSIONS = Set.of("1");
    public static final String MVNPM_MORE_ARCHIVE = "META-INF/.more.tgz";
    private static final Map<WebDependency.WebDependencyType, List<String>> PACKAGE_DIRS = Map.of(WebDependency.WebDependencyType.MVNPM, List.of("META-INF/resources/_static", ""), WebDependency.WebDependencyType.WEBJARS, List.of("META-INF/resources/webjars"));
    private static final List<String> MULTIPLE_GROUP_IDS = List.of("org.mvnpm.at.mvnpm");

    public static Path findMvnpmMoreArchive(Path dir) {
        Path moreArchive = dir.resolve(MVNPM_MORE_ARCHIVE);
        if (Files.exists(moreArchive, new LinkOption[0])) {
            return moreArchive;
        }
        return null;
    }

    public static Map<String, Path> findPackageNameAndRoot(String id, Path extractDir, WebDependency.WebDependencyType type) {
        Path dir = JarInspector.getPackageRootPath(extractDir, type);
        if (dir == null) {
            return Map.of();
        }
        Properties properties = JarInspector.getProperties(id, extractDir, type);
        String groupId = properties.getProperty("groupId", "");
        boolean shouldDoMultiple = MULTIPLE_GROUP_IDS.contains(groupId);
        Map<String, Path> found = JarInspector.findPackageNameAndRootWithPackage(dir, shouldDoMultiple);
        if (found.isEmpty() && type.equals((Object)WebDependency.WebDependencyType.MVNPM)) {
            found = JarInspector.findPackageNameAndRootWithImportMap(extractDir, properties);
        }
        return found;
    }

    private static Path getPackageRootPath(Path extractDir, WebDependency.WebDependencyType type) {
        if (!PACKAGE_DIRS.containsKey((Object)type)) {
            throw new RuntimeException("Invalid BundleType: " + type);
        }
        for (String packageDir : PACKAGE_DIRS.get((Object)type)) {
            Path dir = extractDir.resolve(packageDir);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            return dir;
        }
        return null;
    }

    private static Properties getProperties(String id, Path extractDir, WebDependency.WebDependencyType type) {
        String[] split;
        String mvnpmPackagingVersion;
        Properties properties = new Properties();
        if (type.equals((Object)WebDependency.WebDependencyType.MVNPM)) {
            properties = JarInspector.getPomProperties(extractDir);
        }
        if ((mvnpmPackagingVersion = properties.getProperty(MVNPM_PACKAGING_VERSION_KEY)) != null && (split = mvnpmPackagingVersion.split("\\.")).length > 0 && !COMPATIBLE_MVNPM_PACKAGING_VERSIONS.contains(split[0])) {
            throw new InstallException("This version of esbuild-java is not compatible with this artifact packaging structure: " + id + " (upgrade the version of esbuild-java or use a previous version of this package).", id);
        }
        return properties;
    }

    private static Map<String, Path> findPackageNameAndRootWithPackage(Path root, boolean shouldDoMultiple) {
        HashMap<String, Path> paths = new HashMap<String, Path>();
        List<Path> foundFiles = JarInspector.searchFiles(root, PACKAGE_JSON, shouldDoMultiple);
        for (Path path : foundFiles) {
            String packageName = JarInspector.readPackageName(path);
            paths.putIfAbsent(packageName, path.getParent());
        }
        return paths;
    }

    private static Map<String, Path> findPackageNameAndRootWithImportMap(Path root, Properties properties) {
        Optional<Path> importMapJson = JarInspector.searchFile(root, IMPORTMAP_JSON);
        if (importMapJson.isPresent()) {
            try {
                Path importMap = importMapJson.get();
                String json = new String(Files.readAllBytes(importMap));
                Map imports = ImportsDataBinding.toImports((String)json).getImports();
                String packageName = JarInspector.readPackageName(properties);
                String artifactId = properties.getProperty("artifactId");
                String version = properties.getProperty("version");
                Path fullExtractedRoot = null;
                String fullExtractedMain = null;
                for (Map.Entry ie : imports.entrySet()) {
                    if (((String)ie.getKey()).endsWith("/") && fullExtractedRoot == null) {
                        Path resources = importMap.getParent().resolve("resources");
                        Path packageRoot = Path.of(resources.toString(), JarInspector.toRelativeDir((String)ie.getValue(), artifactId));
                        fullExtractedRoot = root.resolve(packageRoot);
                        continue;
                    }
                    if (fullExtractedMain != null) continue;
                    fullExtractedMain = (String)ie.getValue();
                }
                String main = JarInspector.toRelativeMain(fullExtractedRoot.toString(), fullExtractedMain);
                PackageJsonCreator.createPackageJson(fullExtractedRoot, packageName, version, main);
                return Map.of(packageName, fullExtractedRoot);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return Map.of();
    }

    private static String toRelativeDir(String path, String artifactId) {
        if (!path.endsWith(artifactId + "/")) {
            path = path.substring(0, path.indexOf(artifactId) + artifactId.length() + 1);
        }
        return path;
    }

    private static String toRelativeMain(String root, String main) {
        root = root.substring(root.indexOf("_static"));
        Path rootPath = Paths.get(root, new String[0]);
        if (main.startsWith("/")) {
            main = main.substring(1);
        }
        return rootPath.relativize(Paths.get(main, new String[0])).toString();
    }

    private static String readPackageName(Properties properties) {
        Object groupId = properties.getProperty("groupId");
        if (((String)groupId).equals("org.mvnpm")) {
            groupId = "";
        } else {
            groupId = ((String)groupId).substring(10);
            groupId = ((String)groupId).replaceFirst("at.", "@");
            groupId = (String)groupId + "/";
        }
        return (String)groupId + properties.getProperty("artifactId");
    }

    private static String readPackageName(Path path) {
        try {
            JsonNode object = objectMapper.readTree(path.toFile());
            return object.get("name").asText();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Properties getPomProperties(Path extractDir) {
        Properties properties = new Properties();
        Path metaInfMavenDir = extractDir.resolve(MAVEN_ROOT);
        if (!Files.isDirectory(metaInfMavenDir, new LinkOption[0])) {
            return properties;
        }
        Optional<Path> maybePomProperties = JarInspector.searchFile(extractDir.resolve(MAVEN_ROOT), POM_PROPERTIES);
        if (maybePomProperties.isPresent()) {
            Path pomProperties = maybePomProperties.get();
            try {
                properties.load(Files.newInputStream(pomProperties, new OpenOption[0]));
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "could not read properties ''{0}''", pomProperties);
            }
        }
        return properties;
    }

    private static Optional<Path> searchFile(Path rootPath, String targetFileName) {
        List<Path> found = JarInspector.searchFiles(rootPath, targetFileName, false);
        if (!found.isEmpty()) {
            return Optional.of(found.get(0));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Path> searchFiles(Path rootPath, String targetFileName, boolean multiple) {
        ArrayList<Path> found = new ArrayList<Path>();
        LinkedList<Path> queue = new LinkedList<Path>();
        queue.add(rootPath);
        block8: while (!queue.isEmpty()) {
            Path currentPath = (Path)queue.poll();
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(currentPath);
                try {
                    Iterator<Path> iterator = stream.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block8;
                        Path entry = iterator.next();
                        if (Files.isDirectory(entry, new LinkOption[0])) {
                            queue.add(entry);
                            continue;
                        }
                        if (!entry.getFileName().toString().equals(targetFileName)) continue;
                        found.add(entry);
                        if (!multiple) break;
                    }
                    ArrayList<Path> arrayList = found;
                    return arrayList;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return found;
    }
}

