/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import io.mvnpm.esbuild.model.EntryPoint;
import io.mvnpm.esbuild.util.PathUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public record FileEntryPoint(Path rootDir, String script) implements EntryPoint
{
    @Override
    public Path process(Path workDir) {
        if (!Objects.equals(this.rootDir, workDir)) {
            PathUtils.copyEntries(this.rootDir, List.of(this.script), workDir);
            return workDir.resolve(this.script);
        }
        Path scriptPath = this.rootDir.resolve(this.script);
        if (!Files.exists(scriptPath, new LinkOption[0])) {
            throw new UncheckedIOException(new IOException("Entry file not found: " + scriptPath));
        }
        return scriptPath;
    }
}

