/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.install;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mvnpm.esbuild.install.MvnpmInfo;
import io.mvnpm.esbuild.model.WebDependency;
import io.mvnpm.esbuild.util.Archives;
import io.mvnpm.esbuild.util.JarInspector;
import io.mvnpm.esbuild.util.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class WebDepsInstaller {
    private static final Logger logger = Logger.getLogger(WebDepsInstaller.class.getName());
    private static final String MVNPM_DIR = ".mvnpm";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static boolean install(Path nodeModulesDir, List<WebDependency> dependencies) throws IOException {
        Path mvnpmInfoFile = WebDepsInstaller.getMvnpmInfoPath(nodeModulesDir);
        MvnpmInfo mvnpmInfo = WebDepsInstaller.readMvnpmInfo(mvnpmInfoFile);
        if (mvnpmInfo.installed().isEmpty() || dependencies.isEmpty()) {
            PathUtils.deleteRecursive(nodeModulesDir);
        }
        if (dependencies.isEmpty()) {
            return true;
        }
        if (!Files.exists(nodeModulesDir, new LinkOption[0])) {
            Files.createDirectories(nodeModulesDir, new FileAttribute[0]);
        }
        Path tmp = nodeModulesDir.resolve(MVNPM_DIR).resolve("tmp");
        HashSet<MvnpmInfo.InstalledDependency> installed = new HashSet<MvnpmInfo.InstalledDependency>();
        boolean changed = false;
        for (WebDependency dep : dependencies) {
            Path mvnpmMoreArchive;
            Optional<MvnpmInfo.InstalledDependency> alreadyInstalled = mvnpmInfo.installed().stream().filter(i -> i.id().equals(dep.id())).findFirst();
            if (alreadyInstalled.isPresent()) {
                logger.log(Level.FINE, "skipping package as it already exists ''{0}''", dep.id());
                installed.add((MvnpmInfo.InstalledDependency)alreadyInstalled.get());
                continue;
            }
            changed = true;
            Path extractDir = tmp.resolve(dep.id().replace(":", "/"));
            PathUtils.deleteRecursive(extractDir);
            Archives.unzip(dep.path(), extractDir);
            if (dep.type() == WebDependency.WebDependencyType.MVNPM && (mvnpmMoreArchive = JarInspector.findMvnpmMoreArchive(extractDir)) != null) {
                logger.log(Level.FINE, "Found more archive ''{0}''", mvnpmMoreArchive);
                try {
                    Archives.unTgz(mvnpmMoreArchive, mvnpmMoreArchive.getParent());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not extract .more.tgz archive '" + mvnpmMoreArchive + "'", e);
                }
            }
            Map<String, Path> packageNameAndRoot = JarInspector.findPackageNameAndRoot(dep.id(), extractDir, dep.type());
            ArrayList<String> dirs = new ArrayList<String>();
            if (!packageNameAndRoot.isEmpty()) {
                for (Map.Entry<String, Path> nameAndRoot : packageNameAndRoot.entrySet()) {
                    String packageName = nameAndRoot.getKey();
                    Path source = nameAndRoot.getValue();
                    Path target = nodeModulesDir.resolve(packageName);
                    dirs.add(packageName);
                    PathUtils.deleteRecursive(target);
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    PathUtils.safeMove(source, target);
                    logger.log(Level.FINE, "installed package ''{0}''", packageName);
                }
                installed.add(new MvnpmInfo.InstalledDependency(dep.id(), dirs));
                logger.log(Level.FINE, "installed dep ''{0}'' (''{1}'')", new Object[]{dep.path(), dep.id()});
                continue;
            }
            logger.log(Level.WARNING, "package.json not found in dep: ''{0}'' (''{1}'')", new Object[]{dep.path(), dep.id()});
        }
        PathUtils.deleteRecursive(tmp);
        Set installedDirs = installed.stream().flatMap(i -> i.dirs().stream()).collect(Collectors.toSet());
        Set legacyDirs = mvnpmInfo.installed().stream().flatMap(i -> i.dirs().stream()).collect(Collectors.toSet());
        for (String legacyDir : legacyDirs) {
            if (installedDirs.contains(legacyDir)) continue;
            changed = true;
            logger.log(Level.FINE, "removing package as it is not needed anymore ''{0}''", legacyDir);
            PathUtils.deleteRecursive(nodeModulesDir.resolve(legacyDir));
        }
        MvnpmInfo newMvnpmInfo = new MvnpmInfo(installed);
        WebDepsInstaller.writeMvnpmInfo(mvnpmInfoFile, newMvnpmInfo);
        return changed;
    }

    public static Path getMvnpmInfoPath(Path nodeModulesDir) {
        return nodeModulesDir.resolve(MVNPM_DIR).resolve("mvnpm.json");
    }

    public static MvnpmInfo readMvnpmInfo(Path path) {
        MvnpmInfo mvnpmInfo;
        block11: {
            if (!Files.exists(path, new LinkOption[0])) {
                return new MvnpmInfo(Set.of());
            }
            InputStream s = Files.newInputStream(path, new OpenOption[0]);
            try {
                mvnpmInfo = (MvnpmInfo)mapper.readValue(s, MvnpmInfo.class);
                if (s == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                    return new MvnpmInfo(Set.of());
                }
            }
            s.close();
        }
        return mvnpmInfo;
    }

    public static void writeMvnpmInfo(Path path, MvnpmInfo root) {
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValue(path.toFile(), (Object)root);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

