/*
 * Decompiled with CFR 0.152.
 */
package io.msgs.v2.entity;

import io.msgs.common.APIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AbstractEntity {
    protected JSONObject _data;

    public AbstractEntity() {
        this._data = new JSONObject();
    }

    public AbstractEntity(JSONObject data) {
        this._data = data;
    }

    protected Boolean _getBoolean(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            return this._data.getBoolean(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putBoolean(String key, Boolean value) {
        try {
            this._data.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected Integer _getInteger(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            return this._data.getInt(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putInteger(String key, Integer value) {
        try {
            this._data.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected Long _getLong(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            return this._data.getLong(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putLong(String key, Long value) {
        try {
            this._data.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected Double _getDouble(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            return this._data.getDouble(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putDouble(String key, Double value) {
        try {
            this._data.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected String _getString(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            return this._data.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putString(String key, String value) {
        try {
            this._data.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected JSONObject _getObject(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            return this._data.getJSONObject(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putObject(String key, JSONObject value) {
        try {
            this._data.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected JSONArray _getArray(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            return this._data.getJSONArray(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putArray(String key, JSONArray value) {
        try {
            this._data.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected String[] _getStringArray(String key) {
        try {
            if (!this._data.has(key) || this._data.isNull(key)) {
                return null;
            }
            JSONArray items = this._data.getJSONArray(key);
            String[] result = new String[items.length()];
            for (int i = 0; i < items.length(); ++i) {
                result[i] = items.getString(i);
            }
            return result;
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void _putStringArray(String key, String[] value) {
        try {
            if (value == null) {
                this._data.put(key, null);
            } else {
                this._data.put(key, (Object)new JSONArray(Arrays.asList(value)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected void _putDate(String key, Date value) {
        try {
            this._data.put(key, (Object)APIUtils.formatDate(value));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public JSONObject toJSON() {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iter = this._data.keys();
        while (iter.hasNext()) {
            keys.add((String)iter.next());
        }
        return this.toJSON(keys.toArray(new String[0]));
    }

    public JSONObject toJSON(String ... keys) {
        try {
            JSONObject result = new JSONObject();
            for (String key : keys) {
                if (!this._data.has(key)) continue;
                result.put(key, this._data.get(key));
            }
            return result;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String toString() {
        return this._data.toString();
    }
}

