/*
 * Decompiled with CFR 0.152.
 */
package io.msgs.v2;

import android.content.Context;
import android.content.SharedPreferences;
import io.msgs.common.APIException;
import io.msgs.common.client.Client;
import io.msgs.common.log.Logger;
import io.msgs.v2.MsgsClient;
import io.msgs.v2.entity.Endpoint;
import io.msgs.v2.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleMsgsClient {
    private static final String TAG = SimpleMsgsClient.class.getName();
    private static final String ENDPOINT_KEY = "endpoint";
    private final Context _context;
    private final MsgsClient _msgsClient;
    private final String _deviceType;
    private Endpoint _endpoint;

    private SimpleMsgsClient(Builder builder) {
        this._context = builder._context;
        this._msgsClient = new MsgsClient.Builder(builder._baseUrl, builder._apiKey).setClient(builder._client).build();
        this._deviceType = builder._deviceType == null ? "android" : builder._deviceType;
        this._loadState();
    }

    public void setLogLevel(Logger.Level level) {
        this._msgsClient.setLogLevel(level);
    }

    public void setLoggingEnabled(boolean enabled) {
        this._msgsClient.setLoggingEnabled(enabled);
    }

    private void _loadState() {
        try {
            String json = this._context.getSharedPreferences(TAG, 0).getString(ENDPOINT_KEY, null);
            this._endpoint = json != null ? new Endpoint(new JSONObject(json)) : null;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void _saveState() {
        SharedPreferences.Editor editor = this._context.getSharedPreferences(TAG, 0).edit();
        editor.putString(ENDPOINT_KEY, this._endpoint != null ? this._endpoint.toJSON().toString() : null);
        editor.commit();
    }

    public Endpoint registerEndpoint(String registrationId) throws APIException {
        if (this._endpoint != null && registrationId.equals(this._endpoint.getAddress())) {
            return this._endpoint;
        }
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this._deviceType);
        endpoint.setAddress(registrationId);
        endpoint.setName(Utils.getDeviceName());
        this._endpoint = this._endpoint != null ? this._msgsClient.forEndpoint(this._endpoint.getToken()).update(endpoint.toJSON()) : this._msgsClient.registerEndpoint(endpoint.toJSON());
        this._saveState();
        return this._endpoint;
    }

    public Endpoint getEndpoint() {
        return this._endpoint;
    }

    public void unregisterEndpoint() {
        this._endpoint = null;
        this._saveState();
    }

    public static class Builder {
        private final Context _context;
        private final String _baseUrl;
        private final String _apiKey;
        private Client _client;
        private String _deviceType;

        public Builder(Context context, String baseUrl, String apiKey) {
            this._context = context;
            this._baseUrl = baseUrl;
            this._apiKey = apiKey;
        }

        public Builder setDeviceType(String deviceType) {
            this._deviceType = deviceType;
            return this;
        }

        public Builder setClient(Client client) {
            this._client = client;
            return this;
        }

        public SimpleMsgsClient build() {
            return new SimpleMsgsClient(this);
        }
    }
}

