/*
 * Decompiled with CFR 0.152.
 */
package io.msgs.v2;

import android.text.TextUtils;
import io.msgs.common.APIException;
import io.msgs.v2.MsgsClient;
import io.msgs.v2.entity.ItemList;
import io.msgs.v2.entity.Subscription;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public abstract class RequestHelper {
    private static final String TAG = RequestHelper.class.getSimpleName();
    private static final boolean DEBUG = false;
    private MsgsClient _msgsClient;
    private String _basePath;

    public RequestHelper(MsgsClient msgsClient, String basePath) {
        this._msgsClient = msgsClient;
        this._basePath = basePath;
    }

    public RequestHelper(RequestHelper parent, String basePath) {
        this._msgsClient = parent._msgsClient;
        this._basePath = parent._basePath + "/" + basePath;
    }

    public Subscription fetchSubscription(String channelCode) throws APIException {
        try {
            JSONObject object = this._get("subscriptions/" + channelCode, null);
            return new Subscription(object);
        }
        catch (Exception e2) {
            APIException e2;
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public ItemList<Subscription> fetchSubscriptions(Sort sort, Integer limit, Integer offset) throws APIException {
        return this._fetchSubscriptions(null, null, sort, limit, offset);
    }

    public ItemList<Subscription> fetchSubscriptionsForChannels(Set<String> channelCodes, Sort sort, Integer limit, Integer offset) throws APIException {
        return this._fetchSubscriptions(channelCodes, null, sort, limit, offset);
    }

    public ItemList<Subscription> fetchSubscriptionsForTags(Set<String> tags, Sort sort, Integer limit, Integer offset) throws APIException {
        return this._fetchSubscriptions(null, tags, sort, limit, offset);
    }

    protected ItemList<Subscription> _fetchSubscriptions(Set<String> channelCodes, Set<String> tags, Sort sort, Integer limit, Integer offset) throws APIException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (channelCodes != null) {
                params.put("channelCodes", TextUtils.join((CharSequence)",", channelCodes));
            }
            if (tags != null) {
                params.put("tags", TextUtils.join((CharSequence)",", tags));
            }
            if (limit != null) {
                params.put("limit", String.valueOf(limit));
            }
            if (offset != null) {
                params.put("offset", String.valueOf(offset));
            }
            if (sort != null) {
                params.put("sort", sort.toString());
            }
            JSONObject object = this._get("subscriptions", params);
            return new ItemList<Subscription>(Subscription.class, object);
        }
        catch (Exception e2) {
            APIException e2;
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public Subscription subscribe(String channelCode) throws APIException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("channelCode", channelCode);
            JSONObject object = this._post("subscriptions", params);
            return new Subscription(object);
        }
        catch (Exception e2) {
            APIException e2;
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public void unsubscribe(String channelCode) throws APIException {
        try {
            this._delete("subscriptions/" + channelCode);
        }
        catch (Exception e2) {
            APIException e2;
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    protected JSONObject _get(String path, Map<String, String> params) throws APIException {
        return this._msgsClient._get(path == null ? this._basePath : this._basePath + "/" + path, params);
    }

    protected JSONObject _post(String path, Map<String, String> params) throws APIException {
        return this._msgsClient._post(path == null ? this._basePath : this._basePath + "/" + path, params);
    }

    protected JSONObject _delete(String path) throws APIException {
        return this._msgsClient._delete(path == null ? this._basePath : this._basePath + "/" + path);
    }

    protected Map<String, String> _getParams(JSONObject data) {
        return this._msgsClient._getParams(data);
    }

    public static enum Sort {
        CREATED_AT("createdAt"),
        CHANNEL_CREATED_AT("channel.createdAt"),
        CHANNEL_CREATED_AT_ASC("channel.createdAt asc"),
        CHANNEL_CREATED_AT_DESC("channel.createdAt desc"),
        CHANNEL_UPDATED_AT("channel.updatedAt"),
        CHANNEL_UPDATED_AT_ASC("channel.updatedAt asc"),
        CHANNEL_UPDATED_AT_DESC("channel.updatedAt desc");

        private String _name;

        private Sort(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

