/*
 * Decompiled with CFR 0.152.
 */
package io.msgs.v2;

import io.msgs.common.APIException;
import io.msgs.common.APIUtils;
import io.msgs.common.client.Client;
import io.msgs.common.client.MsgsHttpUrlConnectionClient;
import io.msgs.common.entity.UrlEncodedFormEntity;
import io.msgs.common.log.Logger;
import io.msgs.v2.EndpointRequestHelper;
import io.msgs.v2.UserRequestHelper;
import io.msgs.v2.entity.Endpoint;
import io.msgs.v2.entity.User;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgsClient {
    private final String _baseURL;
    private final String _apiKey;
    private final String _customUserAgent;
    private final Client _client;
    private final Logger _logger = new Logger();

    private MsgsClient(Builder builder) {
        this._baseURL = !builder._baseURL.endsWith("/") ? builder._baseURL + "/" : builder._baseURL;
        this._apiKey = builder._apiKey;
        this._customUserAgent = builder._customUserAgent;
        this._logger.setTag(MsgsClient.class.getName());
        this._client = builder._client == null ? new MsgsHttpUrlConnectionClient() : builder._client;
    }

    public void setLogLevel(Logger.Level level) {
        this._logger.setLevel(level);
        this._client.setLogLevel(level);
    }

    public void setLoggingEnabled(boolean enabled) {
        this._logger.setEnabled(enabled);
        this._client.setLoggingEnabled(enabled);
    }

    public Endpoint registerEndpoint(JSONObject data) throws APIException {
        try {
            JSONObject object = this._post("endpoints", this._getParams(data));
            return new Endpoint(object);
        }
        catch (Exception e2) {
            APIException e2;
            this._logger.e("Error registering endpoint!", e2);
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public User registerUser(JSONObject data) throws APIException {
        try {
            JSONObject object = this._post("users", this._getParams(data));
            return new User(object);
        }
        catch (Exception e2) {
            APIException e2;
            this._logger.e("Error registering user!", e2);
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public UserRequestHelper forUser(String token) {
        return new UserRequestHelper(this, token);
    }

    public EndpointRequestHelper forEndpoint(String token) {
        return new EndpointRequestHelper(this, token);
    }

    private Map<String, String> _getApiHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-MsgsIo-APIKey", this._apiKey);
        if (this._customUserAgent != null) {
            headers.put("User-Agent", this._customUserAgent);
        }
        return headers;
    }

    protected Map<String, String> _getParams(JSONObject data) {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator iter = data.keys();
        while (iter.hasNext()) {
            try {
                String key = (String)iter.next();
                Object value = data.get(key);
                if (value == null) continue;
                if (value instanceof Boolean) {
                    value = (Boolean)value != false ? 1 : 0;
                }
                params.put(key, String.valueOf(value));
            }
            catch (JSONException jSONException) {}
        }
        return params;
    }

    protected JSONObject _get(String path, Map<String, String> params) throws APIException {
        return this._client.get(this._baseURL + path + (params != null && !params.isEmpty() ? "?" + APIUtils.createQueryString(params) : ""), this._getApiHeader());
    }

    protected JSONObject _post(String path, Map<String, String> params) throws APIException {
        return this._client.post(this._baseURL + path, params == null ? null : new UrlEncodedFormEntity(params), this._getApiHeader());
    }

    protected JSONObject _delete(String path) throws APIException {
        return this._client.delete(this._baseURL + path, this._getApiHeader());
    }

    public static class Builder {
        private final String _baseURL;
        private final String _apiKey;
        private String _customUserAgent;
        private Client _client;

        public Builder(String baseURL, String apiKey) {
            this._baseURL = baseURL;
            this._apiKey = apiKey;
        }

        public Builder setClient(Client client) {
            this._client = client;
            return this;
        }

        public Builder setUserAgent(String customUserAgent) {
            this._customUserAgent = customUserAgent;
            return this;
        }

        public MsgsClient build() {
            return new MsgsClient(this);
        }
    }
}

