/*
 * Decompiled with CFR 0.152.
 */
package io.msgs.v1;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import io.msgs.common.APIException;
import io.msgs.common.APIUtils;
import io.msgs.common.client.Client;
import io.msgs.common.client.MsgsHttpUrlConnectionClient;
import io.msgs.common.entity.UrlEncodedFormEntity;
import io.msgs.common.log.Logger;
import io.msgs.v1.Subscription;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class MsgsClient {
    private static final String TAG = MsgsClient.class.getSimpleName();
    private static final String DEVICE_TOKEN_KEY = "deviceToken";
    private static final String NOTIFICATION_TAG = "NotificationManager";
    private static final String NOTIFICATION_TOKEN_KEY = "notificationToken";
    private static final String LAST_REGISTER_CHANNEL_ID_KEY = "lastRegisterChannelId";
    private static final String UPDATED_AT_KEY = "updatedAt";
    private static final int TOKEN_TIMEOUT_IN_DAYS = 3;
    private static final String DEVICE_FAMILY = "gcm";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private final Context _context;
    private final String _baseURL;
    private final String _appId;
    private Client _client;
    private final Logger _logger = new Logger();

    private MsgsClient(Builder builder) {
        this._context = builder._context;
        this._baseURL = !builder._baseURL.endsWith("/") ? builder._baseURL + "/" : builder._baseURL;
        this._appId = builder._appId;
        this._client = builder._client == null ? new MsgsHttpUrlConnectionClient() : builder._client;
        this._logger.setTag(MsgsClient.class.getName());
    }

    public void setLogLevel(Logger.Level level) {
        this._logger.setLevel(level);
        this._client.setLogLevel(level);
    }

    public void setLoggingEnabled(boolean enabled) {
        this._logger.setEnabled(enabled);
        this._client.setLoggingEnabled(enabled);
    }

    public boolean isRegistered() {
        return this.getNotificationToken() != null;
    }

    public String getDeviceToken() {
        return this._context.getSharedPreferences(NOTIFICATION_TAG, 0).getString(this._appId + "." + DEVICE_TOKEN_KEY, null);
    }

    public String getNotificationToken() {
        return this._context.getSharedPreferences(NOTIFICATION_TAG, 0).getString(this._appId + "." + NOTIFICATION_TOKEN_KEY, null);
    }

    private String _getLastRegisterChannelId() {
        return this._context.getSharedPreferences(NOTIFICATION_TAG, 0).getString(this._appId + "." + LAST_REGISTER_CHANNEL_ID_KEY, null);
    }

    private Date _getUpdatedAt() {
        long updatedAtTime = this._context.getSharedPreferences(NOTIFICATION_TAG, 0).getLong(this._appId + "." + UPDATED_AT_KEY, 0L);
        if (updatedAtTime == 0L) {
            return null;
        }
        return new Date(updatedAtTime);
    }

    public void registerDevice(String deviceToken) throws APIException {
        this.registerDevice(deviceToken, null);
    }

    public void registerDevice(String deviceToken, String channelId) throws APIException {
        try {
            this._logger.d("Send device registration request for device token: " + deviceToken + " app ID: " + this._appId);
            if (deviceToken.equals(this.getDeviceToken()) && this.getNotificationToken() != null && (this._getLastRegisterChannelId() == null && channelId == null || this._getLastRegisterChannelId() != null && this._getLastRegisterChannelId().equals(channelId)) && this._getUpdatedAt() != null && new Date().getTime() - this._getUpdatedAt().getTime() < 3L) {
                this._logger.d("Registration request cancelled, all data seems up-to-date and recent enough");
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appId", Uri.encode((String)this._appId));
            params.put("deviceFamily", DEVICE_FAMILY);
            params.put(DEVICE_TOKEN_KEY, deviceToken);
            if (channelId != null) {
                params.put("channelId", channelId);
            }
            String path = "subscribers";
            String notificationToken = this.getNotificationToken();
            if (notificationToken != null) {
                this._logger.d("Using existing notification token: " + notificationToken);
                path = "subscribers/;update";
                params.put(NOTIFICATION_TOKEN_KEY, notificationToken);
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
            JSONObject result = this._client.post(this._baseURL + path, entity, null);
            this._logger.d("Registration request sent");
            if (result != null) {
                notificationToken = APIUtils.getString(result, NOTIFICATION_TOKEN_KEY, null);
                this._saveRegistrationData(deviceToken, notificationToken, channelId);
                this._logger.d("Notification token: " + notificationToken);
            } else {
                this._logger.d("No notification token returned");
            }
            this._logger.d("Registration request processed");
        }
        catch (Exception e2) {
            APIException e2;
            this._logger.e("Error registering device", e2);
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public Subscription[] getSubscriptions() throws APIException {
        try {
            String notificationToken = this.getNotificationToken();
            if (notificationToken == null) {
                throw new APIException("Device is not registered");
            }
            JSONArray rawSubscriptions = this._client.getArray(this._baseURL + "subscriptions/" + this._appId + "/" + notificationToken, null);
            ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
            for (int i = 0; i < rawSubscriptions.length(); ++i) {
                String[] rawDays;
                JSONObject rawSubscription = rawSubscriptions.getJSONObject(i);
                Subscription subscription = new Subscription();
                subscription.setId(APIUtils.getString(rawSubscription, "id", null));
                subscription.setChannelId(APIUtils.getString(rawSubscription, "channelId", ""));
                String rawStartDate = APIUtils.getString(rawSubscription, "dateStart", null);
                Date startDate = rawStartDate == null ? null : DATE_FORMAT.parse(rawStartDate);
                String rawEndDate = APIUtils.getString(rawSubscription, "dateEnd", null);
                Date endDate = rawEndDate == null ? null : DATE_FORMAT.parse(rawEndDate);
                subscription.setDatePeriod(startDate, endDate);
                String rawStartTime = APIUtils.getString(rawSubscription, "timeStart", null);
                Subscription.Time startTime = rawStartTime == null ? null : new Subscription.Time(Integer.parseInt(rawStartTime.split(":")[0]), Integer.parseInt(rawStartTime.split(":")[1]));
                String rawEndTime = APIUtils.getString(rawSubscription, "timeEnd", null);
                Subscription.Time endTime = rawEndTime == null ? null : new Subscription.Time(Integer.parseInt(rawEndTime.split(":")[0]), Integer.parseInt(rawEndTime.split(":")[1]));
                subscription.setTimePeriod(startTime, endTime);
                int weekdays = 0;
                String rawDowSet = APIUtils.getString(rawSubscription, "dowSet", "");
                for (String rawDay : rawDays = rawDowSet.split(",")) {
                    if (rawDay.equals("1")) {
                        weekdays &= 1;
                        continue;
                    }
                    if (rawDay.equals("2")) {
                        weekdays &= 2;
                        continue;
                    }
                    if (rawDay.equals("3")) {
                        weekdays &= 4;
                        continue;
                    }
                    if (rawDay.equals("4")) {
                        weekdays &= 8;
                        continue;
                    }
                    if (rawDay.equals("5")) {
                        weekdays &= 0x10;
                        continue;
                    }
                    if (rawDay.equals("6")) {
                        weekdays &= 0x20;
                        continue;
                    }
                    if (!rawDay.equals("7")) continue;
                    weekdays &= 0x40;
                }
                subscription.setWeekdays(weekdays);
                subscriptions.add(subscription);
            }
            return subscriptions.toArray(new Subscription[0]);
        }
        catch (Exception e2) {
            APIException e2;
            this._logger.e("Error adding subscription", e2);
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public void subscribe(String channelId) throws APIException {
        this.subscribe(new Subscription().setChannelId(channelId));
    }

    public void subscribe(Subscription subscription) throws APIException {
        try {
            String notificationToken = this.getNotificationToken();
            if (notificationToken == null) {
                throw new APIException("Device is not registered");
            }
            this._logger.d("Add subscription for channel " + subscription.getChannelId());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appId", this._appId);
            params.put(NOTIFICATION_TOKEN_KEY, notificationToken);
            params.put("channelId", subscription.getChannelId());
            if (subscription.getStartDate() != null) {
                params.put("dateStart", DATE_FORMAT.format(subscription.getStartDate()));
            }
            if (subscription.getEndDate() != null) {
                params.put("dateEnd", DATE_FORMAT.format(subscription.getEndDate()));
            }
            if (subscription.getStartTime() != null) {
                params.put("timeStart", String.format("%02d:%02d", subscription.getStartTime().getHours(), subscription.getStartTime().getMinutes()));
            }
            if (subscription.getEndTime() != null) {
                params.put("timeEnd", String.format("%02d:%02d", subscription.getEndTime().getHours(), subscription.getEndTime().getMinutes()));
            }
            if (subscription.getWeekdays() > 0) {
                String dowSet = "";
                if (subscription.hasWeekday(1)) {
                    dowSet = dowSet + (dowSet.length() > 0 ? "," : "") + "1";
                }
                if (subscription.hasWeekday(2)) {
                    dowSet = dowSet + (dowSet.length() > 0 ? "," : "") + "2";
                }
                if (subscription.hasWeekday(4)) {
                    dowSet = dowSet + (dowSet.length() > 0 ? "," : "") + "3";
                }
                if (subscription.hasWeekday(8)) {
                    dowSet = dowSet + (dowSet.length() > 0 ? "," : "") + "4";
                }
                if (subscription.hasWeekday(16)) {
                    dowSet = dowSet + (dowSet.length() > 0 ? "," : "") + "4";
                }
                if (subscription.hasWeekday(32)) {
                    dowSet = dowSet + (dowSet.length() > 0 ? "," : "") + "6";
                }
                if (subscription.hasWeekday(64)) {
                    dowSet = dowSet + (dowSet.length() > 0 ? "," : "") + "7";
                }
                params.put("dowSet", dowSet);
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
            JSONObject result = this._client.post(this._baseURL + "subscriptions", entity, null);
            String id = APIUtils.getString(result, "id", null);
            subscription.setId(id);
            this._logger.d("Subscription ID: " + id);
        }
        catch (Exception e2) {
            APIException e2;
            this._logger.e("Error adding subscription", e2);
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public void unsubscribe(String channelId) throws APIException {
        String notificationToken = this.getNotificationToken();
        if (notificationToken == null) {
            throw new APIException("Device is not registered");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put("appId", this._appId);
            params.put(NOTIFICATION_TOKEN_KEY, notificationToken);
            params.put("channelId", channelId);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
            this._client.post(this._baseURL + "subscriptions/;delete", entity, null);
        }
        catch (Exception e2) {
            APIException e2;
            this._logger.e("Error adding subscription", e2);
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public void unsubscribe(int subscriptionId) throws APIException {
        String notificationToken = this.getNotificationToken();
        if (notificationToken == null) {
            throw new APIException("Device is not registered");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put("appId", this._appId);
            params.put(NOTIFICATION_TOKEN_KEY, notificationToken);
            params.put("subscriptionId", String.valueOf(subscriptionId));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
            this._client.post("subscriptions/;delete", entity, null);
        }
        catch (Exception e2) {
            APIException e2;
            this._logger.e("Error adding subscription", e2);
            if (!(e2 instanceof APIException)) {
                e2 = new APIException(e2);
            }
            throw (APIException)e2;
        }
    }

    public void unsubscribe(Subscription subscription) throws APIException {
        if (subscription.getId() != null) {
            this.unsubscribe(subscription.getId());
        }
    }

    private void _saveRegistrationData(String deviceToken, String notificationToken, String channelId) {
        SharedPreferences.Editor editor = this._context.getSharedPreferences(NOTIFICATION_TAG, 0).edit();
        editor.putString(this._appId + "." + DEVICE_TOKEN_KEY, deviceToken);
        editor.putString(this._appId + "." + NOTIFICATION_TOKEN_KEY, notificationToken);
        editor.putString(this._appId + "." + LAST_REGISTER_CHANNEL_ID_KEY, channelId);
        editor.putLong(this._appId + "." + UPDATED_AT_KEY, new Date().getTime());
        editor.commit();
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class Builder {
        private final Context _context;
        private final String _baseURL;
        private final String _appId;
        private Client _client;

        public Builder(Context context, String baseURL, String appId) {
            this._context = context;
            this._baseURL = baseURL;
            this._appId = appId;
        }

        public Builder setClient(Client client) {
            this._client = client;
            return this;
        }

        public MsgsClient build() {
            return new MsgsClient(this);
        }
    }
}

