/*
 * Decompiled with CFR 0.152.
 */
package io.msgs.common.log;

import android.util.Log;

public class Logger {
    private boolean _enabled = true;
    private Level _level = Level.ERROR;
    private String _tag = Logger.class.getName();

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setLevel(Level level) {
        this._level = level;
    }

    public void setTag(String tag) {
        this._tag = tag;
    }

    public String getTag() {
        return this._tag;
    }

    public void d(String message) {
        if (!this._enabled || this._level == Level.INFO || this._level == Level.WARN || this._level == Level.ERROR) {
            return;
        }
        Log.d((String)this._tag, (String)message);
    }

    public void i(String message) {
        if (!this._enabled || this._level == Level.WARN || this._level == Level.ERROR) {
            return;
        }
        Log.i((String)this._tag, (String)message);
    }

    public void w(String message) {
        if (!this._enabled || this._level == Level.ERROR) {
            return;
        }
        Log.w((String)this._tag, (String)message);
    }

    public void w(String message, Throwable throwable) {
        if (!this._enabled || this._level == Level.ERROR) {
            return;
        }
        Log.w((String)this._tag, (String)message, (Throwable)throwable);
    }

    public void e(String message, Throwable throwable) {
        if (!this._enabled) {
            return;
        }
        Log.e((String)this._tag, (String)message, (Throwable)throwable);
    }

    public static enum Level {
        VERBOSE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

