/*
 * Decompiled with CFR 0.152.
 */
package io.msgs.okhttp;

import io.msgs.common.APIException;
import io.msgs.common.client.Client;
import io.msgs.common.entity.HttpEntity;
import io.msgs.common.log.Logger;
import java.io.IOException;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgsOkHttpClient
implements Client {
    private final OkHttpClient _okHttpClient;
    private final Logger _logger = new Logger();

    public MsgsOkHttpClient(OkHttpClient okHttpClient) {
        this._okHttpClient = okHttpClient;
        this._logger.setTag(MsgsOkHttpClient.class.getName());
    }

    public JSONObject post(String url, HttpEntity entity, Map<String, String> headers) throws APIException {
        String requestBody;
        this._logger.d("--> POST " + url);
        try {
            requestBody = entity.getBody();
        }
        catch (IOException ex) {
            throw new APIException((Exception)ex);
        }
        Headers callHeaders = this._mapToHeaders(headers);
        Request request = new Request.Builder().url(url).headers(callHeaders).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestBody)).build();
        try {
            Response response = this._okHttpClient.newCall(request).execute();
            this._logger.d("<-- POST " + url + " [" + response.code() + "]");
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            String bodyString = responseBody.string();
            this._logger.d(bodyString);
            return new JSONObject(bodyString);
        }
        catch (IOException ex) {
            throw new APIException((Exception)ex);
        }
        catch (JSONException ex) {
            throw new APIException((Exception)((Object)ex));
        }
    }

    public JSONObject get(String url, Map<String, String> headers) throws APIException {
        this._logger.d("--> GET " + url);
        Headers callHeaders = this._mapToHeaders(headers);
        Request request = new Request.Builder().url(url).headers(callHeaders).get().build();
        try {
            Response response = this._okHttpClient.newCall(request).execute();
            this._logger.d("<-- GET " + url + " [" + response.code() + "]");
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            String bodyString = responseBody.string();
            this._logger.d(bodyString);
            return new JSONObject(bodyString);
        }
        catch (IOException ex) {
            throw new APIException((Exception)ex);
        }
        catch (JSONException ex) {
            throw new APIException((Exception)((Object)ex));
        }
    }

    public JSONArray getArray(String url, Map<String, String> headers) throws APIException {
        this._logger.d("--> GET " + url);
        Headers callHeaders = this._mapToHeaders(headers);
        Request request = new Request.Builder().url(url).headers(callHeaders).get().build();
        try {
            Response response = this._okHttpClient.newCall(request).execute();
            this._logger.d("<-- GET " + url + " [" + response.code() + "]");
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            String bodyString = responseBody.string();
            this._logger.d(bodyString);
            return new JSONArray(bodyString);
        }
        catch (IOException ex) {
            throw new APIException((Exception)ex);
        }
        catch (JSONException ex) {
            throw new APIException((Exception)((Object)ex));
        }
    }

    public JSONObject delete(String url, Map<String, String> headers) throws APIException {
        this._logger.d("--> DELETE " + url);
        Headers callHeaders = this._mapToHeaders(headers);
        Request request = new Request.Builder().url(url).headers(callHeaders).delete().build();
        try {
            Response response = this._okHttpClient.newCall(request).execute();
            this._logger.d("<-- DELETE " + url + " [" + response.code() + "]");
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return null;
            }
            String bodyString = responseBody.string();
            this._logger.d(bodyString);
            return new JSONObject(bodyString);
        }
        catch (IOException ex) {
            throw new APIException((Exception)ex);
        }
        catch (JSONException ex) {
            throw new APIException((Exception)((Object)ex));
        }
    }

    public void setLoggingEnabled(boolean enabled) {
    }

    public void setLogLevel(Logger.Level level) {
    }

    private Headers _mapToHeaders(Map<String, String> headersMap) {
        Headers.Builder callHeadersBuilder = new Headers.Builder();
        if (headersMap != null) {
            for (Map.Entry<String, String> header : headersMap.entrySet()) {
                callHeadersBuilder.add(header.getKey(), header.getValue());
            }
        }
        return callHeadersBuilder.build();
    }
}

