/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.subscriptions.CNode;
import io.moquette.broker.subscriptions.CTrie;
import io.moquette.broker.subscriptions.ISubscriptionsDirectory;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.Topic;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTrieSubscriptionDirectory
implements ISubscriptionsDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(CTrieSubscriptionDirectory.class);
    private CTrie ctrie;
    private volatile ISubscriptionsRepository subscriptionsRepository;

    @Override
    public void init(ISubscriptionsRepository subscriptionsRepository) {
        LOG.info("Initializing CTrie");
        this.ctrie = new CTrie();
        LOG.info("Initializing subscriptions store...");
        this.subscriptionsRepository = subscriptionsRepository;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reloading all stored subscriptions. SubscriptionTree = {}", (Object)this.dumpTree());
        }
        for (Subscription subscription : this.subscriptionsRepository.listAllSubscriptions()) {
            LOG.debug("Re-subscribing {}", (Object)subscription);
            this.ctrie.addToTree(subscription);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stored subscriptions have been reloaded. SubscriptionTree = {}", (Object)this.dumpTree());
        }
    }

    Optional<CNode> lookup(Topic topic) {
        return this.ctrie.lookup(topic);
    }

    @Override
    public Set<Subscription> matchWithoutQosSharpening(Topic topic) {
        return this.ctrie.recursiveMatch(topic);
    }

    @Override
    public Set<Subscription> matchQosSharpening(Topic topic) {
        Set<Subscription> subscriptions = this.matchWithoutQosSharpening(topic);
        HashMap<String, Subscription> subsGroupedByClient = new HashMap<String, Subscription>();
        for (Subscription sub : subscriptions) {
            Subscription existingSub = (Subscription)subsGroupedByClient.get(sub.clientId);
            if (existingSub != null && !existingSub.qosLessThan(sub)) continue;
            subsGroupedByClient.put(sub.clientId, sub);
        }
        return new HashSet<Subscription>(subsGroupedByClient.values());
    }

    @Override
    public void add(Subscription newSubscription) {
        this.ctrie.addToTree(newSubscription);
        this.subscriptionsRepository.addNewSubscription(newSubscription);
    }

    @Override
    public void removeSubscription(Topic topic, String clientID) {
        this.ctrie.removeFromTree(topic, clientID);
        this.subscriptionsRepository.removeSubscription(topic.toString(), clientID);
    }

    @Override
    public int size() {
        return this.ctrie.size();
    }

    @Override
    public String dumpTree() {
        return this.ctrie.dumpTree();
    }
}

