/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v3;

import io.mongock.driver.mongodb.springdata.v3.SpringDataMongoV3DriverBase;
import io.mongock.utils.Constants;
import io.mongock.utils.TimeService;
import io.mongock.utils.annotation.NotThreadSafe;
import org.springframework.data.mongodb.core.MongoTemplate;

@NotThreadSafe
public class SpringDataMongoV3Driver
extends SpringDataMongoV3DriverBase {
    protected SpringDataMongoV3Driver(MongoTemplate mongoTemplate, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoTemplate, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    public static SpringDataMongoV3Driver withDefaultLock(MongoTemplate mongoTemplate) {
        return SpringDataMongoV3Driver.withLockStrategy(mongoTemplate, Constants.DEFAULT_LOCK_ACQUIRED_FOR_MILLIS, Constants.DEFAULT_QUIT_TRYING_AFTER_MILLIS, Constants.DEFAULT_TRY_FREQUENCY_MILLIS);
    }

    public static SpringDataMongoV3Driver withLockStrategy(MongoTemplate mongoTemplate, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        return new SpringDataMongoV3Driver(mongoTemplate, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    @Deprecated
    public static SpringDataMongoV3Driver withLockSetting(MongoTemplate mongoTemplate, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        TimeService timeService = new TimeService();
        return SpringDataMongoV3Driver.withLockStrategy(mongoTemplate, timeService.minutesToMillis(lockAcquiredForMinutes), timeService.minutesToMillis(maxWaitingForLockMinutes * (long)maxTries), 1000L);
    }
}

