/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class LogUtils {
    private LogUtils() {
    }

    public static void logMethodWithArguments(Logger logger, String methodName, List<Object> changelogInvocationParameters) {
        String arguments = changelogInvocationParameters.stream().map(LogUtils::getParameterType).collect(Collectors.joining(", "));
        logger.info("method[{}] with arguments: [{}]", (Object)methodName, (Object)arguments);
    }

    private static String getParameterType(Object obj) {
        String className = obj != null ? obj.getClass().getName() : "{null argument}";
        int mongockProxyPrefixIndex = className.indexOf("_$$_mongock_");
        if (mongockProxyPrefixIndex > 0) {
            return className.substring(0, mongockProxyPrefixIndex);
        }
        return className;
    }
}

