/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.springboot.base.builder;

import io.mongock.api.config.MongockConfiguration;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.runner.core.builder.BuilderType;
import io.mongock.runner.core.builder.RunnerBuilderBase;
import io.mongock.runner.core.event.EventPublisher;
import io.mongock.runner.core.executor.ExecutorBuilder;
import io.mongock.runner.core.executor.changelog.ChangeLogServiceBase;
import io.mongock.runner.core.executor.dependency.DependencyContext;
import io.mongock.runner.core.executor.dependency.DependencyManager;
import io.mongock.runner.core.executor.dependency.DependencyManagerWithContext;
import io.mongock.runner.spring.base.context.SpringDependencyContext;
import io.mongock.runner.spring.base.events.SpringMigrationFailureEvent;
import io.mongock.runner.spring.base.events.SpringMigrationStartedEvent;
import io.mongock.runner.spring.base.events.SpringMigrationSuccessEvent;
import io.mongock.runner.spring.base.util.ProfileUtil;
import io.mongock.runner.springboot.base.MongockApplicationRunner;
import io.mongock.runner.springboot.base.MongockInitializingBeanRunner;
import io.mongock.utils.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

public abstract class SpringbootBuilderBase<SELF extends SpringbootBuilderBase<SELF, CONFIG>, CONFIG extends MongockConfiguration>
extends RunnerBuilderBase<SELF, CONFIG> {
    private static final String DEFAULT_PROFILE = "default";

    protected SpringbootBuilderBase(BuilderType builderType, ExecutorBuilder<CONFIG> executorBuilder, ChangeLogServiceBase changeLogService, CONFIG config) {
        super(builderType, executorBuilder, changeLogService, (DependencyManager)new DependencyManagerWithContext(), config);
        this.parameterNameFunction = SpringbootBuilderBase.buildParameterNameFunctionForSpring();
    }

    private static List<String> getActiveProfilesFromContext(ApplicationContext springContext) {
        Environment springEnvironment = springContext.getEnvironment();
        return springEnvironment != null && CollectionUtils.isNotNullOrEmpty((Object[])springEnvironment.getActiveProfiles()) ? Arrays.asList(springEnvironment.getActiveProfiles()) : Collections.singletonList(DEFAULT_PROFILE);
    }

    private static Function<Parameter, String> buildParameterNameFunctionForSpring() {
        return parameter -> {
            String name;
            String string = name = parameter.isAnnotationPresent(Named.class) ? parameter.getAnnotation(Named.class).value() : null;
            if (name == null) {
                name = parameter.isAnnotationPresent(Qualifier.class) ? parameter.getAnnotation(Qualifier.class).value() : null;
            }
            return name;
        };
    }

    public SELF setSpringContext(ApplicationContext springContext) {
        this.getDependencyManager().setContext((DependencyContext)new SpringDependencyContext(springContext));
        this.setEventPublisherInternal((ApplicationEventPublisher)springContext);
        return (SELF)((Object)((SpringbootBuilderBase)this.getInstance()));
    }

    @Deprecated
    public SELF setEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.setEventPublisherInternal(applicationEventPublisher);
        return (SELF)((Object)((SpringbootBuilderBase)this.getInstance()));
    }

    private void setEventPublisherInternal(ApplicationEventPublisher applicationEventPublisher) {
        if (applicationEventPublisher == null) {
            throw new MongockException("EventPublisher cannot e null");
        }
        this.eventPublisher = new EventPublisher(() -> applicationEventPublisher.publishEvent((ApplicationEvent)new SpringMigrationStartedEvent((Object)this)), result -> applicationEventPublisher.publishEvent((ApplicationEvent)new SpringMigrationSuccessEvent((Object)this, result)), result -> applicationEventPublisher.publishEvent((ApplicationEvent)new SpringMigrationFailureEvent((Object)this, result)));
    }

    public MongockApplicationRunner buildApplicationRunner() {
        return new MongockApplicationRunner(this.buildRunner());
    }

    public MongockInitializingBeanRunner buildInitializingBeanRunner() {
        return new MongockInitializingBeanRunner(this.buildRunner());
    }

    protected void beforeBuildRunner(ConnectionDriver driver) {
        super.beforeBuildRunner(driver);
        DependencyContext dependencyContext = this.getDependencyManager().getDependencyContext();
        Environment environment = ((SpringDependencyContext)dependencyContext).getSpringContext().getEnvironment();
        if (environment.getActiveProfiles() != null && Stream.of(environment.getActiveProfiles()).anyMatch("mongock-cli-profile"::equalsIgnoreCase)) {
            MongockConfiguration config = this.getConfig();
            config.setEnabled(false);
            this.setConfig(config);
        }
    }

    protected Function<AnnotatedElement, Boolean> getAnnotationFilter() {
        DependencyContext dependencyContext = this.getDependencyManager().getDependencyContext();
        ApplicationContext springContext = ((SpringDependencyContext)dependencyContext).getSpringContext();
        return annotated -> ProfileUtil.matchesActiveSpringProfile(SpringbootBuilderBase.getActiveProfilesFromContext(springContext), Profile.class, (AnnotatedElement)annotated, element -> element.getAnnotation(Profile.class).value());
    }

    protected void validateConfigurationAndInjections(ConnectionDriver driver) {
        super.validateConfigurationAndInjections(driver);
        if (!this.getDependencyManager().isContextPresent()) {
            throw new MongockException("ApplicationContext from Spring must be injected to Builder");
        }
    }

    public DependencyManagerWithContext getDependencyManager() {
        return (DependencyManagerWithContext)this.dependencyManager;
    }
}

