/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc.handler;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.moderne.jsonrpc.JsonRpcError;
import io.moderne.jsonrpc.JsonRpcMessage;
import io.moderne.jsonrpc.JsonRpcRequest;
import io.moderne.jsonrpc.JsonRpcSuccess;
import io.moderne.jsonrpc.handler.MessageHandler;
import lombok.Generated;

public class MeteredMessageHandler
implements MessageHandler {
    private final MessageHandler delegate;
    private final MeterRegistry meterRegistry;

    @Override
    public JsonRpcMessage receive() {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        Timer.Builder timer = Timer.builder((String)"jsonrpc.receive").description("Time taken to receive a JSON-RPC message").tag("direction", "received");
        JsonRpcMessage msg = this.delegate.receive();
        this.finishTimer(msg, sample, timer);
        return msg;
    }

    @Override
    public void send(JsonRpcMessage msg) {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        Timer.Builder timer = Timer.builder((String)"jsonrpc.send").description("Time taken to send a JSON-RPC message").tag("direction", "sent");
        this.delegate.send(msg);
        this.finishTimer(msg, sample, timer);
    }

    private void finishTimer(JsonRpcMessage msg, Timer.Sample sample, Timer.Builder timer) {
        timer = timer.tag("handler", this.delegate.getClass().getSimpleName());
        if (msg instanceof JsonRpcSuccess) {
            sample.stop(timer.tag("type", "response").tags(new String[]{"error", "none"}).register(this.meterRegistry));
        } else if (msg instanceof JsonRpcRequest) {
            sample.stop(timer.tag("type", "request").tag("error", "none").register(this.meterRegistry));
        } else if (msg instanceof JsonRpcError) {
            sample.stop(timer.tag("type", "error").tag("error", Integer.toString(((JsonRpcError)msg).getError().getCode())).register(this.meterRegistry));
        }
    }

    @Generated
    public MeteredMessageHandler(MessageHandler delegate, MeterRegistry meterRegistry) {
        this.delegate = delegate;
        this.meterRegistry = meterRegistry;
    }
}

