/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc;

import io.moderne.jsonrpc.JsonRpcResponse;
import java.io.PrintWriter;
import java.io.StringWriter;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class JsonRpcError
extends JsonRpcResponse {
    private final String id;
    private final Detail error;

    public static JsonRpcError parseError(String id) {
        return new JsonRpcError(id, new Detail(-32700, "Parse error", null));
    }

    public static JsonRpcError invalidRequest(String id, String message) {
        return new JsonRpcError(id, new Detail(-32600, "Invalid Request: " + message, null));
    }

    public static JsonRpcError methodNotFound(String id, String method) {
        return new JsonRpcError(id, new Detail(-32601, "Method not found: " + method, null));
    }

    public static JsonRpcError invalidParams(String id) {
        return new JsonRpcError(id, new Detail(-32602, "Invalid params", null));
    }

    public static JsonRpcError internalError(String id, String message) {
        return new JsonRpcError(id, new Detail(-32603, "Internal error: " + message, null));
    }

    public static JsonRpcError internalError(String id, Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return new JsonRpcError(id, new Detail(-32603, "Internal error: " + t.getMessage(), sw.toString()));
    }

    @Generated
    public JsonRpcError(String id, Detail error) {
        this.id = id;
        this.error = error;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Detail getError() {
        return this.error;
    }

    @Generated
    public String toString() {
        return "JsonRpcError(id=" + this.getId() + ", error=" + this.getError() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonRpcError)) {
            return false;
        }
        JsonRpcError other = (JsonRpcError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Detail this$error = this.getError();
        Detail other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonRpcError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Detail $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public static final class Detail {
        private final int code;
        private final String message;
        private final @Nullable String data;

        @Generated
        public Detail(int code, String message, @Nullable String data) {
            this.code = code;
            this.message = message;
            this.data = data;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public @Nullable String getData() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Detail)) {
                return false;
            }
            Detail other = (Detail)o;
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JsonRpcError.Detail(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
        }
    }
}

