/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public interface McpServer {
    public static SyncSpec sync(ServerMcpTransport transport) {
        return new SyncSpec(transport);
    }

    public static AsyncSpec async(ServerMcpTransport transport) {
        return new AsyncSpec(transport);
    }

    public static class SyncSpec {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final ServerMcpTransport transport;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.SyncToolRegistration> tools = new ArrayList<McpServerFeatures.SyncToolRegistration>();
        private final Map<String, McpServerFeatures.SyncResourceRegistration> resources = new HashMap<String, McpServerFeatures.SyncResourceRegistration>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.SyncPromptRegistration> prompts = new HashMap<String, McpServerFeatures.SyncPromptRegistration>();
        private final List<Consumer<List<McpSchema.Root>>> rootsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Root>>>();

        private SyncSpec(ServerMcpTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public SyncSpec serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public SyncSpec serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public SyncSpec capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public SyncSpec tool(McpSchema.Tool tool, Function<Map<String, Object>, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.SyncToolRegistration(tool, handler));
            return this;
        }

        public SyncSpec tools(List<McpServerFeatures.SyncToolRegistration> toolRegistrations) {
            Assert.notNull(toolRegistrations, "Tool handlers list must not be null");
            this.tools.addAll(toolRegistrations);
            return this;
        }

        public SyncSpec tools(McpServerFeatures.SyncToolRegistration ... toolRegistrations) {
            for (McpServerFeatures.SyncToolRegistration tool : toolRegistrations) {
                this.tools.add(tool);
            }
            return this;
        }

        public SyncSpec resources(Map<String, McpServerFeatures.SyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers map must not be null");
            this.resources.putAll(resourceRegsitrations);
            return this;
        }

        public SyncSpec resources(List<McpServerFeatures.SyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceRegistration resource : resourceRegsitrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpec resources(McpServerFeatures.SyncResourceRegistration ... resourceRegistrations) {
            Assert.notNull(resourceRegistrations, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceRegistration resource : resourceRegistrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpec resourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            this.resourceTemplates.addAll(resourceTemplates);
            return this;
        }

        public SyncSpec resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            for (McpSchema.ResourceTemplate resourceTemplate : resourceTemplates) {
                this.resourceTemplates.add(resourceTemplate);
            }
            return this;
        }

        public SyncSpec prompts(Map<String, McpServerFeatures.SyncPromptRegistration> prompts) {
            this.prompts.putAll(prompts);
            return this;
        }

        public SyncSpec prompts(List<McpServerFeatures.SyncPromptRegistration> prompts) {
            for (McpServerFeatures.SyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpec prompts(McpServerFeatures.SyncPromptRegistration ... prompts) {
            for (McpServerFeatures.SyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpec rootsChangeConsumer(Consumer<List<McpSchema.Root>> consumer) {
            Assert.notNull(consumer, "Consumer must not be null");
            this.rootsChangeConsumers.add(consumer);
            return this;
        }

        public SyncSpec rootsChangeConsumers(List<Consumer<List<McpSchema.Root>>> consumers) {
            Assert.notNull(consumers, "Consumers list must not be null");
            this.rootsChangeConsumers.addAll(consumers);
            return this;
        }

        public SyncSpec rootsChangeConsumers(Consumer<List<McpSchema.Root>> ... consumers) {
            for (Consumer<List<McpSchema.Root>> consumer : consumers) {
                this.rootsChangeConsumers.add(consumer);
            }
            return this;
        }

        public McpSyncServer build() {
            McpServerFeatures.Sync syncFeatures = new McpServerFeatures.Sync(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeConsumers);
            return new McpSyncServer(new McpAsyncServer(this.transport, McpServerFeatures.Async.fromSync(syncFeatures)));
        }
    }

    public static class AsyncSpec {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final ServerMcpTransport transport;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.AsyncToolRegistration> tools = new ArrayList<McpServerFeatures.AsyncToolRegistration>();
        private final Map<String, McpServerFeatures.AsyncResourceRegistration> resources = new HashMap<String, McpServerFeatures.AsyncResourceRegistration>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.AsyncPromptRegistration> prompts = new HashMap<String, McpServerFeatures.AsyncPromptRegistration>();
        private final List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers = new ArrayList<Function<List<McpSchema.Root>, Mono<Void>>>();

        private AsyncSpec(ServerMcpTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public AsyncSpec serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public AsyncSpec serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public AsyncSpec capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public AsyncSpec tool(McpSchema.Tool tool, Function<Map<String, Object>, Mono<McpSchema.CallToolResult>> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.AsyncToolRegistration(tool, handler));
            return this;
        }

        public AsyncSpec tools(List<McpServerFeatures.AsyncToolRegistration> toolRegistrations) {
            Assert.notNull(toolRegistrations, "Tool handlers list must not be null");
            this.tools.addAll(toolRegistrations);
            return this;
        }

        public AsyncSpec tools(McpServerFeatures.AsyncToolRegistration ... toolRegistrations) {
            for (McpServerFeatures.AsyncToolRegistration tool : toolRegistrations) {
                this.tools.add(tool);
            }
            return this;
        }

        public AsyncSpec resources(Map<String, McpServerFeatures.AsyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers map must not be null");
            this.resources.putAll(resourceRegsitrations);
            return this;
        }

        public AsyncSpec resources(List<McpServerFeatures.AsyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceRegistration resource : resourceRegsitrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpec resources(McpServerFeatures.AsyncResourceRegistration ... resourceRegistrations) {
            Assert.notNull(resourceRegistrations, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceRegistration resource : resourceRegistrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpec resourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            this.resourceTemplates.addAll(resourceTemplates);
            return this;
        }

        public AsyncSpec resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            for (McpSchema.ResourceTemplate resourceTemplate : resourceTemplates) {
                this.resourceTemplates.add(resourceTemplate);
            }
            return this;
        }

        public AsyncSpec prompts(Map<String, McpServerFeatures.AsyncPromptRegistration> prompts) {
            this.prompts.putAll(prompts);
            return this;
        }

        public AsyncSpec prompts(List<McpServerFeatures.AsyncPromptRegistration> prompts) {
            for (McpServerFeatures.AsyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpec prompts(McpServerFeatures.AsyncPromptRegistration ... prompts) {
            for (McpServerFeatures.AsyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpec rootsChangeConsumer(Function<List<McpSchema.Root>, Mono<Void>> consumer) {
            Assert.notNull(consumer, "Consumer must not be null");
            this.rootsChangeConsumers.add(consumer);
            return this;
        }

        public AsyncSpec rootsChangeConsumers(List<Function<List<McpSchema.Root>, Mono<Void>>> consumers) {
            Assert.notNull(consumers, "Consumers list must not be null");
            this.rootsChangeConsumers.addAll(consumers);
            return this;
        }

        public AsyncSpec rootsChangeConsumers(Function<List<McpSchema.Root>, Mono<Void>> ... consumers) {
            for (Function<List<McpSchema.Root>, Mono<Void>> consumer : consumers) {
                this.rootsChangeConsumers.add(consumer);
            }
            return this;
        }

        public McpAsyncServer build() {
            return new McpAsyncServer(this.transport, new McpServerFeatures.Async(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeConsumers));
        }
    }
}

