/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransport;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Deprecated
public class MockMcpTransport
implements McpClientTransport,
McpServerTransport {
    private final Sinks.Many<McpSchema.JSONRPCMessage> inbound = Sinks.many().unicast().onBackpressureBuffer();
    private final List<McpSchema.JSONRPCMessage> sent = new ArrayList<McpSchema.JSONRPCMessage>();
    private final BiConsumer<MockMcpTransport, McpSchema.JSONRPCMessage> interceptor;
    private volatile boolean connected = false;

    public MockMcpTransport() {
        this((t, msg) -> {});
    }

    public MockMcpTransport(BiConsumer<MockMcpTransport, McpSchema.JSONRPCMessage> interceptor) {
        this.interceptor = interceptor;
    }

    public void simulateIncomingMessage(McpSchema.JSONRPCMessage message) {
        if (this.inbound.tryEmitNext((Object)message).isFailure()) {
            throw new RuntimeException("Failed to process incoming message " + String.valueOf(message));
        }
    }

    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        this.sent.add(message);
        this.interceptor.accept(this, message);
        return Mono.empty();
    }

    public McpSchema.JSONRPCRequest getLastSentMessageAsRequest() {
        return (McpSchema.JSONRPCRequest)this.getLastSentMessage();
    }

    public McpSchema.JSONRPCNotification getLastSentMessageAsNotification() {
        return (McpSchema.JSONRPCNotification)this.getLastSentMessage();
    }

    public McpSchema.JSONRPCMessage getLastSentMessage() {
        return !this.sent.isEmpty() ? this.sent.get(this.sent.size() - 1) : null;
    }

    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        if (this.connected) {
            return Mono.error((Throwable)new IllegalStateException("Already connected"));
        }
        this.connected = true;
        return this.inbound.asFlux().flatMap(message -> Mono.just((Object)message).transform(handler)).doFinally(signal -> {
            this.connected = false;
        }).then();
    }

    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> {
            this.connected = false;
            this.inbound.tryEmitComplete();
            return Mono.empty();
        });
    }

    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)new ObjectMapper().convertValue(data, typeRef);
    }
}

