/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class AbstractMcpClientServerIntegrationTests {
    protected ConcurrentHashMap<String, McpClient.SyncSpec> clientBuilders = new ConcurrentHashMap();
    String emptyJsonSchema = "{\n\t\"$schema\": \"http://json-schema.org/draft-07/schema#\",\n\t\"type\": \"object\",\n\t\"properties\": {}\n}\n";

    protected abstract void prepareClients(int var1, String var2);

    protected abstract McpServer.AsyncSpecification<?> prepareAsyncServerBuilder();

    protected abstract McpServer.SyncSpecification<?> prepareSyncServerBuilder();

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void simple(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpAsyncServer server = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").requestTimeout(Duration.ofSeconds(1000L)).build();
        try (McpSyncClient client = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).requestTimeout(Duration.ofSeconds(1000L)).build();){
            Assertions.assertThat((Object)client.initialize()).isNotNull();
        }
        server.closeGracefully();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateMessageWithoutSamplingCapabilities(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            exchange.createMessage((McpSchema.CreateMessageRequest)Mockito.mock(McpSchema.CreateMessageRequest.class)).block();
            return Mono.just((Object)((McpSchema.CallToolResult)Mockito.mock(McpSchema.CallToolResult.class)));
        }).build();
        McpAsyncServer server = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        try (McpSyncClient client = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).build();){
            Assertions.assertThat((Object)client.initialize()).isNotNull();
            try {
                client.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
            }
            catch (McpError e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Client must be configured with sampling capabilities");
            }
        }
        server.closeGracefully();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateMessageSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler = request -> {
            Assertions.assertThat((List)request.messages()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.SamplingMessage)request.messages().get(0)).content()).isInstanceOf(McpSchema.TextContent.class);
            return new McpSchema.CreateMessageResult(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Test message"), "MockModelName", McpSchema.CreateMessageResult.StopReason.STOP_SEQUENCE);
        };
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        AtomicReference samplingResult = new AtomicReference();
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            McpSchema.CreateMessageRequest createMessageRequest = McpSchema.CreateMessageRequest.builder().messages(List.of(new McpSchema.SamplingMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Test message")))).modelPreferences(McpSchema.ModelPreferences.builder().hints(List.of()).costPriority(Double.valueOf(1.0)).speedPriority(Double.valueOf(1.0)).intelligencePriority(Double.valueOf(1.0)).build()).build();
            return exchange.createMessage(createMessageRequest).doOnNext(samplingResult::set).thenReturn((Object)callResponse);
        }).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).capabilities(McpSchema.ClientCapabilities.builder().sampling().build()).sampling(samplingHandler).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Object)response).isEqualTo((Object)callResponse);
            Assertions.assertWith((Object)((McpSchema.CreateMessageResult)samplingResult.get()), (Consumer[])new Consumer[]{result -> {
                Assertions.assertThat((Object)result).isNotNull();
                Assertions.assertThat((Comparable)result.role()).isEqualTo((Object)McpSchema.Role.USER);
                Assertions.assertThat((Object)result.content()).isInstanceOf(McpSchema.TextContent.class);
                Assertions.assertThat((String)((McpSchema.TextContent)result.content()).text()).isEqualTo("Test message");
                Assertions.assertThat((String)result.model()).isEqualTo("MockModelName");
                Assertions.assertThat((Comparable)result.stopReason()).isEqualTo((Object)McpSchema.CreateMessageResult.StopReason.STOP_SEQUENCE);
            }});
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateMessageWithRequestTimeoutSuccess(String clientType) throws InterruptedException {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler = request -> {
            Assertions.assertThat((List)request.messages()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.SamplingMessage)request.messages().get(0)).content()).isInstanceOf(McpSchema.TextContent.class);
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return new McpSchema.CreateMessageResult(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Test message"), "MockModelName", McpSchema.CreateMessageResult.StopReason.STOP_SEQUENCE);
        };
        McpSyncClient mcpClient = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).capabilities(McpSchema.ClientCapabilities.builder().sampling().build()).sampling(samplingHandler).build();
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        AtomicReference samplingResult = new AtomicReference();
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            McpSchema.CreateMessageRequest createMessageRequest = McpSchema.CreateMessageRequest.builder().messages(List.of(new McpSchema.SamplingMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Test message")))).modelPreferences(McpSchema.ModelPreferences.builder().hints(List.of()).costPriority(Double.valueOf(1.0)).speedPriority(Double.valueOf(1.0)).intelligencePriority(Double.valueOf(1.0)).build()).build();
            return exchange.createMessage(createMessageRequest).doOnNext(samplingResult::set).thenReturn((Object)callResponse);
        }).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").requestTimeout(Duration.ofSeconds(4L)).tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        McpSchema.InitializeResult initResult = mcpClient.initialize();
        Assertions.assertThat((Object)initResult).isNotNull();
        McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isEqualTo((Object)callResponse);
        Assertions.assertWith((Object)((McpSchema.CreateMessageResult)samplingResult.get()), (Consumer[])new Consumer[]{result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Comparable)result.role()).isEqualTo((Object)McpSchema.Role.USER);
            Assertions.assertThat((Object)result.content()).isInstanceOf(McpSchema.TextContent.class);
            Assertions.assertThat((String)((McpSchema.TextContent)result.content()).text()).isEqualTo("Test message");
            Assertions.assertThat((String)result.model()).isEqualTo("MockModelName");
            Assertions.assertThat((Comparable)result.stopReason()).isEqualTo((Object)McpSchema.CreateMessageResult.StopReason.STOP_SEQUENCE);
        }});
        mcpClient.close();
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateMessageWithRequestTimeoutFail(String clientType) throws InterruptedException {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler = request -> {
            Assertions.assertThat((List)request.messages()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.SamplingMessage)request.messages().get(0)).content()).isInstanceOf(McpSchema.TextContent.class);
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return new McpSchema.CreateMessageResult(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Test message"), "MockModelName", McpSchema.CreateMessageResult.StopReason.STOP_SEQUENCE);
        };
        McpSyncClient mcpClient = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).capabilities(McpSchema.ClientCapabilities.builder().sampling().build()).sampling(samplingHandler).build();
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            McpSchema.CreateMessageRequest createMessageRequest = McpSchema.CreateMessageRequest.builder().messages(List.of(new McpSchema.SamplingMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Test message")))).modelPreferences(McpSchema.ModelPreferences.builder().hints(List.of()).costPriority(Double.valueOf(1.0)).speedPriority(Double.valueOf(1.0)).intelligencePriority(Double.valueOf(1.0)).build()).build();
            return exchange.createMessage(createMessageRequest).thenReturn((Object)callResponse);
        }).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").requestTimeout(Duration.ofSeconds(1L)).tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        McpSchema.InitializeResult initResult = mcpClient.initialize();
        Assertions.assertThat((Object)initResult).isNotNull();
        Assertions.assertThatExceptionOfType(McpError.class).isThrownBy(() -> mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()))).withMessageContaining("1000ms");
        mcpClient.close();
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateElicitationWithoutElicitationCapabilities(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> exchange.createElicitation((McpSchema.ElicitRequest)Mockito.mock(McpSchema.ElicitRequest.class)).then(Mono.just((Object)((McpSchema.CallToolResult)Mockito.mock(McpSchema.CallToolResult.class))))).build();
        McpAsyncServer server = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        try (McpSyncClient client = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).build();){
            Assertions.assertThat((Object)client.initialize()).isNotNull();
            try {
                client.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
            }
            catch (McpError e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Client must be configured with elicitation capabilities");
            }
        }
        server.closeGracefully().block();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateElicitationSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler = request -> {
            Assertions.assertThat((String)request.message()).isNotEmpty();
            Assertions.assertThat((Map)request.requestedSchema()).isNotNull();
            return new McpSchema.ElicitResult(McpSchema.ElicitResult.Action.ACCEPT, Map.of("message", request.message()));
        };
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            McpSchema.ElicitRequest elicitationRequest = McpSchema.ElicitRequest.builder().message("Test message").requestedSchema(Map.of("type", "object", "properties", Map.of("message", Map.of("type", "string")))).build();
            StepVerifier.create((Publisher)exchange.createElicitation(elicitationRequest)).consumeNextWith(result -> {
                Assertions.assertThat((Object)result).isNotNull();
                Assertions.assertThat((Comparable)result.action()).isEqualTo((Object)McpSchema.ElicitResult.Action.ACCEPT);
                Assertions.assertThat(result.content().get("message")).isEqualTo((Object)"Test message");
            }).verifyComplete();
            return Mono.just((Object)callResponse);
        }).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).capabilities(McpSchema.ClientCapabilities.builder().elicitation().build()).elicitation(elicitationHandler).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Object)response).isEqualTo((Object)callResponse);
        }
        mcpServer.closeGracefully().block();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateElicitationWithRequestTimeoutSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler = request -> {
            Assertions.assertThat((String)request.message()).isNotEmpty();
            Assertions.assertThat((Map)request.requestedSchema()).isNotNull();
            return new McpSchema.ElicitResult(McpSchema.ElicitResult.Action.ACCEPT, Map.of("message", request.message()));
        };
        McpSyncClient mcpClient = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).capabilities(McpSchema.ClientCapabilities.builder().elicitation().build()).elicitation(elicitationHandler).build();
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        AtomicReference resultRef = new AtomicReference();
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            McpSchema.ElicitRequest elicitationRequest = McpSchema.ElicitRequest.builder().message("Test message").requestedSchema(Map.of("type", "object", "properties", Map.of("message", Map.of("type", "string")))).build();
            return exchange.createElicitation(elicitationRequest).doOnNext(resultRef::set).then(Mono.just((Object)callResponse));
        }).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").requestTimeout(Duration.ofSeconds(3L)).tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        McpSchema.InitializeResult initResult = mcpClient.initialize();
        Assertions.assertThat((Object)initResult).isNotNull();
        McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isEqualTo((Object)callResponse);
        Assertions.assertWith((Object)((McpSchema.ElicitResult)resultRef.get()), (Consumer[])new Consumer[]{result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Comparable)result.action()).isEqualTo((Object)McpSchema.ElicitResult.Action.ACCEPT);
            Assertions.assertThat(result.content().get("message")).isEqualTo((Object)"Test message");
        }});
        mcpClient.closeGracefully();
        mcpServer.closeGracefully().block();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCreateElicitationWithRequestTimeoutFail(String clientType) {
        CountDownLatch latch = new CountDownLatch(1);
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler = request -> {
            Assertions.assertThat((String)request.message()).isNotEmpty();
            Assertions.assertThat((Map)request.requestedSchema()).isNotNull();
            try {
                if (!latch.await(2L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Timeout waiting for elicitation processing");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return new McpSchema.ElicitResult(McpSchema.ElicitResult.Action.ACCEPT, Map.of("message", request.message()));
        };
        McpSyncClient mcpClient = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).capabilities(McpSchema.ClientCapabilities.builder().elicitation().build()).elicitation(elicitationHandler).build();
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        AtomicReference resultRef = new AtomicReference();
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            McpSchema.ElicitRequest elicitationRequest = McpSchema.ElicitRequest.builder().message("Test message").requestedSchema(Map.of("type", "object", "properties", Map.of("message", Map.of("type", "string")))).build();
            return exchange.createElicitation(elicitationRequest).doOnNext(resultRef::set).then(Mono.just((Object)callResponse));
        }).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").requestTimeout(Duration.ofSeconds(1L)).tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        McpSchema.InitializeResult initResult = mcpClient.initialize();
        Assertions.assertThat((Object)initResult).isNotNull();
        Assertions.assertThatExceptionOfType(McpError.class).isThrownBy(() -> mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()))).withMessageContaining("within 1000ms");
        McpSchema.ElicitResult elicitResult = (McpSchema.ElicitResult)resultRef.get();
        Assertions.assertThat((Object)elicitResult).isNull();
        mcpClient.closeGracefully();
        mcpServer.closeGracefully().block();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testRootsSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        List<McpSchema.Root> roots = List.of(new McpSchema.Root("uri1://", "root1"), new McpSchema.Root("uri2://", "root2"));
        AtomicReference rootsRef = new AtomicReference();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().rootsChangeHandler((exchange, rootsUpdate) -> rootsRef.set(rootsUpdate)).build();
        try (McpSyncClient mcpClient = clientBuilder.capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build()).roots(roots).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThat((List)((List)rootsRef.get())).isNull();
            mcpClient.rootsListChangedNotification();
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)rootsRef.get())).containsAll((Iterable)roots));
            mcpClient.removeRoot(roots.get(0).uri());
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)rootsRef.get())).containsAll(List.of((McpSchema.Root)roots.get(1))));
            McpSchema.Root root3 = new McpSchema.Root("uri3://", "root3");
            mcpClient.addRoot(root3);
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)rootsRef.get())).containsAll(List.of((McpSchema.Root)roots.get(1), root3)));
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testRootsWithoutCapability(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpServerFeatures.SyncToolSpecification tool = McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            exchange.listRoots();
            return (McpSchema.CallToolResult)Mockito.mock(McpSchema.CallToolResult.class);
        }).build();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().rootsChangeHandler((exchange, rootsUpdate) -> {}).tools(new McpServerFeatures.SyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.capabilities(McpSchema.ClientCapabilities.builder().build()).build();){
            Assertions.assertThat((Object)mcpClient.initialize()).isNotNull();
            try {
                mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
            }
            catch (McpError e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Roots not supported");
            }
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testRootsNotificationWithEmptyRootsList(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        AtomicReference rootsRef = new AtomicReference();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().rootsChangeHandler((exchange, rootsUpdate) -> rootsRef.set(rootsUpdate)).build();
        try (McpSyncClient mcpClient = clientBuilder.capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build()).roots(List.of()).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            mcpClient.rootsListChangedNotification();
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)rootsRef.get())).isEmpty());
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testRootsWithMultipleHandlers(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        List<McpSchema.Root> roots = List.of(new McpSchema.Root("uri1://", "root1"));
        AtomicReference rootsRef1 = new AtomicReference();
        AtomicReference rootsRef2 = new AtomicReference();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().rootsChangeHandler((exchange, rootsUpdate) -> rootsRef1.set(rootsUpdate)).rootsChangeHandler((exchange, rootsUpdate) -> rootsRef2.set(rootsUpdate)).build();
        try (McpSyncClient mcpClient = clientBuilder.capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build()).roots(roots).build();){
            Assertions.assertThat((Object)mcpClient.initialize()).isNotNull();
            mcpClient.rootsListChangedNotification();
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> {
                Assertions.assertThat((List)((List)rootsRef1.get())).containsAll((Iterable)roots);
                Assertions.assertThat((List)((List)rootsRef2.get())).containsAll((Iterable)roots);
            });
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testRootsServerCloseWithActiveSubscription(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        List<McpSchema.Root> roots = List.of(new McpSchema.Root("uri1://", "root1"));
        AtomicReference rootsRef = new AtomicReference();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().rootsChangeHandler((exchange, rootsUpdate) -> rootsRef.set(rootsUpdate)).build();
        try (McpSyncClient mcpClient = clientBuilder.capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build()).roots(roots).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            mcpClient.rootsListChangedNotification();
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)rootsRef.get())).containsAll((Iterable)roots));
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testToolCallSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        McpServerFeatures.SyncToolSpecification tool1 = McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            try {
                HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/modelcontextprotocol/java-sdk/refs/heads/main/README.md")).GET().build(), HttpResponse.BodyHandlers.ofString());
                String responseBody = response.body();
                Assertions.assertThat((String)responseBody).isNotBlank();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return callResponse;
        }).build();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.SyncToolSpecification[]{tool1}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThat((List)mcpClient.listTools().tools()).contains((Object[])new McpSchema.Tool[]{tool1.tool()});
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
            ((ObjectAssert)Assertions.assertThat((Object)response).isNotNull()).isEqualTo((Object)callResponse);
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testThrowingToolCallIsCaughtBeforeTimeout(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.SyncToolSpecification[]{McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            Mono.never().block(Duration.ofSeconds(1L));
            return null;
        }).build()}).build();
        try (McpSyncClient mcpClient = clientBuilder.requestTimeout(Duration.ofMillis(6666L)).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThatExceptionOfType(McpError.class).isThrownBy(() -> mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()))).withMessageContaining("Timeout on blocking read");
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testToolListChangeHandlingSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        McpServerFeatures.SyncToolSpecification tool1 = McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            try {
                HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/modelcontextprotocol/java-sdk/refs/heads/main/README.md")).GET().build(), HttpResponse.BodyHandlers.ofString());
                String responseBody = response.body();
                Assertions.assertThat((String)responseBody).isNotBlank();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return callResponse;
        }).build();
        AtomicReference toolsRef = new AtomicReference();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.SyncToolSpecification[]{tool1}).build();
        try (McpSyncClient mcpClient = clientBuilder.toolsChangeConsumer(toolsUpdate -> {
            try {
                HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/modelcontextprotocol/java-sdk/refs/heads/main/README.md")).GET().build(), HttpResponse.BodyHandlers.ofString());
                String responseBody = response.body();
                Assertions.assertThat((String)responseBody).isNotBlank();
                toolsRef.set(toolsUpdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThat((List)((List)toolsRef.get())).isNull();
            Assertions.assertThat((List)mcpClient.listTools().tools()).contains((Object[])new McpSchema.Tool[]{tool1.tool()});
            mcpServer.notifyToolsListChanged();
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)toolsRef.get())).containsAll(List.of(tool1.tool())));
            mcpServer.removeTool("tool1");
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)toolsRef.get())).isEmpty());
            McpServerFeatures.SyncToolSpecification tool2 = McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool2").description("tool2 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> callResponse).build();
            mcpServer.addTool(tool2);
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)((List)toolsRef.get())).containsAll(List.of(tool2.tool())));
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testInitialize(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testLoggingNotification(String clientType) throws InterruptedException {
        int expectedNotificationsCount = 3;
        CountDownLatch latch = new CountDownLatch(expectedNotificationsCount);
        CopyOnWriteArrayList receivedNotifications = new CopyOnWriteArrayList();
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("logging-test").description("Test logging notifications").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.DEBUG).logger("test-logger").data("Debug message").build()).then(exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.NOTICE).logger("test-logger").data("Notice message").build())).then(exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.ERROR).logger("test-logger").data("Error message").build())).then(exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.INFO).logger("test-logger").data("Another info message").build())).then(exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.ERROR).logger("test-logger").data("Another error message").build())).thenReturn((Object)new McpSchema.CallToolResult("Logging test completed", Boolean.valueOf(false)))).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().logging().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.loggingConsumer(notification -> {
            receivedNotifications.add(notification);
            latch.countDown();
        }).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            mcpClient.setLoggingLevel(McpSchema.LoggingLevel.NOTICE);
            McpSchema.CallToolResult result = mcpClient.callTool(new McpSchema.CallToolRequest("logging-test", Map.of()));
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Object)((McpSchema.Content)result.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            Assertions.assertThat((String)((McpSchema.TextContent)result.content().get(0)).text()).isEqualTo("Logging test completed");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(5L, TimeUnit.SECONDS)).as("Should receive notifications in reasonable time", new Object[0])).isTrue();
            Assertions.assertThat(receivedNotifications).hasSize(expectedNotificationsCount);
            Map<String, McpSchema.LoggingMessageNotification> notificationMap = receivedNotifications.stream().collect(Collectors.toMap(n -> n.data(), n -> n));
            Assertions.assertThat((Comparable)notificationMap.get("Notice message").level()).isEqualTo((Object)McpSchema.LoggingLevel.NOTICE);
            Assertions.assertThat((String)notificationMap.get("Notice message").logger()).isEqualTo("test-logger");
            Assertions.assertThat((String)notificationMap.get("Notice message").data()).isEqualTo("Notice message");
            Assertions.assertThat((Comparable)notificationMap.get("Error message").level()).isEqualTo((Object)McpSchema.LoggingLevel.ERROR);
            Assertions.assertThat((String)notificationMap.get("Error message").logger()).isEqualTo("test-logger");
            Assertions.assertThat((String)notificationMap.get("Error message").data()).isEqualTo("Error message");
            Assertions.assertThat((Comparable)notificationMap.get("Another error message").level()).isEqualTo((Object)McpSchema.LoggingLevel.ERROR);
            Assertions.assertThat((String)notificationMap.get("Another error message").logger()).isEqualTo("test-logger");
            Assertions.assertThat((String)notificationMap.get("Another error message").data()).isEqualTo("Another error message");
        }
        mcpServer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testProgressNotification(String clientType) throws InterruptedException {
        int expectedNotificationsCount = 4;
        CountDownLatch latch = new CountDownLatch(expectedNotificationsCount);
        CopyOnWriteArrayList receivedNotifications = new CopyOnWriteArrayList();
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("progress-test").description("Test progress notifications").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            String progressToken = (String)request.meta().get("progressToken");
            return exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, 0.0, Double.valueOf(1.0), "Processing started")).then(exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, 0.5, Double.valueOf(1.0), "Processing data"))).then(exchange.progressNotification(new McpSchema.ProgressNotification("another-progress-token", 0.0, Double.valueOf(1.0), "Another processing started"))).then(exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, 1.0, Double.valueOf(1.0), "Processing completed"))).thenReturn((Object)new McpSchema.CallToolResult("Progress test completed", Boolean.valueOf(false)));
        }).build();
        try (McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
             McpSyncClient mcpClient = clientBuilder.progressConsumer(notification -> {
            receivedNotifications.add(notification);
            latch.countDown();
        }).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolRequest callToolRequest = McpSchema.CallToolRequest.builder().name("progress-test").meta(Map.of("progressToken", "test-progress-token")).build();
            McpSchema.CallToolResult result = mcpClient.callTool(callToolRequest);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Object)((McpSchema.Content)result.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            Assertions.assertThat((String)((McpSchema.TextContent)result.content().get(0)).text()).isEqualTo("Progress test completed");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(5L, TimeUnit.SECONDS)).as("Should receive notifications in reasonable time", new Object[0])).isTrue();
            Assertions.assertThat(receivedNotifications).hasSize(expectedNotificationsCount);
            Map<String, McpSchema.ProgressNotification> notificationMap = receivedNotifications.stream().collect(Collectors.toMap(n -> n.message(), n -> n));
            Assertions.assertThat((String)notificationMap.get("Processing started").progressToken()).isEqualTo("test-progress-token");
            Assertions.assertThat((Double)notificationMap.get("Processing started").progress()).isEqualTo(0.0);
            Assertions.assertThat((Double)notificationMap.get("Processing started").total()).isEqualTo(1.0);
            Assertions.assertThat((String)notificationMap.get("Processing started").message()).isEqualTo("Processing started");
            Assertions.assertThat((String)notificationMap.get("Processing data").progressToken()).isEqualTo("test-progress-token");
            Assertions.assertThat((Double)notificationMap.get("Processing data").progress()).isEqualTo(0.5);
            Assertions.assertThat((Double)notificationMap.get("Processing data").total()).isEqualTo(1.0);
            Assertions.assertThat((String)notificationMap.get("Processing data").message()).isEqualTo("Processing data");
            Assertions.assertThat((String)notificationMap.get("Another processing started").progressToken()).isEqualTo("another-progress-token");
            Assertions.assertThat((Double)notificationMap.get("Another processing started").progress()).isEqualTo(0.0);
            Assertions.assertThat((Double)notificationMap.get("Another processing started").total()).isEqualTo(1.0);
            Assertions.assertThat((String)notificationMap.get("Another processing started").message()).isEqualTo("Another processing started");
            Assertions.assertThat((String)notificationMap.get("Processing completed").progressToken()).isEqualTo("test-progress-token");
            Assertions.assertThat((Double)notificationMap.get("Processing completed").progress()).isEqualTo(1.0);
            Assertions.assertThat((Double)notificationMap.get("Processing completed").total()).isEqualTo(1.0);
            Assertions.assertThat((String)notificationMap.get("Processing completed").message()).isEqualTo("Processing completed");
        }
    }

    @ParameterizedTest(name="{0} : Completion call")
    @ValueSource(strings={"httpclient", "webflux"})
    void testCompletionShouldReturnExpectedSuggestions(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        List<String> expectedValues = List.of("python", "pytorch", "pyside");
        McpSchema.CompleteResult completionResponse = new McpSchema.CompleteResult(new McpSchema.CompleteResult.CompleteCompletion(expectedValues, Integer.valueOf(10), Boolean.valueOf(true)));
        AtomicReference samplingRequest = new AtomicReference();
        BiFunction<McpSyncServerExchange, McpSchema.CompleteRequest, McpSchema.CompleteResult> completionHandler = (mcpSyncServerExchange, request) -> {
            samplingRequest.set(request);
            return completionResponse;
        };
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().capabilities(McpSchema.ServerCapabilities.builder().completions().build()).prompts(new McpServerFeatures.SyncPromptSpecification[]{new McpServerFeatures.SyncPromptSpecification(new McpSchema.Prompt("code_review", "Code review", "this is code review prompt", List.of(new McpSchema.PromptArgument("language", "Language", "string", Boolean.valueOf(false)))), (mcpSyncServerExchange, getPromptRequest) -> null)}).completions(new McpServerFeatures.SyncCompletionSpecification[]{new McpServerFeatures.SyncCompletionSpecification((McpSchema.CompleteReference)new McpSchema.PromptReference("ref/prompt", "code_review", "Code review"), completionHandler)}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CompleteRequest request2 = new McpSchema.CompleteRequest((McpSchema.CompleteReference)new McpSchema.PromptReference("ref/prompt", "code_review", "Code review"), new McpSchema.CompleteRequest.CompleteArgument("language", "py"));
            McpSchema.CompleteResult result = mcpClient.completeCompletion(request2);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((String)((McpSchema.CompleteRequest)samplingRequest.get()).argument().name()).isEqualTo("language");
            Assertions.assertThat((String)((McpSchema.CompleteRequest)samplingRequest.get()).argument().value()).isEqualTo("py");
            Assertions.assertThat((String)((McpSchema.CompleteRequest)samplingRequest.get()).ref().type()).isEqualTo("ref/prompt");
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testPingSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        AtomicReference<String> executionOrder = new AtomicReference<String>("");
        McpServerFeatures.AsyncToolSpecification tool = McpServerFeatures.AsyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("ping-async-test").description("Test ping async behavior").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> {
            executionOrder.set((String)executionOrder.get() + "1");
            return exchange.ping().doOnNext(result -> {
                Assertions.assertThat((Object)result).isNotNull();
                Assertions.assertThat((Object)result).isInstanceOf(Map.class);
                executionOrder.set((String)executionOrder.get() + "2");
                Assertions.assertThat((Object)result).isNotNull();
            }).then(Mono.fromCallable(() -> {
                executionOrder.set((String)executionOrder.get() + "3");
                return new McpSchema.CallToolResult("Async ping test completed", Boolean.valueOf(false));
            }));
        }).build();
        McpAsyncServer mcpServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.AsyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolResult result = mcpClient.callTool(new McpSchema.CallToolRequest("ping-async-test", Map.of()));
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Object)((McpSchema.Content)result.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            Assertions.assertThat((String)((McpSchema.TextContent)result.content().get(0)).text()).isEqualTo("Async ping test completed");
            Assertions.assertThat((String)executionOrder.get()).isEqualTo("123");
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputValidationSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("result", Map.of("type", "number"), "operation", Map.of("type", "string"), "timestamp", Map.of("type", "string")), "required", List.of("result", "operation"));
        McpSchema.Tool calculatorTool = McpSchema.Tool.builder().name("calculator").description("Performs mathematical calculations").outputSchema(outputSchema).build();
        McpServerFeatures.SyncToolSpecification tool = McpServerFeatures.SyncToolSpecification.builder().tool(calculatorTool).callHandler((exchange, request) -> {
            String expression = request.arguments().getOrDefault("expression", "2 + 3");
            double result = this.evaluateExpression(expression);
            return McpSchema.CallToolResult.builder().structuredContent(Map.of("result", result, "operation", expression, "timestamp", "2024-01-01T10:00:00Z")).build();
        }).build();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.SyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.ListToolsResult toolsList = mcpClient.listTools();
            Assertions.assertThat((List)toolsList.tools()).hasSize(1);
            Assertions.assertThat((String)((McpSchema.Tool)toolsList.tools().get(0)).name()).isEqualTo("calculator");
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("calculator", Map.of("expression", "2 + 3")));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isFalse();
            if (response.structuredContent() != null) {
                ((MapAssert)((MapAssert)Assertions.assertThat((Map)response.structuredContent()).containsEntry((Object)"result", (Object)5.0)).containsEntry((Object)"operation", (Object)"2 + 3")).containsEntry((Object)"timestamp", (Object)"2024-01-01T10:00:00Z");
            } else {
                Assertions.assertThat((List)response.content()).isNotEmpty();
            }
            Assertions.assertThat((Map)response.structuredContent()).isNotNull();
            JsonAssertions.assertThatJson((Object)response.structuredContent()).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_EXTRA_ARRAY_ITEMS, new Option[0]).isObject().isEqualTo(JsonAssertions.json((Object)"{\"result\":5.0,\"operation\":\"2 + 3\",\"timestamp\":\"2024-01-01T10:00:00Z\"}"));
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputValidationFailure(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("result", Map.of("type", "number"), "operation", Map.of("type", "string")), "required", List.of("result", "operation"));
        McpSchema.Tool calculatorTool = McpSchema.Tool.builder().name("calculator").description("Performs mathematical calculations").outputSchema(outputSchema).build();
        McpServerFeatures.SyncToolSpecification tool = McpServerFeatures.SyncToolSpecification.builder().tool(calculatorTool).callHandler((exchange, request) -> McpSchema.CallToolResult.builder().addTextContent("Invalid calculation").structuredContent(Map.of("result", "not-a-number", "extra", "field")).build()).build();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.SyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("calculator", Map.of("expression", "2 + 3")));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isTrue();
            Assertions.assertThat((List)response.content()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.Content)response.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            String errorMessage = ((McpSchema.TextContent)response.content().get(0)).text();
            Assertions.assertThat((String)errorMessage).contains(new CharSequence[]{"Validation failed"});
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputMissingStructuredContent(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("result", Map.of("type", "number")), "required", List.of("result"));
        McpSchema.Tool calculatorTool = McpSchema.Tool.builder().name("calculator").description("Performs mathematical calculations").outputSchema(outputSchema).build();
        McpServerFeatures.SyncToolSpecification tool = McpServerFeatures.SyncToolSpecification.builder().tool(calculatorTool).callHandler((exchange, request) -> McpSchema.CallToolResult.builder().addTextContent("Calculation completed").build()).build();
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.SyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("calculator", Map.of("expression", "2 + 3")));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isTrue();
            Assertions.assertThat((List)response.content()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.Content)response.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            String errorMessage = ((McpSchema.TextContent)response.content().get(0)).text();
            Assertions.assertThat((String)errorMessage).isEqualTo("Response missing structured content which is expected when calling tool with non-empty outputSchema");
        }
        mcpServer.close();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputRuntimeToolAddition(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThat((List)mcpClient.listTools().tools()).isEmpty();
            Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("message", Map.of("type", "string"), "count", Map.of("type", "integer")), "required", List.of("message", "count"));
            McpSchema.Tool dynamicTool = McpSchema.Tool.builder().name("dynamic-tool").description("Dynamically added tool").outputSchema(outputSchema).build();
            McpServerFeatures.SyncToolSpecification toolSpec = McpServerFeatures.SyncToolSpecification.builder().tool(dynamicTool).callHandler((exchange, request) -> {
                int count = request.arguments().getOrDefault("count", 1);
                return McpSchema.CallToolResult.builder().addTextContent("Dynamic tool executed " + count + " times").structuredContent(Map.of("message", "Dynamic execution", "count", count)).build();
            }).build();
            mcpServer.addTool(toolSpec);
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)mcpClient.listTools().tools()).hasSize(1));
            McpSchema.ListToolsResult toolsList = mcpClient.listTools();
            Assertions.assertThat((List)toolsList.tools()).hasSize(1);
            Assertions.assertThat((String)((McpSchema.Tool)toolsList.tools().get(0)).name()).isEqualTo("dynamic-tool");
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("dynamic-tool", Map.of("count", 3)));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isFalse();
            Assertions.assertThat((List)response.content()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.Content)response.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            Assertions.assertThat((String)((McpSchema.TextContent)response.content().get(0)).text()).isEqualTo("Dynamic tool executed 3 times");
            Assertions.assertThat((Map)response.structuredContent()).isNotNull();
            JsonAssertions.assertThatJson((Object)response.structuredContent()).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_EXTRA_ARRAY_ITEMS, new Option[0]).isObject().isEqualTo(JsonAssertions.json((Object)"{\"count\":3,\"message\":\"Dynamic execution\"}"));
        }
        mcpServer.close();
    }

    private double evaluateExpression(String expression) {
        return switch (expression) {
            case "2 + 3" -> 5.0;
            case "10 * 2" -> 20.0;
            case "7 + 8" -> 15.0;
            case "5 + 3" -> 8.0;
            default -> 0.0;
        };
    }
}

