/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.DefaultMcpTransportContext;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import io.modelcontextprotocol.spec.McpServerTransport;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.KeepAliveScheduler;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class WebFluxSseServerTransportProvider
implements McpServerTransportProvider {
    private static final Logger logger = LoggerFactory.getLogger(WebFluxSseServerTransportProvider.class);
    public static final String MESSAGE_EVENT_TYPE = "message";
    public static final String ENDPOINT_EVENT_TYPE = "endpoint";
    private static final String MCP_PROTOCOL_VERSION = "2025-06-18";
    public static final String DEFAULT_SSE_ENDPOINT = "/sse";
    public static final String DEFAULT_BASE_URL = "";
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final String messageEndpoint;
    private final String sseEndpoint;
    private final RouterFunction<?> routerFunction;
    private McpServerSession.Factory sessionFactory;
    private final ConcurrentHashMap<String, McpServerSession> sessions = new ConcurrentHashMap();
    private McpTransportContextExtractor<ServerRequest> contextExtractor;
    private volatile boolean isClosing = false;
    private KeepAliveScheduler keepAliveScheduler;

    @Deprecated
    public WebFluxSseServerTransportProvider(ObjectMapper objectMapper, String messageEndpoint) {
        this(objectMapper, messageEndpoint, DEFAULT_SSE_ENDPOINT);
    }

    @Deprecated
    public WebFluxSseServerTransportProvider(ObjectMapper objectMapper, String messageEndpoint, String sseEndpoint) {
        this(objectMapper, DEFAULT_BASE_URL, messageEndpoint, sseEndpoint);
    }

    @Deprecated
    public WebFluxSseServerTransportProvider(ObjectMapper objectMapper, String baseUrl, String messageEndpoint, String sseEndpoint) {
        this(objectMapper, baseUrl, messageEndpoint, sseEndpoint, null);
    }

    @Deprecated
    public WebFluxSseServerTransportProvider(ObjectMapper objectMapper, String baseUrl, String messageEndpoint, String sseEndpoint, Duration keepAliveInterval) {
        this(objectMapper, baseUrl, messageEndpoint, sseEndpoint, keepAliveInterval, (McpTransportContextExtractor<ServerRequest>)((McpTransportContextExtractor)(serverRequest, context) -> context));
    }

    private WebFluxSseServerTransportProvider(ObjectMapper objectMapper, String baseUrl, String messageEndpoint, String sseEndpoint, Duration keepAliveInterval, McpTransportContextExtractor<ServerRequest> contextExtractor) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)baseUrl, (String)"Message base path must not be null");
        Assert.notNull((Object)messageEndpoint, (String)"Message endpoint must not be null");
        Assert.notNull((Object)sseEndpoint, (String)"SSE endpoint must not be null");
        Assert.notNull(contextExtractor, (String)"Context extractor must not be null");
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.messageEndpoint = messageEndpoint;
        this.sseEndpoint = sseEndpoint;
        this.contextExtractor = contextExtractor;
        this.routerFunction = RouterFunctions.route().GET(this.sseEndpoint, this::handleSseConnection).POST(this.messageEndpoint, this::handleMessage).build();
        if (keepAliveInterval != null) {
            this.keepAliveScheduler = KeepAliveScheduler.builder(() -> this.isClosing ? Flux.empty() : Flux.fromIterable(this.sessions.values())).initialDelay(keepAliveInterval).interval(keepAliveInterval).build();
            this.keepAliveScheduler.start();
        }
    }

    public List<String> protocolVersions() {
        return List.of("2024-11-05");
    }

    public void setSessionFactory(McpServerSession.Factory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Mono<Void> notifyClients(String method, Object params) {
        if (this.sessions.isEmpty()) {
            logger.debug("No active sessions to broadcast message to");
            return Mono.empty();
        }
        logger.debug("Attempting to broadcast message to {} active sessions", (Object)this.sessions.size());
        return Flux.fromIterable(this.sessions.values()).flatMap(session -> session.sendNotification(method, params).doOnError(e -> logger.error("Failed to send message to session {}: {}", (Object)session.getId(), (Object)e.getMessage())).onErrorComplete()).then();
    }

    public Mono<Void> closeGracefully() {
        return Flux.fromIterable(this.sessions.values()).doFirst(() -> logger.debug("Initiating graceful shutdown with {} active sessions", (Object)this.sessions.size())).flatMap(McpServerSession::closeGracefully).then().doOnSuccess(v -> {
            logger.debug("Graceful shutdown completed");
            this.sessions.clear();
            if (this.keepAliveScheduler != null) {
                this.keepAliveScheduler.shutdown();
            }
        });
    }

    public RouterFunction<?> getRouterFunction() {
        return this.routerFunction;
    }

    private Mono<ServerResponse> handleSseConnection(ServerRequest request) {
        if (this.isClosing) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).bodyValue((Object)"Server is shutting down");
        }
        McpTransportContext transportContext = this.contextExtractor.extract((Object)request, (McpTransportContext)new DefaultMcpTransportContext());
        return ServerResponse.ok().contentType(MediaType.TEXT_EVENT_STREAM).body((Object)Flux.create(sink -> {
            WebFluxMcpSessionTransport sessionTransport = new WebFluxMcpSessionTransport((FluxSink<ServerSentEvent<?>>)sink);
            McpServerSession session = this.sessionFactory.create((McpServerTransport)sessionTransport);
            String sessionId = session.getId();
            logger.debug("Created new SSE connection for session: {}", (Object)sessionId);
            this.sessions.put(sessionId, session);
            logger.debug("Sending initial endpoint event to session: {}", (Object)sessionId);
            sink.next((Object)ServerSentEvent.builder().event(ENDPOINT_EVENT_TYPE).data((Object)(this.baseUrl + this.messageEndpoint + "?sessionId=" + sessionId)).build());
            sink.onCancel(() -> {
                logger.debug("Session {} cancelled", (Object)sessionId);
                this.sessions.remove(sessionId);
            });
        }).contextWrite(ctx -> ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)transportContext)), ServerSentEvent.class);
    }

    private Mono<ServerResponse> handleMessage(ServerRequest request) {
        if (this.isClosing) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).bodyValue((Object)"Server is shutting down");
        }
        if (request.queryParam("sessionId").isEmpty()) {
            return ServerResponse.badRequest().bodyValue((Object)new McpError((Object)"Session ID missing in message endpoint"));
        }
        McpServerSession session = this.sessions.get(request.queryParam("sessionId").get());
        if (session == null) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.NOT_FOUND).bodyValue((Object)new McpError((Object)("Session not found: " + (String)request.queryParam("sessionId").get())));
        }
        McpTransportContext transportContext = this.contextExtractor.extract((Object)request, (McpTransportContext)new DefaultMcpTransportContext());
        return request.bodyToMono(String.class).flatMap(body -> {
            try {
                McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)body);
                return session.handle(message).flatMap(response -> ServerResponse.ok().build()).onErrorResume(error -> {
                    logger.error("Error processing  message: {}", (Object)error.getMessage());
                    return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).bodyValue((Object)new McpError((Object)error.getMessage()));
                });
            }
            catch (IOException | IllegalArgumentException e) {
                logger.error("Failed to deserialize message: {}", (Object)e.getMessage());
                return ServerResponse.badRequest().bodyValue((Object)new McpError((Object)"Invalid message format"));
            }
        }).contextWrite(ctx -> ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)transportContext));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ObjectMapper objectMapper;
        private String baseUrl = "";
        private String messageEndpoint;
        private String sseEndpoint = "/sse";
        private Duration keepAliveInterval;
        private McpTransportContextExtractor<ServerRequest> contextExtractor = (serverRequest, context) -> context;

        public Builder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder basePath(String baseUrl) {
            Assert.notNull((Object)baseUrl, (String)"basePath must not be null");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder messageEndpoint(String messageEndpoint) {
            Assert.notNull((Object)messageEndpoint, (String)"Message endpoint must not be null");
            this.messageEndpoint = messageEndpoint;
            return this;
        }

        public Builder sseEndpoint(String sseEndpoint) {
            Assert.notNull((Object)sseEndpoint, (String)"SSE endpoint must not be null");
            this.sseEndpoint = sseEndpoint;
            return this;
        }

        public Builder keepAliveInterval(Duration keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        public Builder contextExtractor(McpTransportContextExtractor<ServerRequest> contextExtractor) {
            Assert.notNull(contextExtractor, (String)"contextExtractor must not be null");
            this.contextExtractor = contextExtractor;
            return this;
        }

        public WebFluxSseServerTransportProvider build() {
            Assert.notNull((Object)this.objectMapper, (String)"ObjectMapper must be set");
            Assert.notNull((Object)this.messageEndpoint, (String)"Message endpoint must be set");
            return new WebFluxSseServerTransportProvider(this.objectMapper, this.baseUrl, this.messageEndpoint, this.sseEndpoint, this.keepAliveInterval, this.contextExtractor);
        }
    }

    private class WebFluxMcpSessionTransport
    implements McpServerTransport {
        private final FluxSink<ServerSentEvent<?>> sink;

        public WebFluxMcpSessionTransport(FluxSink<ServerSentEvent<?>> sink) {
            this.sink = sink;
        }

        public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
            return Mono.fromSupplier(() -> {
                try {
                    return WebFluxSseServerTransportProvider.this.objectMapper.writeValueAsString((Object)message);
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }).doOnNext(jsonText -> {
                ServerSentEvent event = ServerSentEvent.builder().event(WebFluxSseServerTransportProvider.MESSAGE_EVENT_TYPE).data(jsonText).build();
                this.sink.next((Object)event);
            }).doOnError(e -> {
                Throwable exception = Exceptions.unwrap((Throwable)e);
                this.sink.error(exception);
            }).then();
        }

        public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
            return (T)WebFluxSseServerTransportProvider.this.objectMapper.convertValue(data, typeRef);
        }

        public Mono<Void> closeGracefully() {
            return Mono.fromRunnable(() -> this.sink.complete());
        }

        public void close() {
            this.sink.complete();
        }
    }
}

