/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

public class ApplyDefaultsStrategy {
    public static final ApplyDefaultsStrategy EMPTY_APPLY_DEFAULTS_STRATEGY = new ApplyDefaultsStrategy(false, false, false);
    private final boolean applyPropertyDefaults;
    private final boolean applyPropertyDefaultsIfNull;
    private final boolean applyArrayDefaults;

    public ApplyDefaultsStrategy(boolean applyPropertyDefaults, boolean applyPropertyDefaultsIfNull, boolean applyArrayDefaults) {
        if (!applyPropertyDefaults && applyPropertyDefaultsIfNull) {
            throw new IllegalArgumentException();
        }
        this.applyPropertyDefaults = applyPropertyDefaults;
        this.applyPropertyDefaultsIfNull = applyPropertyDefaultsIfNull;
        this.applyArrayDefaults = applyArrayDefaults;
    }

    public boolean shouldApplyPropertyDefaults() {
        return this.applyPropertyDefaults;
    }

    public boolean shouldApplyPropertyDefaultsIfNull() {
        return this.applyPropertyDefaultsIfNull;
    }

    public boolean shouldApplyArrayDefaults() {
        return this.applyArrayDefaults;
    }

    public static Builder builder(ApplyDefaultsStrategy copy) {
        if (copy == null) {
            return new Builder();
        }
        Builder builder = new Builder();
        builder.applyArrayDefaults = copy.applyArrayDefaults;
        builder.applyPropertyDefaults = copy.applyPropertyDefaults;
        builder.applyPropertyDefaultsIfNull = copy.applyPropertyDefaultsIfNull;
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean applyPropertyDefaults = false;
        private boolean applyPropertyDefaultsIfNull = false;
        private boolean applyArrayDefaults = false;

        public Builder applyArrayDefaults(boolean applyArrayDefaults) {
            this.applyArrayDefaults = applyArrayDefaults;
            return this;
        }

        public Builder applyPropertyDefaults(boolean applyPropertyDefaults) {
            this.applyPropertyDefaults = applyPropertyDefaults;
            if (!applyPropertyDefaults) {
                this.applyPropertyDefaultsIfNull = false;
            }
            return this;
        }

        public Builder applyPropertyDefaultsIfNull(boolean applyPropertyDefaultsIfNull) {
            this.applyPropertyDefaultsIfNull = applyPropertyDefaultsIfNull;
            if (applyPropertyDefaultsIfNull) {
                this.applyPropertyDefaults = true;
            }
            return this;
        }

        public ApplyDefaultsStrategy build() {
            return new ApplyDefaultsStrategy(this.applyPropertyDefaults, this.applyPropertyDefaultsIfNull, this.applyArrayDefaults);
        }
    }
}

