/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DependenciesValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final Map<String, List<String>> propertyDeps = new HashMap<String, List<String>>();
    private final Map<String, Schema> schemaDeps = new HashMap<String, Schema>();

    public DependenciesValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.DEPENDENCIES, schemaNode, schemaLocation, parentSchema, schemaContext);
        Iterator<Map.Entry<String, JsonNode>> it = schemaNode.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> entry = it.next();
            String pname = entry.getKey();
            JsonNode pvalue = entry.getValue();
            if (pvalue.isArray()) {
                List<String> depsProps = this.propertyDeps.get(pname);
                if (depsProps == null) {
                    depsProps = new ArrayList<String>();
                    this.propertyDeps.put(pname, depsProps);
                }
                for (int i = 0; i < pvalue.size(); ++i) {
                    depsProps.add(pvalue.get(i).asText());
                }
                continue;
            }
            if (!pvalue.isObject() && !pvalue.isBoolean()) continue;
            this.schemaDeps.put(pname, schemaContext.newSchema(schemaLocation.append(pname), pvalue, parentSchema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            Schema schema;
            String pname = it.next();
            List<String> deps = this.propertyDeps.get(pname);
            if (deps != null && !deps.isEmpty()) {
                for (String field : deps) {
                    if (node.get(field) != null) continue;
                    executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).property(pname)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.propertyDeps.toString())).build());
                }
            }
            if ((schema = this.schemaDeps.get(pname)) == null) continue;
            executionContext.evaluationPathAddLast(pname);
            try {
                schema.validate(executionContext, node, rootNode, instanceLocation);
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
        }
    }

    @Override
    public void preloadSchema() {
        this.preloadSchemas(this.schemaDeps.values());
    }
}

