/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class URLParser {
    private String hostname;
    private int port;
    private String database;
    private boolean secure;

    public URLParser(String url) {
        try {
            String path;
            if (url.startsWith("https://")) {
                this.secure = true;
            }
            URI uri = new URI(url);
            this.hostname = uri.getHost();
            if (Objects.isNull(this.hostname)) {
                throw new IllegalArgumentException("Missing hostname in url");
            }
            this.port = uri.getPort();
            if (this.port <= 0) {
                this.port = 19530;
            }
            this.database = Objects.isNull(path = uri.getPath()) || path.isEmpty() || "/".equals(path) ? null : path.substring(1);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url: " + url, e);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        return "URLParser(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", secure=" + this.isSecure() + ")";
    }
}

