/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector;

import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchResults;
import io.milvus.response.DescCollResponseWrapper;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.collection.CollectionService;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.index.IndexService;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorService
extends BaseService {
    Logger logger = LoggerFactory.getLogger(VectorService.class);
    public CollectionService collectionService = new CollectionService();
    public IndexService indexService = new IndexService();

    public InsertResp insert(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, InsertReq request) {
        String title = String.format("InsertRequest collectionName:%s", request.getCollectionName());
        DescribeCollectionRequest describeCollectionRequest = DescribeCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        DescribeCollectionResponse descResp = blockingStub.describeCollection(describeCollectionRequest);
        MutationResult response = blockingStub.insert(this.dataUtils.convertGrpcInsertRequest(request, new DescCollResponseWrapper(descResp)));
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((InsertResp.InsertRespBuilder)InsertResp.builder().InsertCnt(response.getInsertCnt())).build();
    }

    public UpsertResp upsert(MilvusServiceGrpc.MilvusServiceBlockingStub milvusServiceBlockingStub, UpsertReq request) {
        String title = String.format("UpsertRequest collectionName:%s", request.getCollectionName());
        DescribeCollectionRequest describeCollectionRequest = DescribeCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        DescribeCollectionResponse descResp = milvusServiceBlockingStub.describeCollection(describeCollectionRequest);
        MutationResult response = milvusServiceBlockingStub.upsert(this.dataUtils.convertGrpcUpsertRequest(request, new DescCollResponseWrapper(descResp)));
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((UpsertResp.UpsertRespBuilder)UpsertResp.builder().upsertCnt(response.getInsertCnt())).build();
    }

    public QueryResp query(MilvusServiceGrpc.MilvusServiceBlockingStub milvusServiceBlockingStub, QueryReq request) {
        String title = String.format("QueryRequest collectionName:%s", request.getCollectionName());
        if (request.getFilter() == null && request.getIds() == null) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "filter and ids can't be null at the same time");
        }
        if (request.getFilter() != null && request.getIds() != null) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        DescribeCollectionResp descR = this.collectionService.describeCollection(milvusServiceBlockingStub, (DescribeCollectionReq)((DescribeCollectionReq.DescribeCollectionReqBuilder)DescribeCollectionReq.builder().collectionName(request.getCollectionName())).build());
        if (request.getIds() != null && request.getFilter() == null) {
            request.setFilter(this.vectorUtils.getExprById(descR.getPrimaryFieldName(), request.getIds()));
        }
        QueryResults response = milvusServiceBlockingStub.query(this.vectorUtils.ConvertToGrpcQueryRequest(request));
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((QueryResp.QueryRespBuilder)QueryResp.builder().queryResults(this.convertUtils.getEntities(response))).build();
    }

    public SearchResp search(MilvusServiceGrpc.MilvusServiceBlockingStub milvusServiceBlockingStub, SearchReq request) {
        String title = String.format("SearchRequest collectionName:%s", request.getCollectionName());
        SearchRequest searchRequest = this.vectorUtils.ConvertToGrpcSearchRequest(request);
        SearchResults response = milvusServiceBlockingStub.search(searchRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((SearchResp.SearchRespBuilder)SearchResp.builder().searchResults(this.convertUtils.getEntities(response))).build();
    }

    public DeleteResp delete(MilvusServiceGrpc.MilvusServiceBlockingStub milvusServiceBlockingStub, DeleteReq request) {
        String title = String.format("DeleteRequest collectionName:%s", request.getCollectionName());
        if (request.getFilter() != null && request.getIds() != null) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        DescribeCollectionResp respR = this.collectionService.describeCollection(milvusServiceBlockingStub, (DescribeCollectionReq)((DescribeCollectionReq.DescribeCollectionReqBuilder)DescribeCollectionReq.builder().collectionName(request.getCollectionName())).build());
        if (request.getFilter() == null) {
            request.setFilter(this.vectorUtils.getExprById(respR.getPrimaryFieldName(), request.getIds()));
        }
        DeleteRequest deleteRequest = DeleteRequest.newBuilder().setCollectionName(request.getCollectionName()).setPartitionName(request.getPartitionName()).setExpr(request.getFilter()).build();
        MutationResult response = milvusServiceBlockingStub.delete(deleteRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((DeleteResp.DeleteRespBuilder)DeleteResp.builder().deleteCnt(response.getDeleteCnt())).build();
    }

    public GetResp get(MilvusServiceGrpc.MilvusServiceBlockingStub milvusServiceBlockingStub, GetReq request) {
        String title = String.format("GetRequest collectionName:%s", request.getCollectionName());
        this.logger.debug(title);
        Object queryReq = ((QueryReq.QueryReqBuilder)((QueryReq.QueryReqBuilder)QueryReq.builder().collectionName(request.getCollectionName())).ids(request.getIds())).build();
        if (request.getOutputFields() != null) {
            ((QueryReq)queryReq).setOutputFields(request.getOutputFields());
        }
        QueryResp queryResp = this.query(milvusServiceBlockingStub, (QueryReq)queryReq);
        return ((GetResp.GetRespBuilder)GetResp.builder().getResults(queryResp.getQueryResults())).build();
    }
}

