/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.examples;

import com.alibaba.fastjson.JSONObject;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simple {
    Integer dim = 2;
    String collectionName = "book";
    static Logger logger = LoggerFactory.getLogger(Simple.class);

    public static void main(String[] args) {
        try {
            new Simple().run();
        }
        catch (MilvusClientException | InterruptedException e) {
            logger.info(e.toString());
        }
    }

    public void run() throws InterruptedException {
        Object connectConfig = ((ConnectConfig.ConnectConfigBuilder)((ConnectConfig.ConnectConfigBuilder)ConnectConfig.builder().uri("https://in01-***.aws-us-west-2.vectordb.zillizcloud.com:19531")).token("***")).build();
        MilvusClientV2 client = new MilvusClientV2((ConnectConfig)connectConfig);
        if (client.hasCollection((HasCollectionReq)((HasCollectionReq.HasCollectionReqBuilder)HasCollectionReq.builder().collectionName(this.collectionName)).build()).booleanValue()) {
            logger.info("collection exists");
            client.dropCollection((DropCollectionReq)((DropCollectionReq.DropCollectionReqBuilder)DropCollectionReq.builder().collectionName(this.collectionName)).build());
            logger.info("collection dropped");
        }
        Object createCollectionReq = ((CreateCollectionReq.CreateCollectionReqBuilder)((CreateCollectionReq.CreateCollectionReqBuilder)((CreateCollectionReq.CreateCollectionReqBuilder)CreateCollectionReq.builder().collectionName(this.collectionName)).description("simple collection")).dimension(this.dim)).build();
        client.createCollection((CreateCollectionReq)createCollectionReq);
        logger.info(String.valueOf(client.listCollections()));
        logger.info(String.valueOf(client.describeCollection((DescribeCollectionReq)((DescribeCollectionReq.DescribeCollectionReqBuilder)DescribeCollectionReq.builder().collectionName(this.collectionName)).build())));
        ArrayList<JSONObject> insertData = new ArrayList<JSONObject>();
        for (int i = 0; i < 6; ++i) {
            JSONObject jsonObject = new JSONObject();
            ArrayList<Float> vectorList = new ArrayList<Float>();
            for (int j = 0; j < this.dim; ++j) {
                vectorList.add(Float.valueOf(new Random().nextFloat()));
            }
            jsonObject.put("id", (Object)i);
            jsonObject.put("vector", vectorList);
            insertData.add(jsonObject);
        }
        Object insertReq = ((InsertReq.InsertReqBuilder)((InsertReq.InsertReqBuilder)InsertReq.builder().collectionName(this.collectionName)).data(insertData)).build();
        client.insert((InsertReq)insertReq);
        Object queryReq = ((QueryReq.QueryReqBuilder)((QueryReq.QueryReqBuilder)QueryReq.builder().collectionName(this.collectionName)).filter("id in [0]")).build();
        QueryResp queryResp = client.query((QueryReq)queryReq);
        System.out.println(queryResp);
        Object searchReq = ((SearchReq.SearchReqBuilder)((SearchReq.SearchReqBuilder)((SearchReq.SearchReqBuilder)SearchReq.builder().collectionName(this.collectionName)).data(Collections.singletonList(((JSONObject)insertData.get(0)).get((Object)"vector")))).topK(10)).build();
        SearchResp searchResp = client.search((SearchReq)searchReq);
        System.out.println(searchResp);
    }
}

