/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.examples;

import com.alibaba.fastjson.JSONObject;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.DataType;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.collection.request.LoadCollectionReq;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simple_Schema {
    Integer dim = 2;
    String collectionName = "book";
    static Logger logger = LoggerFactory.getLogger(Simple_Schema.class);

    public void run() throws InterruptedException {
        Object connectConfig = ((ConnectConfig.ConnectConfigBuilder)((ConnectConfig.ConnectConfigBuilder)ConnectConfig.builder().uri("https://in01-***.aws-us-west-2.vectordb.zillizcloud.com:19531")).token("***")).build();
        MilvusClientV2 client = new MilvusClientV2((ConnectConfig)connectConfig);
        if (client.hasCollection((HasCollectionReq)((HasCollectionReq.HasCollectionReqBuilder)HasCollectionReq.builder().collectionName(this.collectionName)).build()).booleanValue()) {
            logger.info("collection exists");
            client.dropCollection((DropCollectionReq)((DropCollectionReq.DropCollectionReqBuilder)DropCollectionReq.builder().collectionName(this.collectionName)).build());
        }
        CreateCollectionReq.CollectionSchema collectionSchema = client.createSchema();
        collectionSchema.addField((AddFieldReq)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)AddFieldReq.builder().fieldName("id")).dataType(DataType.Int64)).isPrimaryKey(Boolean.TRUE)).autoID(Boolean.FALSE)).description("id")).build());
        collectionSchema.addField((AddFieldReq)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)AddFieldReq.builder().fieldName("vector")).dataType(DataType.FloatVector)).dimension(this.dim)).build());
        collectionSchema.addField((AddFieldReq)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)AddFieldReq.builder().fieldName("num")).dataType(DataType.Int64)).isPartitionKey(Boolean.TRUE)).build());
        collectionSchema.addField((AddFieldReq)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)((AddFieldReq.AddFieldReqBuilder)AddFieldReq.builder().fieldName("array")).dataType(DataType.Array)).elementType(DataType.Int32)).maxCapacity(10)).description("array")).build());
        Object createCollectionReq = ((CreateCollectionReq.CreateCollectionReqBuilder)((CreateCollectionReq.CreateCollectionReqBuilder)((CreateCollectionReq.CreateCollectionReqBuilder)((CreateCollectionReq.CreateCollectionReqBuilder)CreateCollectionReq.builder().collectionName(this.collectionName)).description("simple collection")).collectionSchema(collectionSchema)).enableDynamicField(Boolean.FALSE)).build();
        client.createCollection((CreateCollectionReq)createCollectionReq);
        Object indexParam = ((IndexParam.IndexParamBuilder)((IndexParam.IndexParamBuilder)IndexParam.builder().fieldName("vector")).metricType(IndexParam.MetricType.COSINE)).build();
        Object createIndexReq = ((CreateIndexReq.CreateIndexReqBuilder)((CreateIndexReq.CreateIndexReqBuilder)CreateIndexReq.builder().collectionName(this.collectionName)).indexParams(Collections.singletonList(indexParam))).build();
        client.createIndex((CreateIndexReq)createIndexReq);
        TimeUnit.SECONDS.sleep(1L);
        client.loadCollection((LoadCollectionReq)((LoadCollectionReq.LoadCollectionReqBuilder)LoadCollectionReq.builder().collectionName(this.collectionName)).build());
        ArrayList<JSONObject> insertData = new ArrayList<JSONObject>();
        for (int i = 0; i < 6; ++i) {
            JSONObject jsonObject = new JSONObject();
            ArrayList<Float> vectorList = new ArrayList<Float>();
            for (int j = 0; j < this.dim; ++j) {
                vectorList.add(Float.valueOf(new Random().nextFloat()));
            }
            ArrayList<Integer> array = new ArrayList<Integer>();
            array.add(i);
            jsonObject.put("id", (Object)i);
            jsonObject.put("vector", vectorList);
            jsonObject.put("num", (Object)i);
            jsonObject.put("array", array);
            insertData.add(jsonObject);
        }
        Object insertReq = ((InsertReq.InsertReqBuilder)((InsertReq.InsertReqBuilder)InsertReq.builder().collectionName(this.collectionName)).data(insertData)).build();
        client.insert((InsertReq)insertReq);
        Object queryReq = ((QueryReq.QueryReqBuilder)((QueryReq.QueryReqBuilder)QueryReq.builder().collectionName(this.collectionName)).filter("id in [0]")).build();
        QueryResp queryResp = client.query((QueryReq)queryReq);
        queryResp.getQueryResults().get(0).getEntity().get("vector");
        System.out.println(queryResp);
        Object searchReq = ((SearchReq.SearchReqBuilder)((SearchReq.SearchReqBuilder)((SearchReq.SearchReqBuilder)((SearchReq.SearchReqBuilder)SearchReq.builder().collectionName(this.collectionName)).data(Collections.singletonList(((JSONObject)insertData.get(0)).get((Object)"vector")))).outputFields(Collections.singletonList("vector"))).topK(10)).build();
        SearchResp searchResp = client.search((SearchReq)searchReq);
        System.out.println(searchResp);
    }

    public static void main(String[] args) {
        try {
            new Simple_Schema().run();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

