/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class SelectRoleParam {
    private final String roleName;
    private final boolean includeUserInfo;

    private SelectRoleParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.roleName = builder.roleName;
        this.includeUserInfo = builder.includeUserInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public boolean isIncludeUserInfo() {
        return this.includeUserInfo;
    }

    public String toString() {
        return "SelectRoleParam(roleName=" + this.getRoleName() + ", includeUserInfo=" + this.isIncludeUserInfo() + ")";
    }

    public static final class Builder {
        private String roleName;
        private boolean includeUserInfo;

        private Builder() {
        }

        public Builder withRoleName(@NonNull String roleName) {
            if (roleName == null) {
                throw new NullPointerException("roleName is marked non-null but is null");
            }
            this.roleName = roleName;
            return this;
        }

        public Builder withIncludeUserInfo(boolean includeUserInfo) {
            this.includeUserInfo = includeUserInfo;
            return this;
        }

        public SelectRoleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            return new SelectRoleParam(this);
        }
    }
}

