/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.orm.iterator;

import io.milvus.grpc.DataType;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.QueryResults;
import io.milvus.orm.iterator.IteratorCache;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.FieldType;
import io.milvus.param.dml.QueryIteratorParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.v2.utils.RpcUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QueryIterator {
    private final IteratorCache iteratorCache = new IteratorCache();
    private final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final FieldType primaryField;
    private final QueryIteratorParam queryIteratorParam;
    private final int batchSize;
    private final long limit;
    private final String expr;
    private long offset;
    private Object nextId;
    private int cacheIdInUse;
    private long returnedCount;
    private final RpcUtils rpcUtils;

    public QueryIterator(QueryIteratorParam queryIteratorParam, MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, FieldType primaryField) {
        this.blockingStub = blockingStub;
        this.primaryField = primaryField;
        this.queryIteratorParam = queryIteratorParam;
        this.batchSize = (int)queryIteratorParam.getBatchSize();
        this.expr = queryIteratorParam.getExpr();
        this.limit = queryIteratorParam.getLimit();
        this.offset = queryIteratorParam.getOffset();
        this.rpcUtils = new RpcUtils();
        this.seek();
    }

    private void seek() {
        this.cacheIdInUse = -1;
        if (this.offset == 0L) {
            this.nextId = null;
            return;
        }
        List<QueryResultsWrapper.RowRecord> res = this.getQueryResultsWrapper(this.expr, 0L, this.offset);
        this.updateCursor(res.subList(0, (int)this.offset));
        this.offset = 0L;
    }

    public List<QueryResultsWrapper.RowRecord> next() {
        List<QueryResultsWrapper.RowRecord> ret;
        List<QueryResultsWrapper.RowRecord> cachedRes = this.iteratorCache.fetchCache(this.cacheIdInUse);
        if (this.isResSufficient(cachedRes)) {
            ret = cachedRes.subList(0, this.batchSize);
            List<QueryResultsWrapper.RowRecord> retToCache = cachedRes.subList(this.batchSize, cachedRes.size());
            this.iteratorCache.cache(this.cacheIdInUse, retToCache);
        } else {
            this.iteratorCache.releaseCache(this.cacheIdInUse);
            String currentExpr = this.setupNextExpr();
            List<QueryResultsWrapper.RowRecord> res = this.getQueryResultsWrapper(currentExpr, this.offset, this.batchSize);
            this.maybeCache(res);
            ret = res.subList(0, Math.min(this.batchSize, res.size()));
        }
        ret = this.checkReachedLimit(ret);
        this.updateCursor(ret);
        this.returnedCount += (long)ret.size();
        return ret;
    }

    public void close() {
        this.iteratorCache.releaseCache(this.cacheIdInUse);
    }

    private void updateCursor(List<QueryResultsWrapper.RowRecord> res) {
        if (res.isEmpty()) {
            return;
        }
        this.nextId = res.get(res.size() - 1).get(this.primaryField.getName());
    }

    private List<QueryResultsWrapper.RowRecord> checkReachedLimit(List<QueryResultsWrapper.RowRecord> ret) {
        if (this.limit == -1L) {
            return ret;
        }
        long leftCount = this.limit - this.returnedCount;
        if (leftCount >= (long)ret.size()) {
            return ret;
        }
        return ret.subList(0, (int)leftCount);
    }

    private void maybeCache(List<QueryResultsWrapper.RowRecord> ret) {
        if (ret.size() < 2 * this.batchSize) {
            return;
        }
        List<QueryResultsWrapper.RowRecord> cacheResult = ret.subList(this.batchSize, ret.size());
        this.cacheIdInUse = this.iteratorCache.cache(-1, cacheResult);
    }

    private String setupNextExpr() {
        String currentExpr = this.expr;
        if (this.nextId == null) {
            return currentExpr;
        }
        String filteredPKStr = this.primaryField.getDataType() == DataType.VarChar ? this.primaryField.getName() + " > \\" + this.nextId + "\\" : this.primaryField.getName() + " > " + this.nextId;
        if (StringUtils.isEmpty((CharSequence)currentExpr)) {
            return filteredPKStr;
        }
        return currentExpr + " and " + filteredPKStr;
    }

    private boolean isResSufficient(List<QueryResultsWrapper.RowRecord> ret) {
        return ret != null && ret.size() >= this.batchSize;
    }

    private List<QueryResultsWrapper.RowRecord> getQueryResultsWrapper(String expr, long offset, long limit) {
        QueryParam queryParam = QueryParam.newBuilder().withDatabaseName(this.queryIteratorParam.getDatabaseName()).withCollectionName(this.queryIteratorParam.getCollectionName()).withConsistencyLevel(this.queryIteratorParam.getConsistencyLevel()).withPartitionNames(this.queryIteratorParam.getPartitionNames()).withOutFields(this.queryIteratorParam.getOutFields()).withExpr(expr).withOffset(offset).withLimit(limit).withIgnoreGrowing(this.queryIteratorParam.isIgnoreGrowing()).build();
        QueryRequest queryRequest = ParamUtils.convertQueryParam(queryParam);
        QueryResults response = this.blockingStub.query(queryRequest);
        String title = String.format("QueryRequest collectionName:%s", this.queryIteratorParam.getCollectionName());
        this.rpcUtils.handleResponse(title, response.getStatus());
        QueryResultsWrapper queryWrapper = new QueryResultsWrapper(response);
        return queryWrapper.getRowRecords();
    }
}

