/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import io.milvus.grpc.FieldData;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.ScalarField;
import io.milvus.grpc.SearchResults;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ConvertUtils {
    public List<QueryResp.QueryResult> getEntities(QueryResults response) {
        QueryResultsWrapper queryResultsWrapper = new QueryResultsWrapper(response);
        ArrayList<QueryResp.QueryResult> entities = new ArrayList<QueryResp.QueryResult>();
        if (response.getFieldsDataList().stream().anyMatch(fieldData -> fieldData.getFieldName().equals("count(*)"))) {
            HashMap<String, Object> countField = new HashMap<String, Object>();
            long numOfEntities = ((ScalarField)response.getFieldsDataList().stream().filter(fieldData -> fieldData.getFieldName().equals("count(*)")).map(FieldData::getScalars).collect(Collectors.toList()).get(0)).getLongData().getData(0);
            countField.put("count(*)", numOfEntities);
            Object queryResult = ((QueryResp.QueryResult.QueryResultBuilder)QueryResp.QueryResult.builder().entity(countField)).build();
            entities.add((QueryResp.QueryResult)queryResult);
            return entities;
        }
        queryResultsWrapper.getRowRecords().forEach(rowRecord -> {
            Object queryResult = ((QueryResp.QueryResult.QueryResultBuilder)QueryResp.QueryResult.builder().entity(rowRecord.getFieldValues())).build();
            entities.add((QueryResp.QueryResult)queryResult);
        });
        return entities;
    }

    public List<List<SearchResp.SearchResult>> getEntities(SearchResults response) {
        SearchResultsWrapper searchResultsWrapper = new SearchResultsWrapper(response.getResults());
        long numQueries = response.getResults().getNumQueries();
        ArrayList<List<SearchResp.SearchResult>> searchResults = new ArrayList<List<SearchResp.SearchResult>>();
        int i = 0;
        while ((long)i < numQueries) {
            searchResults.add(searchResultsWrapper.getIDScore(i).stream().map(idScore -> ((SearchResp.SearchResult.SearchResultBuilder)((SearchResp.SearchResult.SearchResultBuilder)((SearchResp.SearchResult.SearchResultBuilder)SearchResp.SearchResult.builder().entity(idScore.getFieldValues())).distance(Float.valueOf(idScore.getScore()))).id(idScore.getStrID().isEmpty() ? Long.valueOf(idScore.getLongID()) : idScore.getStrID())).build()).collect(Collectors.toList()));
            ++i;
        }
        return searchResults;
    }

    public DescribeIndexResp convertToDescribeIndexResp(IndexDescription response) {
        Object describeIndexResp = ((DescribeIndexResp.DescribeIndexRespBuilder)((DescribeIndexResp.DescribeIndexRespBuilder)DescribeIndexResp.builder().indexName(response.getIndexName())).fieldName(response.getFieldName())).build();
        List<KeyValuePair> params = response.getParamsList();
        for (KeyValuePair param : params) {
            if (param.getKey().equals("index_type")) {
                ((DescribeIndexResp)describeIndexResp).setIndexType(param.getValue());
                continue;
            }
            if (!param.getKey().equals("metric_type")) continue;
            ((DescribeIndexResp)describeIndexResp).setMetricType(param.getValue());
        }
        return describeIndexResp;
    }
}

