/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.connect;

import com.azure.core.credential.TokenCredential;
import io.milvus.bulkwriter.connect.StorageConnectParam;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class AzureConnectParam
extends StorageConnectParam {
    private final String containerName;
    private final String connStr;
    private final String accountUrl;
    private final TokenCredential credential;

    private AzureConnectParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.containerName = builder.containerName;
        this.connStr = builder.connStr;
        this.accountUrl = builder.accountUrl;
        this.credential = builder.credential;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getConnStr() {
        return this.connStr;
    }

    public String getAccountUrl() {
        return this.accountUrl;
    }

    public TokenCredential getCredential() {
        return this.credential;
    }

    public String toString() {
        return "AzureConnectParam(containerName=" + this.getContainerName() + ", connStr=" + this.getConnStr() + ", accountUrl=" + this.getAccountUrl() + ", credential=" + this.getCredential() + ")";
    }

    public static final class Builder {
        private String containerName;
        private String connStr;
        private String accountUrl;
        private TokenCredential credential;

        private Builder() {
        }

        public Builder withContainerName(@NonNull String containerName) {
            if (containerName == null) {
                throw new NullPointerException("containerName is marked non-null but is null");
            }
            this.containerName = containerName;
            return this;
        }

        public Builder withConnStr(@NonNull String connStr) {
            if (connStr == null) {
                throw new NullPointerException("connStr is marked non-null but is null");
            }
            this.connStr = connStr;
            return this;
        }

        public Builder withAccountUrl(@NonNull String accountUrl) {
            if (accountUrl == null) {
                throw new NullPointerException("accountUrl is marked non-null but is null");
            }
            this.accountUrl = accountUrl;
            return this;
        }

        public Builder withCredential(@NonNull TokenCredential credential) {
            if (credential == null) {
                throw new NullPointerException("credential is marked non-null but is null");
            }
            this.credential = credential;
            return this;
        }

        public AzureConnectParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.containerName, "containerName");
            return new AzureConnectParam(this);
        }
    }
}

