/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.writer;

import io.milvus.bulkwriter.common.utils.ParquetUtils;
import io.milvus.bulkwriter.writer.FormatFileWriter;
import io.milvus.common.utils.JsonUtils;
import io.milvus.v2.common.DataType;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileWriter
implements FormatFileWriter {
    private static final Logger logger = LoggerFactory.getLogger(ParquetFileWriter.class);
    private ParquetWriter<Group> writer;
    private CreateCollectionReq.CollectionSchema collectionSchema;
    private String filePath;
    private MessageType messageType;
    private Map<String, CreateCollectionReq.FieldSchema> nameFieldType;

    public ParquetFileWriter(CreateCollectionReq.CollectionSchema collectionSchema, String filePathPrefix) throws IOException {
        this.collectionSchema = collectionSchema;
        this.initFilePath(filePathPrefix);
        this.initNameFieldType();
        this.initMessageType();
        this.initWriter();
    }

    private void initFilePath(String filePathPrefix) {
        this.filePath = filePathPrefix + ".parquet";
    }

    private void initMessageType() {
        this.messageType = ParquetUtils.parseCollectionSchema(this.collectionSchema);
    }

    private void initWriter() throws IOException {
        int rowGroupBytes = 0x1000000;
        Configuration configuration = ParquetUtils.getParquetConfiguration();
        GroupWriteSupport.setSchema((MessageType)this.messageType, (Configuration)configuration);
        GroupWriteSupport writeSupport = new GroupWriteSupport();
        this.writer = new ParquetWriter(new Path(this.filePath), ParquetFileWriter.Mode.CREATE, (WriteSupport)writeSupport, CompressionCodecName.UNCOMPRESSED, rowGroupBytes, 0x200000, 0x200000, true, false, ParquetWriter.DEFAULT_WRITER_VERSION, configuration);
    }

    private void initNameFieldType() {
        Map<String, CreateCollectionReq.FieldSchema> nameFieldType = this.collectionSchema.getFieldSchemaList().stream().collect(Collectors.toMap(CreateCollectionReq.FieldSchema::getName, e -> e));
        if (this.collectionSchema.isEnableDynamicField()) {
            nameFieldType.put("$meta", CreateCollectionReq.FieldSchema.builder().name("$meta").dataType(DataType.JSON).build());
        }
        this.nameFieldType = nameFieldType;
    }

    @Override
    public void appendRow(Map<String, Object> rowValues, boolean firstWrite) throws IOException {
        rowValues.keySet().removeIf(key -> key.equals("$meta") && !this.collectionSchema.isEnableDynamicField());
        try {
            Group group = new SimpleGroupFactory(this.messageType).newGroup();
            for (String fieldName : rowValues.keySet()) {
                Object value = rowValues.get(fieldName);
                if (value == null) continue;
                this.appendGroup(group, fieldName, value, this.nameFieldType.get(fieldName));
            }
            this.writer.write((Object)group);
        }
        catch (IOException e) {
            logger.error("{} appendRow error when writing to file {}", new Object[]{this.getClass().getSimpleName(), this.filePath, e});
            throw e;
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private void appendGroup(Group group, String paramName, Object value, CreateCollectionReq.FieldSchema field) {
        DataType dataType = field.getDataType();
        block0 : switch (dataType) {
            case Int8: 
            case Int16: {
                group.append(paramName, (int)((Short)value).shortValue());
                break;
            }
            case Int32: {
                group.append(paramName, ((Integer)value).intValue());
                break;
            }
            case Int64: {
                group.append(paramName, ((Long)value).longValue());
                break;
            }
            case Float: {
                group.append(paramName, ((Float)value).floatValue());
                break;
            }
            case Double: {
                group.append(paramName, ((Double)value).doubleValue());
                break;
            }
            case Bool: {
                group.append(paramName, ((Boolean)value).booleanValue());
                break;
            }
            case String: 
            case VarChar: 
            case Geometry: 
            case Timestamptz: 
            case JSON: {
                group.append(paramName, (String)value);
                break;
            }
            case FloatVector: {
                ParquetFileWriter.addFloatArray(group, paramName, (List)value);
                break;
            }
            case BinaryVector: 
            case Float16Vector: 
            case BFloat16Vector: 
            case Int8Vector: {
                ParquetFileWriter.addBinaryVector(group, paramName, (ByteBuffer)value);
                break;
            }
            case SparseFloatVector: {
                ParquetFileWriter.addSparseVector(group, paramName, (SortedMap)value);
                break;
            }
            case Array: {
                DataType elementType = field.getElementType();
                switch (elementType) {
                    case Int8: 
                    case Int16: 
                    case Int32: {
                        ParquetFileWriter.addIntArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Int64: {
                        ParquetFileWriter.addLongArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Float: {
                        ParquetFileWriter.addFloatArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Double: {
                        ParquetFileWriter.addDoubleArray(group, paramName, (List)value);
                        break block0;
                    }
                    case String: 
                    case VarChar: {
                        ParquetFileWriter.addStringArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Bool: {
                        ParquetFileWriter.addBooleanArray(group, paramName, (List)value);
                    }
                }
            }
        }
    }

    private static void addLongArray(Group group, String fieldName, List<Long> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (long value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addStringArray(Group group, String fieldName, List<String> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (String value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addIntArray(Group group, String fieldName, List<Integer> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (int value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addFloatArray(Group group, String fieldName, List<Float> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (float value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addDoubleArray(Group group, String fieldName, List<Double> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (double value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addBooleanArray(Group group, String fieldName, List<Boolean> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (boolean value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addBinaryVector(Group group, String fieldName, ByteBuffer byteBuffer) {
        byte[] bytes;
        Group arrayGroup = group.addGroup(fieldName);
        for (byte value : bytes = byteBuffer.array()) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, (int)value);
        }
    }

    private static void addSparseVector(Group group, String fieldName, SortedMap<Long, Float> sparse) {
        String jsonString = JsonUtils.toJson(sparse);
        group.append(fieldName, jsonString);
    }
}

