/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.restful;

import io.milvus.bulkwriter.response.RestfulResponse;
import io.milvus.common.utils.ExceptionUtils;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.lang3.StringUtils;

public class BaseRestful {
    protected static String postRequest(String url, String apiKey, Map<String, Object> params, int timeout) {
        try {
            BaseRestful.setDefaultOptionsIfCallCloud(params, apiKey);
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).connectTimeout(timeout)).headers(BaseRestful.httpHeaders(apiKey))).body(params).asString();
            if (response.getStatus() == 200) {
                return (String)response.getBody();
            }
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to post url: %s, status code: %s, msg: %s", url, response.getStatus(), response.getBody()));
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to post url: %s, error: %s", url, e));
        }
        return null;
    }

    protected static String deleteRequest(String url, String apiKey, Map<String, Object> params, int timeout) {
        try {
            BaseRestful.setDefaultOptionsIfCallCloud(params, apiKey);
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.delete((String)url).connectTimeout(timeout)).headers(BaseRestful.httpHeaders(apiKey))).asString();
            if (response.getStatus() == 200) {
                return (String)response.getBody();
            }
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to delete url: %s, status code: %s, msg: %s", url, response.getStatus(), response.getBody()));
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to delete url: %s, error: %s", url, e));
        }
        return null;
    }

    protected static String getRequest(String url, String apiKey, Map<String, Object> params, int timeout) {
        try {
            HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)url).connectTimeout(timeout)).headers(BaseRestful.httpHeaders(apiKey))).queryString(params)).asString();
            if (response.getStatus() == 200) {
                return (String)response.getBody();
            }
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to get url: %s, status code: %s, msg: %s", url, response.getStatus(), response.getBody()));
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to get url: %s, error: %s", url, e));
        }
        return null;
    }

    protected static Map<String, String> httpHeaders(String apiKey) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_0) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11");
        header.put("Accept", "application/json");
        header.put("Content-Type", "application/json");
        header.put("Accept-Encodin", "gzip,deflate,sdch");
        header.put("Accept-Languag", "en-US,en;q=0.5");
        if (StringUtils.isNotEmpty((CharSequence)apiKey)) {
            header.put("Authorization", "Bearer " + apiKey);
        }
        return header;
    }

    protected static void handleResponse(String url, RestfulResponse res) {
        int innerCode = res.getCode();
        if (innerCode != 0) {
            String innerMessage = res.getMessage();
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to request url: %s, code: %s, message: %s", url, innerCode, innerMessage));
        }
    }

    private static void setDefaultOptionsIfCallCloud(Map<String, Object> params, String apiKey) {
        if (StringUtils.isNotEmpty((CharSequence)apiKey)) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("sdk", "java");
            options.put("scene", "bulkWriter");
            params.put("options", options);
        }
    }
}

