/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.common.clientenum;

import io.milvus.exception.ParamException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.Lists;

public enum CloudStorage {
    MINIO("minio", "%s", "minioAddress"),
    AWS("aws", "s3.amazonaws.com", null),
    GCP("gcp", "storage.googleapis.com", null),
    AZ("az", "%s.blob.core.windows.net", "accountName"),
    AZURE("azure", "%s.blob.core.windows.net", "accountName"),
    ALI("ali", "oss-%s.aliyuncs.com", "region"),
    ALIYUN("aliyun", "oss-%s.aliyuncs.com", "region"),
    ALIBABA("alibaba", "oss-%s.aliyuncs.com", "region"),
    ALICLOU("alicloud", "oss-%s.aliyuncs.com", "region"),
    TC("tc", "cos.%s.myqcloud.com", "region"),
    TENCENT("tencent", "cos.%s.myqcloud.com", "region");

    private String cloudName;
    private String endpoint;
    private String replace;

    private CloudStorage(String cloudName, String endpoint, String replace) {
        this.cloudName = cloudName;
        this.endpoint = endpoint;
        this.replace = replace;
    }

    public static boolean isAliCloud(String cloudName) {
        ArrayList aliCloudStorages = Lists.newArrayList((Object[])new CloudStorage[]{ALI, ALIYUN, ALIBABA, ALICLOU});
        return aliCloudStorages.stream().anyMatch(e -> e.getCloudName().equalsIgnoreCase(cloudName));
    }

    public static boolean isTcCloud(String cloudName) {
        ArrayList tcCloudStorages = Lists.newArrayList((Object[])new CloudStorage[]{TC, TENCENT});
        return tcCloudStorages.stream().anyMatch(e -> e.getCloudName().equalsIgnoreCase(cloudName));
    }

    public static boolean isAzCloud(String cloudName) {
        ArrayList azCloudStorages = Lists.newArrayList((Object[])new CloudStorage[]{AZ, AZURE});
        return azCloudStorages.stream().anyMatch(e -> e.getCloudName().equalsIgnoreCase(cloudName));
    }

    public static CloudStorage getCloudStorage(String cloudName) {
        for (CloudStorage cloudStorage : CloudStorage.values()) {
            if (!cloudStorage.getCloudName().equals(cloudName)) continue;
            return cloudStorage;
        }
        throw new ParamException("no support others cloudName");
    }

    public String getEndpoint(String ... replaceParams) {
        if (StringUtils.isEmpty((CharSequence)this.replace)) {
            return this.endpoint;
        }
        if (replaceParams.length == 0) {
            throw new ParamException(String.format("Please input the replaceParams:%s when you want to get endpoint of %s", this.replace, this.name()));
        }
        return String.format(this.endpoint, replaceParams[0]);
    }

    public String getS3ObjectUrl(String bucketName, String commonPrefix, String region) {
        switch (this) {
            case AWS: {
                return String.format("https://s3.%s.amazonaws.com/%s/%s", region, bucketName, commonPrefix);
            }
            case GCP: {
                return String.format("https://storage.cloud.google.com/%s/%s", bucketName, commonPrefix);
            }
            case TC: 
            case TENCENT: {
                return String.format("https://%s.cos.%s.myqcloud.com/%s", bucketName, region, commonPrefix);
            }
            case ALI: 
            case ALICLOU: 
            case ALIBABA: 
            case ALIYUN: {
                return String.format("https://%s.oss-%s.aliyuncs.com/%s", bucketName, region, commonPrefix);
            }
        }
        throw new ParamException("no support others remote storage address");
    }

    public String getAzureObjectUrl(String accountName, String containerName, String commonPrefix) {
        if (CloudStorage.isAzCloud(this.getCloudName())) {
            return String.format("https://%s.blob.core.windows.net/%s/%s", accountName, containerName, commonPrefix);
        }
        throw new ParamException("no support others remote storage address");
    }

    public String getCloudName() {
        return this.cloudName;
    }
}

