/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.milvus.bulkwriter.LocalBulkWriter;
import io.milvus.bulkwriter.StageBulkWriterParam;
import io.milvus.bulkwriter.StageFileManager;
import io.milvus.bulkwriter.StageFileManagerParam;
import io.milvus.bulkwriter.common.clientenum.ConnectType;
import io.milvus.bulkwriter.model.UploadFilesResult;
import io.milvus.bulkwriter.request.stage.UploadFilesRequest;
import io.milvus.common.utils.ExceptionUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageBulkWriter
extends LocalBulkWriter {
    private static final Logger logger = LoggerFactory.getLogger(StageBulkWriter.class);
    private String remotePath;
    private List<List<String>> remoteFiles;
    private StageFileManager stageFileManager;
    private StageBulkWriterParam stageBulkWriterParam;

    public StageBulkWriter(StageBulkWriterParam bulkWriterParam) throws IOException {
        super(bulkWriterParam.getCollectionSchema(), bulkWriterParam.getChunkSize(), bulkWriterParam.getFileType(), StageBulkWriter.generatorLocalPath(), bulkWriterParam.getConfig());
        Path path = Paths.get(bulkWriterParam.getRemotePath(), new String[0]);
        Path remoteDirPath = path.resolve(this.getUUID());
        this.remotePath = remoteDirPath + "/";
        this.stageFileManager = this.initStageFileManagerParams(bulkWriterParam);
        this.stageBulkWriterParam = bulkWriterParam;
        this.remoteFiles = Lists.newArrayList();
        logger.info("Remote buffer writer initialized, target path: {}", (Object)this.remotePath);
    }

    private StageFileManager initStageFileManagerParams(StageBulkWriterParam bulkWriterParam) throws IOException {
        StageFileManagerParam stageFileManagerParam = StageFileManagerParam.newBuilder().withCloudEndpoint(bulkWriterParam.getCloudEndpoint()).withApiKey(bulkWriterParam.getApiKey()).withStageName(bulkWriterParam.getStageName()).withConnectType(ConnectType.AUTO).build();
        return new StageFileManager(stageFileManagerParam);
    }

    @Override
    public void appendRow(JsonObject rowData) throws IOException, InterruptedException {
        super.appendRow(rowData);
    }

    @Override
    public void commit(boolean async) throws InterruptedException {
        super.commit(async);
    }

    @Override
    protected String getDataPath() {
        return this.remotePath;
    }

    @Override
    public List<List<String>> getBatchFiles() {
        return this.remoteFiles;
    }

    public UploadFilesResult getStageUploadResult() {
        return UploadFilesResult.builder().stageName(this.stageBulkWriterParam.getStageName()).path(this.remotePath).build();
    }

    @Override
    protected void exit() throws InterruptedException {
        super.exit();
        Path parentPath = Paths.get(this.localPath, new String[0]).getParent();
        if (parentPath.toFile().exists() && StageBulkWriter.isEmptyDirectory(parentPath)) {
            try {
                Files.delete(parentPath);
                logger.info("Delete empty directory: " + parentPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isEmptyDirectory(Path directory) {
        try {
            return !Files.walk(directory, 1, FileVisitOption.FOLLOW_LINKS).skip(1L).findFirst().isPresent();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void rmLocal(String file) {
        try {
            Path filePath = Paths.get(file, new String[0]);
            filePath.toFile().delete();
            Path parentDir = filePath.getParent();
            if (parentDir != null && !parentDir.toString().equals(this.localPath)) {
                try {
                    Files.delete(parentDir);
                    logger.info("Delete empty directory: " + parentDir);
                }
                catch (IOException ex) {
                    logger.warn("Failed to delete empty directory: " + parentDir);
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to delete local file: " + file);
        }
    }

    @Override
    protected void callBack(List<String> fileList) {
        this.serialImportData(fileList);
    }

    @Override
    public void close() throws Exception {
        logger.info("execute remaining actions to prevent loss of memory data or residual empty directories.");
        this.exit();
        logger.info(String.format("RemoteBulkWriter done! output remote files: %s", this.getBatchFiles()));
    }

    private void serialImportData(List<String> fileList) {
        ArrayList<String> remoteFileList = new ArrayList<String>();
        try {
            for (String filePath : fileList) {
                String relativeFilePath = filePath.replace(super.getDataPath(), "");
                String minioFilePath = StageBulkWriter.getMinioFilePath(this.remotePath, relativeFilePath);
                this.uploadObject(filePath, minioFilePath);
                remoteFileList.add(minioFilePath);
                this.rmLocal(filePath);
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException((String)String.format("Failed to upload files, error: %s", e));
        }
        logger.info("Successfully upload files: " + fileList);
        this.remoteFiles.add(remoteFileList);
    }

    private void uploadObject(String filePath, String objectName) throws Exception {
        logger.info(String.format("Prepare to upload %s to %s", filePath, objectName));
        Object uploadFilesRequest = ((UploadFilesRequest.UploadFilesRequestBuilder)((UploadFilesRequest.UploadFilesRequestBuilder)UploadFilesRequest.builder().sourceFilePath(filePath)).targetStagePath(this.remotePath)).build();
        this.stageFileManager.uploadFilesAsync((UploadFilesRequest)uploadFilesRequest).get();
        logger.info(String.format("Upload file %s to %s", filePath, objectName));
    }

    private static String generatorLocalPath() {
        Path currentWorkingDirectory = Paths.get("", new String[0]).toAbsolutePath();
        Path currentScriptPath = currentWorkingDirectory.resolve("bulk_writer");
        return currentScriptPath.toString();
    }

    private static String getMinioFilePath(String remotePath, String relativeFilePath) {
        remotePath = remotePath.startsWith("/") ? remotePath.substring(1) : remotePath;
        Path remote = Paths.get(remotePath, new String[0]);
        relativeFilePath = relativeFilePath.startsWith("/") ? relativeFilePath.substring(1) : relativeFilePath;
        Path relative = Paths.get(relativeFilePath, new String[0]);
        Path joinedPath = remote.resolve(relative);
        return joinedPath.toString();
    }
}

