/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.extractors;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.validation.validator.extractors.UnwrapByDefaultValueExtractor;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.valueextraction.ExtractedValue;
import jakarta.validation.valueextraction.UnwrapByDefault;
import jakarta.validation.valueextraction.ValueExtractor;
import jakarta.validation.valueextraction.ValueExtractorDefinitionException;

public record ValueExtractorDefinition<T>(@NonNull Class<T> containerType, @NonNull Class<Object> valueType, @Nullable Integer typeArgumentIndex, boolean unwrapByDefault, ValueExtractor<T> valueExtractor) {
    public ValueExtractorDefinition(@NotNull Argument<ValueExtractor<T>> argument, @NotNull ValueExtractor<T> valueExtractor) {
        this(argument, (Argument)argument.getFirstTypeVariable().orElseThrow(), valueExtractor);
    }

    private ValueExtractorDefinition(@NotNull Argument<ValueExtractor<T>> argument, @NotNull Argument<?> containerArgument, @NotNull ValueExtractor<T> valueExtractor) {
        this(containerArgument.getType(), ValueExtractorDefinition.findExtractedValue(containerArgument, valueExtractor).classValue("type").orElse(containerArgument.getType()), ValueExtractorDefinition.findExtractedTypeArgumentIndex(containerArgument), valueExtractor instanceof UnwrapByDefaultValueExtractor || argument.getAnnotationMetadata().hasAnnotation(UnwrapByDefault.class), valueExtractor);
    }

    @NonNull
    private static Integer findExtractedTypeArgumentIndex(@NotNull Argument<?> argument) {
        Argument[] typeParameters = argument.getTypeParameters();
        Integer typeArgumentIndex = null;
        for (int i = 0; i < typeParameters.length; ++i) {
            Argument typeParameter = typeParameters[i];
            if (!typeParameter.getAnnotationMetadata().hasAnnotation(ExtractedValue.class)) continue;
            if (typeArgumentIndex != null) {
                throw new ValueExtractorDefinitionException("ValueExtractor definition cannot have multiple @ExtractedValue");
            }
            typeArgumentIndex = i;
        }
        if (argument.getAnnotationMetadata().hasAnnotation(ExtractedValue.class)) {
            if (typeArgumentIndex != null) {
                throw new ValueExtractorDefinitionException("ValueExtractor definition cannot have multiple @ExtractedValue");
            }
            return null;
        }
        if (typeArgumentIndex != null) {
            return typeArgumentIndex;
        }
        if (typeParameters.length == 1) {
            return 0;
        }
        throw new ValueExtractorDefinitionException("ValueExtractor definition is missing @ExtractedValue on an argument: " + argument);
    }

    @Nullable
    private static AnnotationValue<?> findExtractedValue(@NotNull Argument<?> argument, ValueExtractor<?> valueExtractor) {
        Argument[] typeParameters;
        for (Argument typeParameter : typeParameters = argument.getTypeParameters()) {
            AnnotationValue annotationValue = typeParameter.getAnnotationMetadata().getAnnotation(ExtractedValue.class);
            if (annotationValue == null) continue;
            return annotationValue;
        }
        AnnotationValue annotationValue = argument.getAnnotationMetadata().getAnnotation(ExtractedValue.class);
        if (annotationValue == null) {
            if (typeParameters.length == 1) {
                return AnnotationValue.builder(ExtractedValue.class).build();
            }
            throw new ValueExtractorDefinitionException("ValueExtractor definition '" + valueExtractor + "' is missing @ExtractedValue!");
        }
        if (annotationValue.classValue("type").isEmpty()) {
            throw new ValueExtractorDefinitionException("ValueExtractor definition '" + valueExtractor + "' is missing @ExtractedValue type value!");
        }
        return annotationValue;
    }
}

