/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.aop.Intercepted;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentValue;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import io.micronaut.validation.ConstraintViolationExceptionUtil;
import io.micronaut.validation.annotation.ValidatedElement;
import io.micronaut.validation.validator.BeanValidationContext;
import io.micronaut.validation.validator.DefaultConstraintDescriptor;
import io.micronaut.validation.validator.DefaultConstraintValidatorContext;
import io.micronaut.validation.validator.DefaultConstraintViolation;
import io.micronaut.validation.validator.EmptyDescriptor;
import io.micronaut.validation.validator.ExecutableMethodValidator;
import io.micronaut.validation.validator.IntrospectedBeanDescriptor;
import io.micronaut.validation.validator.ReactiveValidator;
import io.micronaut.validation.validator.ValidationPath;
import io.micronaut.validation.validator.Validator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.constraints.InternalConstraintValidatorFactory;
import io.micronaut.validation.validator.extractors.ValueExtractorDefinition;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import io.micronaut.validation.validator.messages.DefaultMessageInterpolatorContext;
import jakarta.inject.Singleton;
import jakarta.validation.ClockProvider;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Path;
import jakarta.validation.Payload;
import jakarta.validation.TraversableResolver;
import jakarta.validation.UnexpectedTypeException;
import jakarta.validation.Valid;
import jakarta.validation.ValidationException;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ValidateUnwrappedValue;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Primary
public class DefaultValidator
implements Validator,
ExecutableMethodValidator,
ReactiveValidator,
AnnotatedElementValidator,
BeanDefinitionValidator {
    private static final ValueExtractor<Object[]> LEGACY_ARRAY_EXTRACTOR = (originalValue, receiver) -> {
        int i = 0;
        for (Object item : originalValue) {
            receiver.indexedValue("<array element>", i++, item);
        }
    };
    final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorRegistry constraintValidatorRegistry;
    private final ClockProvider clockProvider;
    private final ValueExtractorRegistry valueExtractorRegistry;
    private final TraversableResolver traversableResolver;
    private final ExecutionHandleLocator executionHandleLocator;
    private final ConversionService conversionService;
    private final BeanIntrospector beanIntrospector;
    private final InternalConstraintValidatorFactory constraintValidatorFactory;
    private final boolean isPrependPropertyPath;

    public DefaultValidator(@NonNull ValidatorConfiguration configuration) {
        DefaultValidator.requireNonNull("configuration", configuration);
        this.constraintValidatorRegistry = configuration.getConstraintValidatorRegistry();
        this.clockProvider = configuration.getClockProvider();
        this.valueExtractorRegistry = configuration.getValueExtractorRegistry();
        this.traversableResolver = configuration.getTraversableResolver();
        this.executionHandleLocator = configuration.getExecutionHandleLocator();
        this.messageInterpolator = configuration.getMessageInterpolator();
        this.conversionService = configuration.getConversionService();
        this.beanIntrospector = configuration.getBeanIntrospector();
        this.constraintValidatorFactory = (InternalConstraintValidatorFactory)configuration.getConstraintValidatorFactory();
        this.isPrependPropertyPath = configuration.isPrependPropertyPath();
    }

    ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    public BeanIntrospector getBeanIntrospector() {
        return this.beanIntrospector;
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validate(@NonNull T object, Class<?> ... groups) {
        DefaultValidator.requireNonNull("object", object);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(object);
        if (introspection == null) {
            throw new ValidationException("Bean introspection not found for the class: " + object.getClass());
        }
        return this.validate(introspection, object, BeanValidationContext.fromGroups(groups));
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T object, BeanValidationContext validationContext) {
        DefaultValidator.requireNonNull("object", object);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(object);
        if (introspection == null) {
            throw new ValidationException("Bean introspection not found for the class: " + object.getClass());
        }
        return this.validate(introspection, object, validationContext);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validate(@NonNull BeanIntrospection<T> introspection, @NonNull T object, Class<?> ... groups) {
        return this.validate(introspection, object, BeanValidationContext.fromGroups(groups));
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(BeanIntrospection<T> introspection, T object, BeanValidationContext context) {
        if (introspection == null) {
            throw new ValidationException("Passed object [" + object + "] cannot be introspected. Please annotate with @Introspected");
        }
        DefaultConstraintValidatorContext<T> constraintValidatorContext = new DefaultConstraintValidatorContext<T>(this, introspection, object, context);
        this.doValidate(constraintValidatorContext, introspection, object);
        return constraintValidatorContext.getOverallViolations();
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateProperty(@NonNull T object, @NonNull String propertyName, Class<?> ... groups) {
        return this.validateProperty(object, propertyName, BeanValidationContext.fromGroups(groups));
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, BeanValidationContext context) {
        DefaultValidator.requireNonNull("object", object);
        DefaultValidator.requireNonEmpty("propertyName", propertyName);
        context = context != null ? context : BeanValidationContext.DEFAULT;
        BeanIntrospection<T> introspection = this.getBeanIntrospection(object);
        if (introspection == null) {
            throw new ValidationException("Passed object [" + object + "] cannot be introspected. Please annotate with @Introspected");
        }
        Optional property = introspection.getProperty(propertyName);
        if (property.isEmpty()) {
            throw new IllegalArgumentException("Cannot find property with name: " + property);
        }
        DefaultConstraintValidatorContext<T> constraintValidationContext = new DefaultConstraintValidatorContext<T>(this, introspection, object, context);
        for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : constraintValidationContext.findGroupSequences(introspection)) {
            DefaultConstraintValidatorContext.GroupsValidation validation = constraintValidationContext.withGroupSequence(groupSequence);
            try {
                this.visitProperty(constraintValidationContext, object, (BeanProperty)property.get(), false);
                if (!validation.isFailed()) continue;
                Set<ConstraintViolation<T>> set = Collections.unmodifiableSet(constraintValidationContext.getOverallViolations());
                return set;
            }
            finally {
                if (validation == null) continue;
                validation.close();
            }
        }
        return Collections.unmodifiableSet(constraintValidationContext.getOverallViolations());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateValue(@NonNull Class<T> beanType, @NonNull String propertyName, @Nullable Object value, Class<?> ... groups) {
        DefaultValidator.requireNonNull("groups", groups);
        return this.validateValue(beanType, propertyName, value, BeanValidationContext.fromGroups(groups));
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, BeanValidationContext context) {
        DefaultValidator.requireNonNull("beanType", beanType);
        DefaultValidator.requireNonEmpty("propertyName", propertyName);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(beanType);
        if (introspection == null) {
            throw new ValidationException("Passed bean type [" + beanType + "] cannot be introspected. Please annotate with @Introspected");
        }
        BeanProperty beanProperty = (BeanProperty)introspection.getProperty(propertyName).orElseThrow(() -> new IllegalArgumentException("No property [" + propertyName + "] found on type: " + beanType));
        DefaultConstraintValidatorContext<Object> constraintContext = new DefaultConstraintValidatorContext<Object>(this, introspection, null, context);
        try (ValidationPath.ContextualPath ignored = constraintContext.getCurrentPath().addPropertyNode(beanProperty.getName());){
            if (this.isNotReachable(constraintContext, null)) {
                Set<ConstraintViolation<T>> set = Collections.unmodifiableSet(constraintContext.getOverallViolations());
                return set;
            }
            for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : constraintContext.findGroupSequences(introspection)) {
                DefaultConstraintValidatorContext.GroupsValidation validation = constraintContext.withGroupSequence(groupSequence);
                try {
                    this.visitElement(constraintContext, null, beanProperty.asArgument(), beanProperty.asArgument().getAnnotationMetadata(), value, false);
                    if (!validation.isFailed()) continue;
                    Set<ConstraintViolation<T>> set = Collections.unmodifiableSet(constraintContext.getOverallViolations());
                    return set;
                }
                finally {
                    if (validation == null) continue;
                    validation.close();
                }
            }
        }
        return Collections.unmodifiableSet(constraintContext.getOverallViolations());
    }

    @NonNull
    public Set<String> validatedAnnotatedElement(@NonNull AnnotatedElement element, @Nullable Object value) {
        DefaultValidator.requireNonNull("element", element);
        if (!element.getAnnotationMetadata().hasStereotype(Constraint.class)) {
            return Collections.emptySet();
        }
        DefaultConstraintValidatorContext<Object> context = new DefaultConstraintValidatorContext<Object>(this, null, value, BeanValidationContext.DEFAULT);
        Argument type = value != null ? Argument.of(value.getClass(), (AnnotationMetadata)element.getAnnotationMetadata(), (Argument[])new Argument[0]) : Argument.OBJECT_ARGUMENT;
        boolean canCascade = true;
        try (ValidationPath.ContextualPath ignored = context.getCurrentPath().addPropertyNode(element.getName());){
            for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : context.findGroupSequences()) {
                try (DefaultConstraintValidatorContext.GroupsValidation validation = context.withGroupSequence(groupSequence);){
                    this.visitElement(context, element, type, value, canCascade);
                    if (validation.isFailed()) {
                        Set<String> set = context.getOverallViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toUnmodifiableSet());
                        return set;
                    }
                }
                canCascade = false;
            }
        }
        return context.getOverallViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NonNull
    public <T> T createValid(@NonNull Class<T> beanType, Object ... arguments) throws ConstraintViolationException {
        DefaultValidator.requireNonNull("type", beanType);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(beanType);
        if (introspection == null) {
            throw new ValidationException("Passed bean type [" + beanType + "] cannot be introspected. Please annotate with @Introspected");
        }
        Set<ConstraintViolation<T>> constraintViolations = this.validateConstructorParameters(introspection, arguments, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw ConstraintViolationExceptionUtil.createConstraintViolationException(this.isPrependPropertyPath, constraintViolations);
        }
        Object instance = introspection.instantiate(arguments);
        Set<ConstraintViolation<Object>> errors = this.validate(introspection, instance, new Class[0]);
        if (errors.isEmpty()) {
            return (T)instance;
        }
        throw ConstraintViolationExceptionUtil.createConstraintViolationException(this.isPrependPropertyPath, errors);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return this.beanIntrospector.findIntrospection(clazz).map(IntrospectedBeanDescriptor::new).orElseGet(() -> new EmptyDescriptor(clazz));
    }

    public <T> T unwrap(Class<T> type) {
        throw new UnsupportedOperationException("Validator unwrapping not supported by this implementation");
    }

    @Override
    @NonNull
    public ExecutableMethodValidator forExecutables() {
        return this;
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull ExecutableMethod method, @NonNull Object[] parameterValues, Class<?> ... groups) {
        DefaultValidator.requireNonNull("groups", groups);
        return this.validateParameters(object, method, parameterValues, BeanValidationContext.fromGroups(groups));
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateParameters(T object, ExecutableMethod method, @NonNull Object[] parameterValues, BeanValidationContext validationContext) {
        DefaultValidator.requireNonNull("parameterValues", parameterValues);
        DefaultValidator.requireNonNull("object", object);
        DefaultValidator.requireNonNull("method", method);
        DefaultValidator.requireNonNull("context", validationContext);
        Argument[] arguments = method.getArguments();
        int argLen = arguments.length;
        if (argLen != parameterValues.length) {
            throw new IllegalArgumentException("The method parameter array must have exactly " + argLen + " elements.");
        }
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(this, null, object, validationContext);
        try (DefaultConstraintValidatorContext.ValidationCloseable ignored1 = context.withExecutableParameterValues(parameterValues);
             ValidationPath.ContextualPath ignored = context.getCurrentPath().addMethodNode((MethodReference<?, ?>)method);){
            AnnotationMetadata methodAnnotationMetadata = method.getAnnotationMetadata().getDeclaredMetadata();
            this.validateParametersInternal(context, object, methodAnnotationMetadata, parameterValues, arguments, argLen);
        }
        return Collections.unmodifiableSet(context.getOverallViolations());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull ExecutableMethod method, @NonNull Collection<MutableArgumentValue<?>> argumentValues, Class<?> ... groups) {
        DefaultValidator.requireNonNull("object", object);
        DefaultValidator.requireNonNull("method", method);
        DefaultValidator.requireNonNull("parameterValues", argumentValues);
        DefaultValidator.requireNonNull("groups", groups);
        Argument[] arguments = method.getArguments();
        int argLen = arguments.length;
        if (argLen != argumentValues.size()) {
            throw new IllegalArgumentException("The method parameter array must have exactly " + argLen + " elements.");
        }
        Object[] parameters = argumentValues.stream().map(ArgumentValue::getValue).toArray();
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(this, null, object, BeanValidationContext.fromGroups(groups));
        try (DefaultConstraintValidatorContext.ValidationCloseable ignored1 = context.withExecutableParameterValues(parameters);
             ValidationPath.ContextualPath ignored = context.getCurrentPath().addMethodNode((MethodReference<?, ?>)method);){
            AnnotationMetadata methodAnnotationMetadata = method.getAnnotationMetadata().getDeclaredMetadata();
            this.validateParametersInternal(context, object, methodAnnotationMetadata, parameters, arguments, argLen);
        }
        return Collections.unmodifiableSet(context.getOverallViolations());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull Method method, @NonNull Object[] parameterValues, Class<?> ... groups) {
        DefaultValidator.requireNonNull("method", method);
        DefaultValidator.requireNonNull("groups", groups);
        return this.executionHandleLocator.findExecutableMethod(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes()).map(executableMethod -> this.validateParameters(object, (ExecutableMethod)executableMethod, parameterValues, groups)).orElse(Collections.emptySet());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@NonNull T object, @NonNull Method method, @Nullable Object returnValue, Class<?> ... groups) {
        DefaultValidator.requireNonNull("method", method);
        DefaultValidator.requireNonNull("object", object);
        DefaultValidator.requireNonNull("groups", groups);
        return this.executionHandleLocator.findExecutableMethod(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes()).map(executableMethod -> this.validateReturnValue(object, (ExecutableMethod<?, Object>)executableMethod, returnValue, groups)).orElse(Collections.emptySet());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@NonNull T bean, @NonNull ExecutableMethod<?, Object> executableMethod, @Nullable Object returnValue, Class<?> ... groups) {
        DefaultValidator.requireNonNull("groups", groups);
        return this.validateReturnValue(bean, executableMethod, returnValue, BeanValidationContext.fromGroups(groups));
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateReturnValue(T bean, ExecutableMethod<?, Object> executableMethod, Object returnValue, BeanValidationContext validationContext) {
        ReturnType returnType = executableMethod.getReturnType();
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(this, null, bean, validationContext);
        try (DefaultConstraintValidatorContext.ValidationCloseable ignored1 = context.withExecutableReturnValue(returnValue);
             ValidationPath.ContextualPath ignored2 = context.getCurrentPath().addMethodNode((MethodReference<?, ?>)executableMethod);
             ValidationPath.ContextualPath ignored3 = context.getCurrentPath().addReturnValueNode();){
            BeanIntrospection<T> beanIntrospection;
            List<DefaultConstraintValidatorContext.ValidationGroup> groupSequences = bean == null ? context.findGroupSequences() : ((beanIntrospection = this.getBeanIntrospection(bean)) == null ? context.findGroupSequences() : context.findGroupSequences(beanIntrospection));
            boolean canCascade = true;
            Iterator<DefaultConstraintValidatorContext.ValidationGroup> iterator = groupSequences.iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                DefaultConstraintValidatorContext.ValidationGroup groupSequence = iterator.next();
                try (DefaultConstraintValidatorContext.GroupsValidation validation = context.withGroupSequence(groupSequence);){
                    Object returnAm = returnType.asArgument().getAnnotationMetadata();
                    if (returnAm instanceof AnnotationMetadataHierarchy) {
                        AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)returnAm;
                        returnAm = returnAm.getDeclaredMetadata() instanceof AnnotationMetadataHierarchy ? new AnnotationMetadataHierarchy(new AnnotationMetadata[]{annotationMetadataHierarchy.getRootMetadata(), annotationMetadataHierarchy.getDeclaredMetadata().getDeclaredMetadata()}) : annotationMetadataHierarchy.getDeclaredMetadata();
                    }
                    this.visitElement(context, bean, (Argument)returnType.asArgument(), (AnnotationMetadata)returnAm, (Object)returnValue, canCascade, false);
                    if (validation.isFailed()) {
                        Set<ConstraintViolation<T>> set = context.getOverallViolations();
                        return set;
                    }
                }
                canCascade = false;
            }
        }
        return context.getOverallViolations();
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@NonNull Constructor<? extends T> constructor, @NonNull Object[] parameterValues, Class<?> ... groups) {
        DefaultValidator.requireNonNull("constructor", constructor);
        DefaultValidator.requireNonNull("groups", groups);
        Class<? extends T> declaringClass = constructor.getDeclaringClass();
        BeanIntrospection<? extends T> introspection = this.getBeanIntrospection(declaringClass);
        return this.validateConstructorParameters(introspection, parameterValues, new Class[0]);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@NonNull BeanIntrospection<? extends T> introspection, @NonNull Object[] parameterValues, Class<?> ... groups) {
        DefaultValidator.requireNonNull("introspection", introspection);
        DefaultValidator.requireNonNull("groups", groups);
        Class beanType = introspection.getBeanType();
        Argument[] constructorArguments = introspection.getConstructorArguments();
        return this.validateConstructorParameters(beanType, constructorArguments, parameterValues, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Class<? extends T> beanType, Argument<?>[] constructorArguments, @NonNull Object[] parameterValues, @NonNull Class<?>[] groups) {
        DefaultValidator.requireNonNull("groups", groups);
        return this.validateConstructorParameters(beanType, constructorArguments, parameterValues, BeanValidationContext.fromGroups(groups));
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Class<? extends T> beanType, @NonNull Argument<?>[] constructorArguments, @NonNull Object[] parameterValues, BeanValidationContext validationContext) {
        int argLength;
        if ((parameterValues = parameterValues != null ? parameterValues : ArrayUtils.EMPTY_OBJECT_ARRAY).length != (argLength = constructorArguments.length)) {
            throw new IllegalArgumentException("Expected exactly [" + argLength + "] constructor arguments");
        }
        DefaultConstraintValidatorContext<Class<T>> context = new DefaultConstraintValidatorContext<Class<T>>(this, null, beanType, validationContext);
        try (DefaultConstraintValidatorContext.ValidationCloseable ignored1 = context.withExecutableParameterValues(parameterValues);
             ValidationPath.ContextualPath ignored = context.getCurrentPath().addConstructorNode(beanType.getSimpleName(), constructorArguments);){
            this.validateParametersInternal(context, null, AnnotationMetadata.EMPTY_METADATA, parameterValues, constructorArguments, argLength);
        }
        return Collections.unmodifiableSet(context.getOverallViolations());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(@NonNull Constructor<? extends T> constructor, @NonNull T createdObject, Class<?> ... groups) {
        DefaultValidator.requireNonNull("groups", groups);
        return this.validate(createdObject, groups);
    }

    @Override
    @NonNull
    public <T> Publisher<T> validatePublisher(@NonNull ReturnType<?> returnType, @NonNull Publisher<T> publisher, Class<?> ... groups) {
        DefaultValidator.requireNonNull("publisher", publisher);
        DefaultValidator.requireNonNull("returnType", returnType);
        DefaultValidator.requireNonNull("groups", groups);
        if (returnType.getTypeParameters().length == 0) {
            return publisher;
        }
        Argument typeParameter = returnType.getTypeParameters()[0];
        Argument publisherArgument = Argument.of(publisher.getClass());
        Object output = Publishers.isSingle((Class)returnType.getType()) ? Mono.from(publisher).flatMap(value -> {
            Set<ConstraintViolation<?>> violations = this.validatePublisherValue(publisherArgument, publisher, groups, typeParameter, value, true);
            return violations.isEmpty() ? Mono.just((Object)value) : Mono.error((Throwable)new ConstraintViolationException(violations));
        }) : Flux.from(publisher).flatMap(value -> {
            Set<ConstraintViolation<?>> violations = this.validatePublisherValue(publisherArgument, publisher, groups, typeParameter, value, true);
            return violations.isEmpty() ? Flux.just((Object)value) : Flux.error((Throwable)new ConstraintViolationException(violations));
        });
        Class returnClass = returnType.getType();
        if (!Publisher.class.isAssignableFrom(returnClass)) {
            return output;
        }
        return (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)output, (Class)returnClass);
    }

    private <T, E> Set<? extends ConstraintViolation<?>> validatePublisherValue(Argument<T> publisherArgument, @NonNull T publisher, Class<?>[] groups, Argument<E> valueArgument, E value, boolean canCascade) {
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(this, null, publisher, BeanValidationContext.fromGroups(groups));
        try (ValidationPath.ContextualPath ignored = context.getCurrentPath().addReturnValueNode();
             ValidationPath.ContextualPath ignored1 = context.getCurrentPath().addContainerElementNode("<publisher element>", ValidationPath.DefaultContainerContext.ofIterableContainer(publisherArgument.getType()));){
            for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : context.findGroupSequences()) {
                DefaultConstraintValidatorContext.GroupsValidation ignore = context.withGroupSequence(groupSequence);
                try {
                    this.visitElement(context, publisher, valueArgument, value, canCascade);
                }
                finally {
                    if (ignore == null) continue;
                    ignore.close();
                }
            }
        }
        return context.getOverallViolations();
    }

    @Override
    @NonNull
    public <T> CompletionStage<T> validateCompletionStage(@NonNull CompletionStage<T> completionStage, @NonNull Argument<T> argument, Class<?> ... groups) {
        DefaultValidator.requireNonNull("completionStage", completionStage);
        DefaultValidator.requireNonNull("groups", groups);
        DefaultConstraintValidatorContext<Object> context = new DefaultConstraintValidatorContext<Object>(this, null, null, BeanValidationContext.fromGroups(groups));
        Iterator<DefaultConstraintValidatorContext.ValidationGroup> iterator = context.findGroupSequences().iterator();
        if (iterator.hasNext()) {
            DefaultConstraintValidatorContext.ValidationGroup groupSequence = iterator.next();
            try (DefaultConstraintValidatorContext.GroupsValidation ignore = context.withGroupSequence(groupSequence);){
                CompletionStage<T> completionStage2 = this.instrumentCompletionStage(context, completionStage, argument, true);
                return completionStage2;
            }
        }
        return completionStage;
    }

    public <T> void validateBeanArgument(@NonNull BeanResolutionContext resolutionContext, @NonNull InjectionPoint injectionPoint, @NonNull Argument<T> argument, int index, @Nullable T value) throws BeanInstantiationException {
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        boolean hasValid = annotationMetadata.hasStereotype(Valid.class);
        boolean hasConstraint = annotationMetadata.hasStereotype(Constraint.class);
        if (!hasConstraint && !hasValid) {
            return;
        }
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(this, null, value, BeanValidationContext.DEFAULT);
        Class rootClass = injectionPoint.getDeclaringBean().getBeanType();
        boolean canCascade = true;
        try (ValidationPath.ContextualPath ignored = context.getCurrentPath().addConstructorNode(rootClass.getName(), injectionPoint.getDeclaringBean().getConstructor().getArguments());
             ValidationPath.ContextualPath ignored1 = context.getCurrentPath().addPropertyNode(argument.getName());
             DefaultConstraintValidatorContext.ValidationCloseable ignore4 = context.convertGroups(argument.getAnnotationMetadata());){
            for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : context.findGroupSequences()) {
                try (DefaultConstraintValidatorContext.GroupsValidation validation = context.withGroupSequence(groupSequence);){
                    this.visitElement(context, null, argument, value, canCascade);
                    if (validation.isFailed()) {
                        this.failOnError(resolutionContext, context.getOverallViolations(), rootClass);
                    }
                }
                canCascade = false;
            }
        }
        this.failOnError(resolutionContext, context.getOverallViolations(), rootClass);
    }

    public <T> void validateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull T bean) throws BeanInstantiationException {
        Class beanType;
        if (definition instanceof ProxyBeanDefinition) {
            ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)definition;
            beanType = proxyBeanDefinition.getTargetType();
        } else {
            beanType = definition.getBeanType();
        }
        BeanIntrospection<T> introspection = this.getBeanIntrospection(bean, beanType);
        if (introspection != null) {
            Set<ConstraintViolation<T>> errors = this.validate(introspection, bean, new Class[0]);
            this.failOnError(resolutionContext, errors, beanType);
        } else if (bean instanceof Intercepted && definition.hasStereotype(ConfigurationReader.class)) {
            Collection executableMethods = definition.getExecutableMethods();
            if (CollectionUtils.isEmpty((Collection)executableMethods)) {
                return;
            }
            DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(this, null, bean, BeanValidationContext.DEFAULT);
            Object[] interfaces = beanType.getInterfaces();
            String constructorName = ArrayUtils.isNotEmpty((Object[])interfaces) ? ((Class)interfaces[0]).getSimpleName() : beanType.getSimpleName();
            try (ValidationPath.ContextualPath ignored = context.getCurrentPath().addConstructorNode(constructorName, new Argument[0]);){
                for (ExecutableMethod executableMethod : executableMethods) {
                    if (!executableMethod.hasAnnotation(Property.class)) continue;
                    boolean hasConstraint = executableMethod.hasStereotype(Constraint.class);
                    boolean isValid = executableMethod.hasStereotype(Valid.class);
                    if (!hasConstraint && !isValid) continue;
                    Object value = executableMethod.invoke(bean, new Object[0]);
                    ReturnType returnType = executableMethod.getReturnType();
                    ValidationPath.ContextualPath ignored1 = context.getCurrentPath().addPropertyNode(executableMethod.getName());
                    try {
                        DefaultConstraintValidatorContext.ValidationCloseable ignore2 = context.convertGroups(executableMethod.getAnnotationMetadata());
                        try {
                            boolean canCascade = true;
                            for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : context.findGroupSequences()) {
                                try (DefaultConstraintValidatorContext.GroupsValidation validation = context.withGroupSequence(groupSequence);){
                                    this.visitElement(context, bean, returnType.asArgument(), value, canCascade);
                                    if (validation.isFailed()) {
                                        this.failOnError(resolutionContext, context.getOverallViolations(), beanType);
                                    }
                                }
                                canCascade = false;
                            }
                        }
                        finally {
                            if (ignore2 == null) continue;
                            ignore2.close();
                        }
                    }
                    finally {
                        if (ignored1 == null) continue;
                        ignored1.close();
                    }
                }
            }
            this.failOnError(resolutionContext, context.getOverallViolations(), beanType);
        } else {
            throw new BeanInstantiationException(resolutionContext, "Cannot validate bean [" + beanType.getName() + "]. No bean introspection present. Please add @Introspected.");
        }
    }

    @Nullable
    protected <T> BeanIntrospection<T> getBeanIntrospection(@NonNull T object, @NonNull Class<T> definedClass) {
        if (object == null) {
            return null;
        }
        return this.beanIntrospector.findIntrospection(object.getClass()).orElseGet(() -> this.beanIntrospector.findIntrospection(definedClass).orElse(null));
    }

    @Nullable
    protected <T> BeanIntrospection<T> getBeanIntrospection(@NonNull T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Class) {
            return this.getBeanIntrospection((Class)object);
        }
        return this.beanIntrospector.findIntrospection(object.getClass()).orElse(null);
    }

    @Nullable
    protected <T> BeanIntrospection<T> getBeanIntrospection(@NonNull Class<T> type) {
        return this.beanIntrospector.findIntrospection(type).orElse(null);
    }

    private <R, E> void instrumentPublisherArgumentWithValidation(@NonNull DefaultConstraintValidatorContext<R> context, @NonNull Object[] argumentValues, int argumentIndex, @NonNull Argument<E> publisherArgument, E parameterValue, boolean canCascade) {
        Publisher publisher = (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, parameterValue, Publisher.class);
        DefaultConstraintValidatorContext valueContext = context.copy();
        Object objectPublisher = publisherArgument.isSpecifiedSingle() ? Mono.from((Publisher)publisher).flatMap(value -> {
            this.validatePublishedValue(valueContext, publisherArgument, parameterValue, value, canCascade);
            return valueContext.getOverallViolations().isEmpty() ? Mono.just((Object)value) : Mono.error((Throwable)new ConstraintViolationException(valueContext.getOverallViolations()));
        }) : Flux.from((Publisher)publisher).flatMap(value -> {
            this.validatePublishedValue(valueContext, publisherArgument, parameterValue, value, canCascade);
            return valueContext.getOverallViolations().isEmpty() ? Flux.just((Object)value) : Flux.error((Throwable)new ConstraintViolationException(valueContext.getOverallViolations()));
        });
        argumentValues[argumentIndex] = Publishers.convertPublisher((ConversionService)this.conversionService, (Object)objectPublisher, (Class)publisherArgument.getType());
    }

    private <R, E> void validatePublishedValue(@NonNull DefaultConstraintValidatorContext<R> context, @NonNull Argument<E> publisherArgument, E value, @NonNull Object publisherInstance, boolean canCascade) {
        Argument[] typeParameters = publisherArgument.getTypeParameters();
        if (typeParameters.length == 0) {
            return;
        }
        Argument valueArgument = typeParameters[0];
        try (ValidationPath.ContextualPath ignored1 = context.getCurrentPath().addContainerElementNode("<publisher element>", ValidationPath.DefaultContainerContext.ofIterableContainer(value.getClass()));){
            this.visitElement(context, context.getRootBean(), valueArgument, publisherInstance, canCascade);
        }
    }

    private <T, E> void instrumentCompletionStageArgumentWithValidation(@NonNull DefaultConstraintValidatorContext<T> context, @NonNull Object[] argumentValues, int argumentIndex, @NonNull Argument<E> completionStageArgument, E parameterValue, boolean canCascade) {
        CompletionStage completionStage = (CompletionStage)parameterValue;
        Argument valueArgument = completionStageArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        argumentValues[argumentIndex] = this.instrumentCompletionStage(context.copy(), completionStage, valueArgument, canCascade);
    }

    private <T, E> CompletionStage<E> instrumentCompletionStage(DefaultConstraintValidatorContext<T> context, CompletionStage<E> completionStage, Argument<E> argument, boolean canCascade) {
        return completionStage.thenApply(value -> {
            try (ValidationPath.ContextualPath ignored1 = context.getCurrentPath().addContainerElementNode("<completion stage element>", ValidationPath.DefaultContainerContext.ofContainer(CompletionStage.class));){
                this.visitElement(context, context.getRootBean(), argument, value, canCascade);
            }
            if (!context.getOverallViolations().isEmpty()) {
                throw ConstraintViolationExceptionUtil.createConstraintViolationException(this.isPrependPropertyPath, context.getOverallViolations());
            }
            return value;
        });
    }

    private <T> void validateParametersInternal(@NonNull DefaultConstraintValidatorContext<T> context, @Nullable T bean, @NonNull AnnotationMetadata methodAnnotationMetadata, @NonNull Object[] parameters, @NonNull Argument<?>[] arguments, int argLen) {
        BeanIntrospection<T> beanIntrospection;
        List<DefaultConstraintValidatorContext.ValidationGroup> groupSequences = bean == null ? context.findGroupSequences() : ((beanIntrospection = this.getBeanIntrospection(bean)) == null ? context.findGroupSequences() : context.findGroupSequences(beanIntrospection));
        boolean canCascade = true;
        for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : groupSequences) {
            try (DefaultConstraintValidatorContext.GroupsValidation validation = context.withGroupSequence(groupSequence);){
                if (methodAnnotationMetadata.hasStereotype(Constraint.class)) {
                    try (ValidationPath.ContextualPath ignored = context.getCurrentPath().addCrossParameterNode();){
                        this.validateConstrains(context, bean, Argument.of(Object[].class, (AnnotationMetadata)methodAnnotationMetadata, (Argument[])new Argument[0]), parameters);
                    }
                }
                for (int parameterIndex = 0; parameterIndex < argLen; ++parameterIndex) {
                    Argument<?> argument = arguments[parameterIndex];
                    if (!argument.getAnnotationMetadata().hasAnnotation(ValidatedElement.class)) continue;
                    try (ValidationPath.ContextualPath ignored = context.getCurrentPath().addParameterNode(argument.getName(), parameterIndex);
                         DefaultConstraintValidatorContext.ValidationCloseable ignore = context.convertGroups(argument.getAnnotationMetadata());){
                        boolean isCompletionStage;
                        boolean isPublisher;
                        Class parameterType = argument.getType();
                        Object parameterValue = parameters[parameterIndex];
                        boolean hasValue = parameterValue != null;
                        boolean bl = isPublisher = hasValue && Publishers.isConvertibleToPublisher((Class)parameterType);
                        if (isPublisher) {
                            this.instrumentPublisherArgumentWithValidation(context, parameters, parameterIndex, argument, parameterValue, canCascade);
                            continue;
                        }
                        boolean bl2 = isCompletionStage = hasValue && CompletionStage.class.isAssignableFrom(parameterType);
                        if (isCompletionStage) {
                            this.instrumentCompletionStageArgumentWithValidation(context, parameters, parameterIndex, argument, parameterValue, canCascade);
                            continue;
                        }
                        this.visitElement(context, bean, argument, parameterValue, canCascade, false);
                        continue;
                    }
                }
                if (validation.isFailed()) {
                    return;
                }
            }
            canCascade = false;
        }
    }

    private <R, T> void doValidate(@NonNull DefaultConstraintValidatorContext<R> context, @NonNull BeanIntrospection<T> introspection, @NonNull T object) {
        if (context.isValidated(object)) {
            return;
        }
        boolean canCascade = true;
        try (DefaultConstraintValidatorContext.ValidationCloseable ignore = context.validating(object);){
            for (DefaultConstraintValidatorContext.ValidationGroup groupSequence : context.findGroupSequences(introspection)) {
                try (DefaultConstraintValidatorContext.GroupsValidation validation = context.withGroupSequence(groupSequence);){
                    try (ValidationPath.ContextualPath ignore2 = context.getCurrentPath().addBeanNode();){
                        this.visitElement(context, object, Argument.of((Class)introspection.getBeanType(), (AnnotationMetadata)introspection.getAnnotationMetadata(), (Argument[])new Argument[0]), object, false);
                    }
                    for (BeanProperty property : introspection.getBeanProperties()) {
                        this.visitProperty(context, object, property, canCascade);
                    }
                    if (validation.isFailed()) {
                        return;
                    }
                }
                canCascade = false;
            }
        }
    }

    private <R, T> void visitProperty(DefaultConstraintValidatorContext<R> context, T object, BeanProperty<T, Object> property, boolean canCascade) {
        if (property.isWriteOnly()) {
            return;
        }
        try (ValidationPath.ContextualPath ignored = context.getCurrentPath().addPropertyNode(property.getName());){
            if (this.isNotReachable(context, object) || !context.getValidationContext().isPropertyValidated(object, property)) {
                return;
            }
            try (DefaultConstraintValidatorContext.ValidationCloseable ignore = context.convertGroups(property.getAnnotationMetadata());){
                Object propertyValue;
                try {
                    propertyValue = property.get(object);
                }
                catch (Exception e) {
                    throw new ValidationException("Failed to get the value of property: " + property.getName());
                }
                this.visitElement(context, object, property.asArgument(), propertyValue, canCascade);
            }
        }
    }

    private <R, T> boolean isNotReachable(DefaultConstraintValidatorContext<R> context, T object) {
        ValidationPath currentPath = context.getCurrentPath();
        ValidationPath previousPath = currentPath.previousPath();
        try {
            return !this.traversableResolver.isReachable(object, currentPath.last(), context.getRootClass(), (Path)previousPath, ElementType.FIELD);
        }
        catch (Exception e) {
            throw new ValidationException("Cannot call 'isReachable' on traversableResolver: " + this.traversableResolver, (Throwable)e);
        }
    }

    private <R> boolean canCascade(@NonNull DefaultConstraintValidatorContext<R> context, Object leftBean) {
        try {
            ValidationPath currentPath = context.getCurrentPath();
            ValidationPath previousPath = currentPath.previousPath();
            return this.traversableResolver.isCascadable(leftBean, currentPath.last(), context.getRootClass(), (Path)previousPath, ElementType.FIELD);
        }
        catch (Exception e) {
            throw new ValidationException("Cannot call 'isCascadable' on traversableResolver: " + this.traversableResolver, (Throwable)e);
        }
    }

    private <R, E> void visitElement(DefaultConstraintValidatorContext<R> context, Object bean, Argument<E> elementArgument, E elementValue, boolean canCascade) {
        this.visitElement(context, bean, elementArgument, elementArgument.getAnnotationMetadata(), elementValue, canCascade);
    }

    private <R, E> void visitElement(DefaultConstraintValidatorContext<R> context, Object bean, Argument<E> elementArgument, AnnotationMetadata annotationMetadata, E elementValue, boolean canCascade) {
        this.visitElement(context, bean, elementArgument, annotationMetadata, elementValue, canCascade, canCascade && annotationMetadata.hasStereotype(Valid.class), true);
    }

    private <R, E> void visitElement(DefaultConstraintValidatorContext<R> context, Object bean, Argument<E> elementArgument, E elementValue, boolean canCascade, boolean needsCanCascadeCheck) {
        AnnotationMetadata annotationMetadata = elementArgument.getAnnotationMetadata();
        this.visitElement(context, bean, elementArgument, annotationMetadata, elementValue, canCascade, needsCanCascadeCheck);
    }

    private <R, E> void visitElement(DefaultConstraintValidatorContext<R> context, Object bean, Argument<E> elementArgument, AnnotationMetadata annotationMetadata, E elementValue, boolean canCascade, boolean needsCanCascadeCheck) {
        this.visitElement(context, bean, elementArgument, annotationMetadata, elementValue, canCascade, canCascade && annotationMetadata.hasStereotype(Valid.class), needsCanCascadeCheck);
    }

    private <R, E> void visitElement(DefaultConstraintValidatorContext<R> context, Object leftBean, Argument<E> elementArgument, AnnotationMetadata annotationMetadata, E elementValue, boolean canCascade, boolean hasValid, boolean needsCanCascadeCheck) {
        List<DefaultConstraintDescriptor<Annotation>> constraints = this.getConstraints(context, annotationMetadata);
        if (this.visitContainer(context, leftBean, elementArgument, annotationMetadata, elementValue, constraints, canCascade)) {
            return;
        }
        if (!constraints.isEmpty()) {
            this.validateConstrains(context, leftBean, elementArgument, elementValue, constraints);
        }
        if (canCascade && hasValid && elementValue != null) {
            try (DefaultConstraintValidatorContext.ValidationCloseable ignore = context.convertGroups(elementArgument.getAnnotationMetadata());){
                this.propagateValidation(context, leftBean, elementArgument, elementValue, needsCanCascadeCheck);
            }
        }
    }

    private <R, E> boolean visitContainer(final DefaultConstraintValidatorContext<R> context, final Object leftBean, Argument<E> containerArgument, AnnotationMetadata annotationMetadata, E containerValue, List<DefaultConstraintDescriptor<Annotation>> constraints, final boolean canCascade) {
        List<DefaultConstraintDescriptor<Annotation>> containerElementConstraints;
        if (!this.isValidated(containerArgument)) {
            return false;
        }
        final boolean isLegacyValid = annotationMetadata.hasAnnotation(Valid.class) && (Iterable.class.isAssignableFrom(containerArgument.getType()) || Map.class.isAssignableFrom(containerArgument.getType()) || Object[].class.isAssignableFrom(containerArgument.getType()));
        List<DefaultConstraintDescriptor<Annotation>> skipUnwrappingConstraints = constraints.stream().filter(c -> c.getValueUnwrapping() == ValidateUnwrappedValue.SKIP).toList();
        List<DefaultConstraintDescriptor<Annotation>> explicitUnwrappingConstraints = constraints.stream().filter(c -> c.getValueUnwrapping() == ValidateUnwrappedValue.UNWRAP).toList();
        List<ValueExtractorDefinition<Object>> valueExtractorDefinitions = this.valueExtractorRegistry.findValueExtractors(containerArgument.getType());
        if (valueExtractorDefinitions.isEmpty()) {
            if (isLegacyValid && Object[].class.isAssignableFrom(containerArgument.getType())) {
                containerArgument = Argument.of(Object[].class, (AnnotationMetadata)containerArgument.getAnnotationMetadata(), (Argument[])new Argument[0]);
                valueExtractorDefinitions = List.of(new ValueExtractorDefinition<Object[]>(Object[].class, Object.class, null, false, LEGACY_ARRAY_EXTRACTOR));
            } else {
                if (!explicitUnwrappingConstraints.isEmpty()) {
                    throw new ConstraintDeclarationException("Cannot unwrap the constraint no extractors are present!");
                }
                return false;
            }
        }
        if (!explicitUnwrappingConstraints.isEmpty() && valueExtractorDefinitions.size() > 1) {
            throw new ConstraintDeclarationException("Cannot unwrap the constraint when multiple value extractors are present!");
        }
        long unwrappedCount = valueExtractorDefinitions.stream().filter(ValueExtractorDefinition::unwrapByDefault).count();
        if (unwrappedCount > 1L) {
            throw new ConstraintDeclarationException("Multiple unwrap by default value extractors aren't allowed!");
        }
        if (unwrappedCount > 0L) {
            if ((long)valueExtractorDefinitions.size() != unwrappedCount) {
                valueExtractorDefinitions = valueExtractorDefinitions.stream().filter(ValueExtractorDefinition::unwrapByDefault).toList();
            }
            containerElementConstraints = new ArrayList<DefaultConstraintDescriptor<Annotation>>(constraints);
            containerElementConstraints.removeAll(skipUnwrappingConstraints);
            this.validateConstrains(context, leftBean, containerArgument, containerValue, skipUnwrappingConstraints);
        } else {
            containerElementConstraints = explicitUnwrappingConstraints;
            ArrayList<DefaultConstraintDescriptor<Annotation>> containerConstraints = new ArrayList<DefaultConstraintDescriptor<Annotation>>(constraints);
            containerConstraints.removeAll(explicitUnwrappingConstraints);
            this.validateConstrains(context, leftBean, containerArgument, containerValue, containerConstraints);
        }
        for (ValueExtractorDefinition<Object> valueExtractorDefinition : valueExtractorDefinitions) {
            Argument containerValueArgument;
            if (isLegacyValid && valueExtractorDefinition.containerType().equals(Map.class) && valueExtractorDefinition.typeArgumentIndex() == 0) continue;
            Integer typeArgumentIndex = valueExtractorDefinition.typeArgumentIndex();
            Argument[] typeParameters = containerArgument.getTypeParameters();
            if (typeArgumentIndex != null && typeArgumentIndex >= 0 && typeParameters.length > 0 && typeArgumentIndex < typeParameters.length) {
                containerValueArgument = typeParameters[typeArgumentIndex];
            } else {
                containerValueArgument = Argument.of(valueExtractorDefinition.valueType());
                typeArgumentIndex = null;
            }
            if (!this.isValidated(containerValueArgument) && containerElementConstraints.isEmpty() && !isLegacyValid) continue;
            if (containerValue == null) {
                this.validateConstrains(context, leftBean, containerValueArgument, null, containerElementConstraints);
                continue;
            }
            ValueExtractor<Object> valueExtractor = valueExtractorDefinition.valueExtractor();
            try {
                final Integer finalTypeArgumentIndex = typeArgumentIndex;
                final Argument finalContainerArgument = containerArgument;
                valueExtractor.extractValues(containerValue, new ValueExtractor.ValueReceiver(){

                    public void value(String nodeName, Object val) {
                        ValidationPath.ContainerContext containerContext = ValidationPath.ContainerContext.value(finalContainerArgument.getType(), finalTypeArgumentIndex);
                        this.validateContainerValue(context, nodeName, containerContext, val);
                    }

                    public void iterableValue(String nodeName, Object iterableValue) {
                        ValidationPath.ContainerContext containerContext = ValidationPath.ContainerContext.iterable(finalContainerArgument.getType(), finalTypeArgumentIndex);
                        this.validateContainerValue(context, nodeName, containerContext, iterableValue);
                    }

                    public void indexedValue(String nodeName, int index, Object iterableValue) {
                        ValidationPath.ContainerContext containerContext = ValidationPath.ContainerContext.indexed(finalContainerArgument.getType(), index, finalTypeArgumentIndex);
                        this.validateContainerValue(context, nodeName, containerContext, iterableValue);
                    }

                    public void keyedValue(String nodeName, Object key, Object val) {
                        ValidationPath.ContainerContext containerContext = ValidationPath.ContainerContext.keyed(finalContainerArgument.getType(), key, finalTypeArgumentIndex);
                        this.validateContainerValue(context, nodeName, containerContext, val);
                    }

                    private void validateContainerValue(Object value) {
                        DefaultValidator.this.validateConstrains(context, leftBean, containerValueArgument, value, containerElementConstraints);
                        DefaultValidator.this.visitElement(context, leftBean, containerValueArgument, containerValueArgument.getAnnotationMetadata(), value, canCascade, containerValueArgument.getAnnotationMetadata().hasStereotype(Valid.class) || isLegacyValid, true);
                    }

                    private <RX, EX> void validateContainerValue(DefaultConstraintValidatorContext<RX> context2, String name, ValidationPath.ContainerContext containerContext, EX value) {
                        if (name != null && !isLegacyValid) {
                            try (ValidationPath.ContextualPath ignored = context2.getCurrentPath().addContainerElementNode(name, containerContext);){
                                this.validateContainerValue(value);
                            }
                        }
                        try (ValidationPath.ContextualPath ignored = context2.getCurrentPath().withContainerContext(containerContext);){
                            this.validateContainerValue(value);
                        }
                    }
                });
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ValidationException("Exception extracting values using: " + valueExtractor, (Throwable)e);
            }
        }
        return true;
    }

    private <E> boolean isValidated(Argument<E> containerArgument) {
        return containerArgument.getAnnotationMetadata().hasAnnotation(ValidatedElement.class);
    }

    private <R, E> void propagateValidation(DefaultConstraintValidatorContext<R> context, Object leftBean, Argument<E> elementType, E elementValue, boolean needsCanCascadeCheck) {
        BeanIntrospection<E> beanIntrospection = this.getBeanIntrospection(elementValue, elementType.getType());
        if (beanIntrospection == null) {
            ConstraintDescriptor<Annotation> constraintDescriptor = DefaultValidator.notIntrospectedConstraint(elementType, elementValue);
            DefaultConstraintViolation<R> violation = this.createConstraintViolation(context, leftBean, elementValue, constraintDescriptor);
            context.addViolation(violation);
            return;
        }
        if (!needsCanCascadeCheck || this.canCascade(context, leftBean)) {
            try (ValidationPath.ContextualPath ignore = context.getCurrentPath().cascaded();){
                this.doValidate(context, beanIntrospection, elementValue);
            }
        }
    }

    private <R, E> void validateConstrains(DefaultConstraintValidatorContext<R> context, @Nullable Object leftBean, @NonNull Argument<E> elementArgument, @Nullable E elementValue) {
        AnnotationMetadata annotationMetadata = elementArgument.getAnnotationMetadata();
        List<DefaultConstraintDescriptor<Annotation>> constraints = this.getConstraints(context, annotationMetadata);
        this.validateConstrains(context, leftBean, elementArgument, elementValue, constraints);
    }

    private <R, E> void validateConstrains(DefaultConstraintValidatorContext<R> context, @Nullable Object leftBean, Argument<E> elementArgument, @NonNull E elementValue, @NonNull List<DefaultConstraintDescriptor<Annotation>> constraints) {
        if (constraints.isEmpty()) {
            return;
        }
        ConstraintTarget constraintTarget = context.getCurrentPath().getConstraintTarget();
        for (DefaultConstraintDescriptor<Annotation> constraint : constraints) {
            context.constraint = constraint;
            if (constraint.getValidationAppliesTo() != ConstraintTarget.IMPLICIT && constraint.getValidationAppliesTo() != constraintTarget) continue;
            Class<Annotation> constraintType = constraint.getType();
            List<Class<jakarta.validation.ConstraintValidator<Annotation, ?>>> validatorClasses = constraint.getConstraintValidatorClasses();
            ConstraintValidator validator = null;
            if (!validatorClasses.isEmpty()) {
                for (Class<jakarta.validation.ConstraintValidator<Annotation, ?>> validatedBy : validatorClasses) {
                    Class<jakarta.validation.ConstraintValidator<Annotation, ?>> validatedByConstraint = validatedBy;
                    final jakarta.validation.ConstraintValidator<Annotation, ?> constraintValidator = this.constraintValidatorFactory.getInstance(validatedByConstraint, elementArgument.getType(), constraintTarget);
                    if (constraintValidator == null) continue;
                    if (constraintValidator instanceof ConstraintValidator) {
                        ConstraintValidator cv;
                        validator = cv = (ConstraintValidator)constraintValidator;
                        continue;
                    }
                    validator = new ConstraintValidator<Annotation, E>(){

                        public void initialize(Annotation constraintAnnotation) {
                            constraintValidator.initialize(constraintAnnotation);
                        }

                        @Override
                        public boolean isValid(E value, AnnotationValue<Annotation> annotationMetadata, ConstraintValidatorContext context) {
                            return constraintValidator.isValid(value, (jakarta.validation.ConstraintValidatorContext)context);
                        }
                    };
                    AnnotationValue<Annotation> annotationValue = constraint.getAnnotationValue();
                    MutableAnnotationMetadata mutableAnnotationMetadata = new MutableAnnotationMetadata();
                    mutableAnnotationMetadata.addAnnotation(annotationValue.getAnnotationName(), annotationValue.getValues());
                    try {
                        validator.initialize(mutableAnnotationMetadata.synthesize(Constraint.class));
                    }
                    catch (ValidationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ValidationException("Cannot call 'initialize' on: " + validatedBy, (Throwable)e);
                    }
                }
                if (validator == null) {
                    continue;
                }
            } else {
                if (constraintTarget == ConstraintTarget.PARAMETERS) continue;
                validator = this.constraintValidatorRegistry.findConstraintValidator(constraintType, elementArgument.getType()).orElse(null);
            }
            if (validator == null || validator == ConstraintValidator.VALID) {
                throw new UnexpectedTypeException("Cannot find a constraint validator for constraint: " + constraintType.getName() + " and type: " + elementArgument.getType());
            }
            try {
                if (validator.isValid(elementValue, constraint.getAnnotationValue(), context)) {
                    continue;
                }
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ValidationException("Cannot call 'isValid' on: " + validator.getClass().getName(), (Throwable)e);
            }
            if (!context.disableDefaultConstraintViolation) {
                DefaultConstraintViolation<R> constraintViolation = this.createConstraintViolation(context, leftBean, elementValue, constraint);
                context.addViolation(constraintViolation);
            } else if (context.getOverallViolations().isEmpty()) {
                throw new ValidationException("Default violation is disabled and no violations were added");
            }
            context.messageTemplate(null);
            context.constraint = null;
            context.disableDefaultConstraintViolation = false;
        }
    }

    private <R> DefaultConstraintViolation<R> createConstraintViolation(DefaultConstraintValidatorContext<R> context, Object leftBean, Object elementValue, ConstraintDescriptor<Annotation> constraint) {
        String messageTemplate = this.buildMessageTemplate(context, constraint);
        String message = this.messageInterpolator.interpolate(messageTemplate, (MessageInterpolator.Context)new DefaultMessageInterpolatorContext(context, constraint, elementValue));
        return new DefaultConstraintViolation<R>(context.getRootBean(), context.getRootClass(), leftBean, elementValue, message, messageTemplate, new ValidationPath(context.getCurrentPath()), constraint, context.getExecutableParameterValues(), context.getExecutableReturnValue());
    }

    private <R> boolean isConstraintIncluded(DefaultConstraintValidatorContext<R> context, DefaultConstraintDescriptor<?> constraint) {
        return context.containsGroup(constraint.getGroups());
    }

    private <R> List<DefaultConstraintDescriptor<Annotation>> getConstraints(DefaultConstraintValidatorContext<R> context, AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationTypesByStereotype(Constraint.class).stream().flatMap(constraintType -> {
            List annotationValuesByType = annotationMetadata.getAnnotationValuesByType(constraintType);
            if (annotationValuesByType.isEmpty()) {
                annotationValuesByType = annotationMetadata.getDeclaredAnnotationValuesByType(constraintType);
            }
            return annotationValuesByType.stream().map(annotationValue -> new DefaultConstraintDescriptor(constraintType, annotationValue, annotationMetadata)).filter(annotationValue -> this.isConstraintIncluded(context, (DefaultConstraintDescriptor<?>)annotationValue));
        }).toList();
    }

    private <R> String buildMessageTemplate(DefaultConstraintValidatorContext<R> context, ConstraintDescriptor<Annotation> constraint) {
        String messageTemplate = context.getMessageTemplate().orElse(null);
        if (messageTemplate != null) {
            return messageTemplate;
        }
        return constraint.getMessageTemplate();
    }

    private <T> void failOnError(@NonNull BeanResolutionContext resolutionContext, Set<ConstraintViolation<T>> errors, Class<?> beanType) {
        if (!errors.isEmpty()) {
            StringBuilder builder = new StringBuilder().append("Validation failed for bean definition [").append(beanType.getName()).append("]\nList of constraint violations:[\n");
            for (ConstraintViolation<T> violation : errors) {
                builder.append('\t').append(violation.getPropertyPath()).append(" - ").append(violation.getMessage()).append('\n');
            }
            builder.append(']');
            throw new BeanInstantiationException(resolutionContext, builder.toString());
        }
    }

    @Deprecated(since="4.3.0")
    public static <T> T requireNonNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument [" + name + "] cannot be null");
        }
        return value;
    }

    @Deprecated(since="4.3.0")
    public static String requireNonEmpty(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException("Argument [" + name + "] cannot be empty");
        }
        return value;
    }

    private static <E> ConstraintDescriptor<Annotation> notIntrospectedConstraint(final Argument<E> notIntrospectedArgument, final E elementValue) {
        return new ConstraintDescriptor<Annotation>(){

            public Annotation getAnnotation() {
                throw new IllegalStateException("Not supported!");
            }

            public String getMessageTemplate() {
                return "{" + Introspected.class.getName() + ".message}";
            }

            public Set<Class<?>> getGroups() {
                return Set.of();
            }

            public Set<Class<? extends Payload>> getPayload() {
                return Set.of();
            }

            public ConstraintTarget getValidationAppliesTo() {
                return ConstraintTarget.IMPLICIT;
            }

            public List<Class<? extends jakarta.validation.ConstraintValidator<Annotation, ?>>> getConstraintValidatorClasses() {
                return List.of();
            }

            public Map<String, Object> getAttributes() {
                String argType = notIntrospectedArgument.getType().getName();
                if (notIntrospectedArgument.isTypeVariable()) {
                    argType = elementValue.getClass().getName();
                }
                return Collections.singletonMap("type", argType);
            }

            public Set<ConstraintDescriptor<?>> getComposingConstraints() {
                return Set.of();
            }

            public boolean isReportAsSingleViolation() {
                return false;
            }

            public ValidateUnwrappedValue getValueUnwrapping() {
                return ValidateUnwrappedValue.DEFAULT;
            }

            public <U> U unwrap(Class<U> type) {
                throw new ValidationException("Not supported");
            }
        };
    }
}

