/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.exceptions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.validation.validator.ValidatorConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

@Produces
@Singleton
@Requires(classes={ConstraintViolationException.class, ExceptionHandler.class})
public class ConstraintExceptionHandler
implements ExceptionHandler<ConstraintViolationException, HttpResponse<?>> {
    private final ErrorResponseProcessor<?> responseProcessor;
    private final ValidatorConfiguration validatorConfiguration;

    @Inject
    public ConstraintExceptionHandler(ErrorResponseProcessor<?> responseProcessor, ValidatorConfiguration validatorConfiguration) {
        this.responseProcessor = responseProcessor;
        this.validatorConfiguration = validatorConfiguration;
    }

    public HttpResponse<?> handle(HttpRequest request, ConstraintViolationException exception) {
        Set constraintViolations = exception.getConstraintViolations();
        MutableHttpResponse response = HttpResponse.badRequest();
        ErrorContext.Builder contextBuilder = ErrorContext.builder((HttpRequest)request).cause((Throwable)exception);
        if (CollectionUtils.isEmpty((Collection)constraintViolations)) {
            return this.responseProcessor.processResponse(contextBuilder.errorMessage(exception.getMessage() == null ? HttpStatus.BAD_REQUEST.getReason() : exception.getMessage()).build(), response);
        }
        return this.responseProcessor.processResponse(contextBuilder.errorMessages(exception.getConstraintViolations().stream().map(this::buildMessage).sorted().toList()).build(), response);
    }

    protected String buildMessage(ConstraintViolation<?> violation) {
        Path propertyPath = violation.getPropertyPath();
        StringBuilder message = new StringBuilder();
        if (this.validatorConfiguration.isPrependPropertyPath()) {
            Iterator i = propertyPath.iterator();
            boolean firstNode = true;
            while (i.hasNext()) {
                Path.Node node = (Path.Node)i.next();
                if (node.getKind() == ElementKind.METHOD || node.getKind() == ElementKind.CONSTRUCTOR) continue;
                if (node.isInIterable()) {
                    message.append('[');
                    if (node.getKey() != null) {
                        message.append(node.getKey());
                    } else if (node.getIndex() != null) {
                        message.append(node.getIndex());
                    }
                    message.append(']');
                }
                if (node.getKind() != ElementKind.CONTAINER_ELEMENT && node.getName() != null) {
                    if (!firstNode) {
                        message.append('.');
                    }
                    message.append(node.getName());
                }
                firstNode = false;
            }
            message.append(": ");
        }
        message.append(violation.getMessage());
        return message.toString();
    }
}

