/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.validation.validator.DefaultConstraintViolation;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ValidationPath;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.GroupDefinitionException;
import jakarta.validation.GroupSequence;
import jakarta.validation.ValidationException;
import jakarta.validation.groups.ConvertGroup;
import jakarta.validation.groups.Default;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
final class DefaultConstraintValidatorContext<R>
implements ConstraintValidatorContext {
    private static final Map<Class<?>, List<Class<?>>> GROUP_SEQUENCES = new ConcurrentHashMap();
    private static final List<Class<?>> DEFAULT_GROUPS = Collections.singletonList(Default.class);
    private final DefaultValidator defaultValidator;
    private final BeanIntrospection<R> beanIntrospection;
    private final R rootBean;
    @Nullable
    private final Class<R> rootClass;
    private final Set<Object> validatedObjects = new HashSet<Object>(20);
    private final ValidationPath currentPath;
    private final List<Class<?>> definedGroups;
    private String messageTemplate = null;
    private final Set<ConstraintViolation<R>> overallViolations;
    @Nullable
    private Object[] executableParameterValues;
    @Nullable
    private Object executableReturnValue;
    private List<Class<?>> currentGroups;
    private Map<Class<?>, Class<?>> convertedGroups = Collections.emptyMap();
    private Set<ConstraintViolation<R>> currentViolations = new LinkedHashSet<ConstraintViolation<R>>();

    DefaultConstraintValidatorContext(DefaultValidator defaultValidator, BeanIntrospection<R> beanIntrospection, R rootBean, Class<?> ... groups) {
        this(defaultValidator, beanIntrospection, rootBean, null, null, new ValidationPath(), new LinkedHashSet<ConstraintViolation<R>>(), DefaultConstraintValidatorContext.processGroups(groups), Collections.emptyList());
    }

    private DefaultConstraintValidatorContext(DefaultValidator defaultValidator, BeanIntrospection<R> beanIntrospection, R rootBean, Object[] executableParameterValues, Object executableReturnValue, ValidationPath path, Set<ConstraintViolation<R>> overallViolations, List<Class<?>> definedGroups, List<Class<?>> currentGroups) {
        this.defaultValidator = defaultValidator;
        this.beanIntrospection = beanIntrospection;
        this.rootBean = rootBean;
        this.rootClass = beanIntrospection == null ? (rootBean == null ? null : rootBean.getClass()) : beanIntrospection.getBeanType();
        this.executableParameterValues = executableParameterValues;
        this.executableReturnValue = executableReturnValue;
        this.definedGroups = definedGroups;
        this.currentGroups = currentGroups;
        this.currentPath = path != null ? path : new ValidationPath();
        this.overallViolations = overallViolations;
    }

    private static List<Class<?>> processGroups(Class<?>[] definedGroups) {
        if (ArrayUtils.isEmpty((Object[])definedGroups)) {
            return DEFAULT_GROUPS;
        }
        DefaultConstraintValidatorContext.sanityCheckGroups(definedGroups);
        ArrayList groupList = new ArrayList();
        for (Class<?> group : definedGroups) {
            DefaultConstraintValidatorContext.addInheritedGroups(group, groupList);
        }
        return Collections.unmodifiableList(groupList);
    }

    private static void sanityCheckGroups(Class<?>[] groups) {
        ArgumentUtils.requireNonNull((String)"groups", groups);
        for (Class<?> clazz : groups) {
            if (clazz == null) {
                throw new IllegalArgumentException("Validation groups must be non-null");
            }
            if (clazz.isInterface()) continue;
            throw new IllegalArgumentException("Validation groups must be interfaces. " + clazz.getName() + " is not.");
        }
    }

    public boolean hasDefaultGroup() {
        return this.definedGroups.equals(DEFAULT_GROUPS);
    }

    public boolean containsGroup(Collection<Class<?>> constraintGroups) {
        if (this.currentGroups.contains(Default.class) && this.rootClass != null && constraintGroups.contains(this.rootClass)) {
            return true;
        }
        return this.currentGroups.stream().anyMatch(constraintGroups::contains);
    }

    public Object[] getExecutableParameterValues() {
        return this.executableParameterValues;
    }

    public Object getExecutableReturnValue() {
        return this.executableReturnValue;
    }

    public boolean isValidated(Object obj) {
        return this.validatedObjects.contains(obj);
    }

    public ValidationCloseable validating(Object obj) {
        this.validatedObjects.add(obj);
        return () -> this.validatedObjects.remove(obj);
    }

    public ValidationCloseable withExecutableParameterValues(Object[] executableParameterValues) {
        Object[] prevExecutableParameterValues = this.executableParameterValues;
        this.executableParameterValues = executableParameterValues;
        return () -> {
            this.executableParameterValues = prevExecutableParameterValues;
        };
    }

    public ValidationCloseable withExecutableReturnValue(Object executableReturnValue) {
        Object prevExecutableReturnValue = this.executableReturnValue;
        this.executableReturnValue = executableReturnValue;
        return () -> {
            this.executableReturnValue = prevExecutableReturnValue;
        };
    }

    public GroupsValidation withGroupSequence(final @NonNull ValidationGroup validationGroup) {
        final List<Class<?>> prevGroups = this.currentGroups;
        final Set<ConstraintViolation<R>> prevViolations = this.currentViolations;
        this.currentGroups = validationGroup.groups();
        this.currentViolations = new LinkedHashSet<ConstraintViolation<R>>();
        return new GroupsValidation(){

            @Override
            public boolean isFailed() {
                if (validationGroup.isRedefinedDefaultGroupSequence()) {
                    return !DefaultConstraintValidatorContext.this.overallViolations.isEmpty();
                }
                return !DefaultConstraintValidatorContext.this.currentViolations.isEmpty();
            }

            @Override
            public void close() {
                DefaultConstraintValidatorContext.this.currentGroups = prevGroups;
                DefaultConstraintValidatorContext.this.currentViolations = prevViolations;
            }
        };
    }

    public ValidationCloseable convertGroups(@NonNull AnnotationMetadata annotationMetadata) {
        List conversions = annotationMetadata.getAnnotationValuesByType(ConvertGroup.class);
        if (conversions.isEmpty()) {
            return () -> {};
        }
        Map<Class<?>, Class<?>> prevConvertedGroups = this.convertedGroups;
        List<Class<?>> prevGroups = this.currentGroups;
        this.convertedGroups = new HashMap(prevConvertedGroups);
        Map<Class, Class> newConvertGroups = conversions.stream().collect(Collectors.toMap(av -> av.classValue("from").orElse(Default.class), av -> (Class)av.classValue("to").orElseThrow()));
        this.convertedGroups.putAll(newConvertGroups);
        this.currentGroups = prevGroups.stream().map(this::convertGroup).toList();
        return () -> {
            this.convertedGroups = prevConvertedGroups;
            this.currentGroups = prevGroups;
        };
    }

    public List<ValidationGroup> findGroupSequences(BeanIntrospection<?> beanIntrospection) {
        Class[] classGroupSequence;
        if (this.hasDefaultGroup() && (classGroupSequence = beanIntrospection.classValues(GroupSequence.class)).length > 0) {
            if (Arrays.stream(classGroupSequence).noneMatch(c -> c == beanIntrospection.getBeanType())) {
                throw new GroupDefinitionException("Group sequence is missing default group defined by the class of: " + beanIntrospection.getBeanType());
            }
            return Arrays.stream(classGroupSequence).flatMap(group -> {
                if (group == beanIntrospection.getBeanType()) {
                    return Stream.of(new ValidationGroup(true, true, List.of(Default.class)));
                }
                return this.findGroupSequence(Collections.singletonList(group), new HashSet()).stream();
            }).toList();
        }
        return this.findGroupSequence(this.definedGroups, new HashSet());
    }

    public List<ValidationGroup> findGroupSequences() {
        return this.findGroupSequence(this.definedGroups, new HashSet());
    }

    private List<ValidationGroup> findGroupSequence(List<Class<?>> groups, Set<Class<?>> processedGroups) {
        return this.findGroups(groups, processedGroups).stream().toList();
    }

    private List<ValidationGroup> findGroups(Class<?> group, Set<Class<?>> processedGroups) {
        if (this.convertedGroups != null) {
            group = this.convertGroup(group);
        }
        if (!processedGroups.add(group)) {
            throw new GroupDefinitionException("Cyclical group: " + group);
        }
        Class<?> finalGroup = group;
        List groupSequence = GROUP_SEQUENCES.computeIfAbsent(group, ignore -> this.defaultValidator.getBeanIntrospector().findIntrospection(finalGroup).stream().flatMap(introspection -> Arrays.stream(introspection.classValues(GroupSequence.class))).toList());
        if (groupSequence.isEmpty()) {
            return List.of(new ValidationGroup(false, false, List.of(group)));
        }
        return groupSequence.stream().flatMap(g -> this.findGroups((Class<?>)g, processedGroups).stream().map(vg -> new ValidationGroup(true, true, vg.groups))).toList();
    }

    private Class<?> convertGroup(Class<?> group) {
        Class<?> newGroup = this.convertedGroups.get(group);
        if (newGroup == null) {
            return group;
        }
        return newGroup;
    }

    private List<ValidationGroup> findGroups(List<Class<?>> groupSequence, Set<Class<?>> processedGroups) {
        List<ValidationGroup> innerGroups = groupSequence.stream().flatMap(g -> this.findGroups((Class<?>)g, processedGroups).stream()).toList();
        if (innerGroups.stream().noneMatch(validationGroup -> validationGroup.isSequence)) {
            return List.of(new ValidationGroup(false, false, innerGroups.stream().flatMap(validationGroup -> validationGroup.groups.stream()).toList()));
        }
        return innerGroups;
    }

    public void addViolation(DefaultConstraintViolation<R> violation) {
        if (this.currentViolations != null) {
            this.currentViolations.add(violation);
        }
        this.overallViolations.add(violation);
    }

    public Set<ConstraintViolation<R>> getOverallViolations() {
        return this.overallViolations;
    }

    public ValidationPath getCurrentPath() {
        return this.currentPath;
    }

    @Nullable
    public R getRootBean() {
        return this.rootBean;
    }

    public Class<R> getRootClass() {
        return this.rootClass;
    }

    private static void addInheritedGroups(Class<?> group, List<Class<?>> groups) {
        if (!groups.contains(group)) {
            groups.add(group);
        }
        for (Class<?> inheritedGroup : group.getInterfaces()) {
            DefaultConstraintValidatorContext.addInheritedGroups(inheritedGroup, groups);
        }
    }

    public void disableDefaultConstraintViolation() {
        throw new ValidationException("Not supported");
    }

    public String getDefaultConstraintMessageTemplate() {
        throw new ValidationException("Not supported");
    }

    @Override
    @NonNull
    public ClockProvider getClockProvider() {
        return this.defaultValidator.getClockProvider();
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return null;
    }

    public <T> T unwrap(Class<T> type) {
        throw new ValidationException("Not supported");
    }

    @Override
    public void messageTemplate(@Nullable String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    Optional<String> getMessageTemplate() {
        return Optional.ofNullable(this.messageTemplate);
    }

    DefaultConstraintValidatorContext<R> copy() {
        return new DefaultConstraintValidatorContext<R>(this.defaultValidator, this.beanIntrospection, this.rootBean, this.executableParameterValues, this.executableReturnValue, new ValidationPath(this.currentPath), new LinkedHashSet<ConstraintViolation<R>>(this.overallViolations), this.definedGroups, this.currentGroups);
    }

    @Internal
    static interface ValidationCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }

    @Internal
    record ValidationGroup(boolean isSequence, boolean isRedefinedDefaultGroupSequence, List<Class<?>> groups) {
    }

    @Internal
    static interface GroupsValidation
    extends ValidationCloseable {
        public boolean isFailed();
    }
}

