/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.extractors;

import io.micronaut.core.annotation.NonNull;
import jakarta.validation.ValidationException;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.Optional;

public interface ValueExtractorRegistry {
    public <T> void addValueExtractor(Class<T> var1, ValueExtractor<T> var2);

    @NonNull
    public <T> Optional<ValueExtractor<T>> findValueExtractor(@NonNull Class<T> var1);

    @NonNull
    public <T> Optional<ValueExtractor<T>> findUnwrapValueExtractor(@NonNull Class<T> var1);

    @NonNull
    default public <T> ValueExtractor<T> getValueExtractor(@NonNull Class<T> targetType) {
        return this.findValueExtractor(targetType).orElseThrow(() -> new ValidationException("No value extractor for target type [" + targetType + "]"));
    }
}

