/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.extractors;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.validation.validator.extractors.UnwrapByDefaultValueExtractor;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

@Introspected(accessKind={Introspected.AccessKind.FIELD})
final class InternalValueExtractors {
    private static final String ITERABLE_ELEMENT_NODE_NAME = "<iterable element>";
    private static final String LIST_ELEMENT_NODE_NAME = "<list element>";
    private static final String MAP_VALUE_NODE_NAME = "<map value>";
    final UnwrapByDefaultValueExtractor<Optional<?>> optionalValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.orElse(null));
    final UnwrapByDefaultValueExtractor<OptionalInt> optionalIntValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.isPresent() ? Integer.valueOf(originalValue.getAsInt()) : null);
    final UnwrapByDefaultValueExtractor<OptionalLong> optionalLongValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.isPresent() ? Long.valueOf(originalValue.getAsLong()) : null);
    final UnwrapByDefaultValueExtractor<OptionalDouble> optionalDoubleValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.isPresent() ? Double.valueOf(originalValue.getAsDouble()) : null);
    final ValueExtractor<Iterable<?>> iterableValueExtractor = (originalValue, receiver) -> {
        if (originalValue instanceof List) {
            int i = 0;
            for (Object o : originalValue) {
                receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i++, o);
            }
        } else {
            for (Object o : originalValue) {
                receiver.iterableValue(ITERABLE_ELEMENT_NODE_NAME, o);
            }
        }
    };
    final ValueExtractor<Map<?, ?>> mapValueExtractor = (originalValue, receiver) -> {
        for (Map.Entry entry : originalValue.entrySet()) {
            receiver.keyedValue(MAP_VALUE_NODE_NAME, entry.getKey(), entry.getValue());
        }
    };

    InternalValueExtractors() {
    }

    public static List<Map.Entry<Argument<Object>, ValueExtractor<?>>> getValueExtractors() {
        InternalValueExtractors bean = new InternalValueExtractors();
        BeanWrapper wrapper = BeanWrapper.findWrapper(InternalValueExtractors.class, (Object)bean).orElse(null);
        if (wrapper == null) {
            throw new IllegalArgumentException("Cannot retrieve constraint validators");
        }
        return wrapper.getBeanProperties().stream().map(p -> Map.entry(p.asArgument(), (ValueExtractor)p.get((Object)bean))).toList();
    }
}

