/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.visitor;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.validation.RequiresValidation;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Set;

@Internal
public class ValidationVisitor
implements TypeElementVisitor<Object, Object> {
    private static final String ANN_CASCADE = "io.micronaut.validation.annotation.ValidatedElement";
    private static final String ANN_CONSTRAINT = "jakarta.validation.Constraint";
    private static final String ANN_VALID = "jakarta.validation.Valid";
    private ClassElement classElement;

    public Set<String> getSupportedAnnotationNames() {
        return Set.of("jakarta.validation.*");
    }

    public int getOrder() {
        return 10;
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        this.classElement = element;
        if (this.classElement.hasAnnotation("jakarta.validation.GroupSequence")) {
            this.classElement.annotate(Introspected.class);
        }
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        if (this.classElement == null) {
            return;
        }
        if (this.requiresValidation((TypedElement)element.getReturnType(), true) || this.parametersRequireValidation((MethodElement)element, true)) {
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        boolean requireOnConstraint;
        if (this.classElement == null) {
            return;
        }
        boolean isPrivate = element.isPrivate();
        boolean isAbstract = element.getOwningType().isInterface() || element.getOwningType().isAbstract();
        boolean bl = requireOnConstraint = isAbstract || !isPrivate;
        if (this.parametersRequireValidation(element, requireOnConstraint) || this.requiresValidation((TypedElement)element.getReturnType(), requireOnConstraint) || this.returnTypeRequiresValidation(element, true)) {
            if (isPrivate) {
                throw new ProcessingException((Element)element, "Method annotated for validation but is declared private. Change the method to be non-private in order for AOP advice to be applied.");
            }
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    public void visitField(FieldElement element, VisitorContext context) {
        if (this.classElement == null) {
            return;
        }
        if (this.requiresValidation((TypedElement)element, true)) {
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    private boolean parametersRequireValidation(MethodElement element, boolean requireOnConstraint) {
        boolean requiredValidation = false;
        for (ParameterElement parameter : element.getParameters()) {
            if (!this.requiresValidation((TypedElement)parameter, requireOnConstraint)) continue;
            requiredValidation = true;
            try {
                parameter.annotate(ANN_CASCADE);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return requiredValidation;
    }

    private boolean returnTypeRequiresValidation(MethodElement e, boolean requireOnConstraint) {
        return e.hasStereotype(ANN_VALID) || requireOnConstraint && e.hasStereotype(ANN_CONSTRAINT);
    }

    private boolean requiresValidation(TypedElement e, boolean requireOnConstraint) {
        AnnotationMetadata annotationMetadata;
        if (e instanceof ClassElement) {
            ClassElement ce = (ClassElement)e;
            v0 = ce.getTypeAnnotationMetadata();
        } else {
            v0 = annotationMetadata = e.getAnnotationMetadata();
        }
        if (annotationMetadata.hasStereotype(ANN_VALID)) {
            try {
                e.annotate(RequiresValidation.class);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return requireOnConstraint && annotationMetadata.hasStereotype(ANN_CONSTRAINT) || annotationMetadata.hasStereotype(ANN_VALID) || this.typeArgumentsRequireValidation(e, requireOnConstraint);
    }

    private boolean typeArgumentsRequireValidation(TypedElement e, boolean requireOnConstraint) {
        if (e instanceof GenericPlaceholderElement) {
            return false;
        }
        return e.getGenericType().getTypeArguments().values().stream().anyMatch(classElement -> this.requiresValidation((TypedElement)classElement, requireOnConstraint));
    }
}

