/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.oer.its.ieee1609dot2;

import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Object;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.testcontainers.shaded.org.bouncycastle.oer.its.ItsUtils;
import org.testcontainers.shaded.org.bouncycastle.oer.its.ieee1609dot2.SymmetricCiphertext;
import org.testcontainers.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.HashedId;
import org.testcontainers.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.HashedId8;

public class SymmRecipientInfo
extends ASN1Object {
    private final HashedId8 recipientId;
    private final SymmetricCiphertext encKey;

    public SymmRecipientInfo(HashedId8 hashedId8, SymmetricCiphertext symmetricCiphertext) {
        this.recipientId = hashedId8;
        this.encKey = symmetricCiphertext;
    }

    private SymmRecipientInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("expected sequence size of 2");
        }
        this.recipientId = HashedId8.getInstance(aSN1Sequence.getObjectAt(0));
        this.encKey = SymmetricCiphertext.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static SymmRecipientInfo getInstance(Object object) {
        if (object instanceof SymmRecipientInfo) {
            return (SymmRecipientInfo)object;
        }
        if (object != null) {
            return new SymmRecipientInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public HashedId getRecipientId() {
        return this.recipientId;
    }

    public SymmetricCiphertext getEncKey() {
        return this.encKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return ItsUtils.toSequence(this.recipientId, this.encKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HashedId8 recipientId;
        private SymmetricCiphertext encKey;

        public Builder setRecipientId(HashedId8 hashedId8) {
            this.recipientId = hashedId8;
            return this;
        }

        public Builder setEncKey(SymmetricCiphertext symmetricCiphertext) {
            this.encKey = symmetricCiphertext;
            return this;
        }

        public SymmRecipientInfo createSymmRecipientInfo() {
            return new SymmRecipientInfo(this.recipientId, this.encKey);
        }
    }
}

